package com.mmc.oms.model.qo.uav;

import com.mmc.oms.common.publicinterface.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/9/6 15:03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UavOrderQO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "关键字-订单编号", required = false)
    private String keyword;

    @ApiModelProperty(value = "用户uid", required = false)
    private String uid;

    @ApiModelProperty(value = "订单状态码")
    private Integer statusCode;

    @ApiModelProperty(value = "用户id", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "商家id", hidden = true)
    private Integer thirdBackUserAccountId;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
