package com.mmc.oms.model.dto.mall;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.oms.model.dto.kdn.KdnExpDTO;
import com.mmc.oms.model.dto.order.OrderCouponDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/** 
* @author 作者 geDuo
* @version 创建时间：2022年3月21日 下午11:35:47 
* @explain 类说明 
*/
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.mall.dto.MallOrderDTO", description = "小程序DTO")
public class MallOrderDTO implements Serializable {
	private static final long serialVersionUID = -5495994390870097181L;

	@ApiModelProperty("id")
	private Integer id;

	@ApiModelProperty("订单编号")
	private String orderNo;

	@ApiModelProperty("状态码")
	private Integer statusCode;

	@ApiModelProperty("user_account_id")
	private Integer userAccountId;

	@ApiModelProperty("买家uid")
	private String uid;

	@ApiModelProperty(value = "渠道等级id")
	private Integer cooperationTagId;

	@ApiModelProperty(value = "认证企业")
	private String companyName;

	@ApiModelProperty(value = "渠道合作标签")
	private String tagName;

	@ApiModelProperty("买家姓名")
	private String userName;

	@ApiModelProperty("买家昵称")
	private String nickName;

	@ApiModelProperty("买家手机号")
	private String phoneNum;

	@ApiModelProperty("0全款购买 1分期付款")
	private Integer payMethod;

	@ApiModelProperty("订单关闭原因")
	private String shutReason;

	@ApiModelProperty("下单时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
	private Date createTime;

	@ApiModelProperty(value = "收发货信息")
	private MallOrderExpressDTO exp;

	@ApiModelProperty(value = "物流动态信息")
	private KdnExpDTO kdn;

	@ApiModelProperty(value = "凭证审核不通过的原因")
	private String payErrInfo;

	@ApiModelProperty(value = "推荐人")
	private String recMallUserName;

	@ApiModelProperty(value = "收货信息")
	private UserAddressDTO userAddress;

	@ApiModelProperty("用户收货地址id")
	private Integer userAddressId;

	@ApiModelProperty("订单交期")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
	private Date deliveryTime;

	@ApiModelProperty("订单期限")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
	private Date creditPeriod;

	@ApiModelProperty("订单金额")
	private BigDecimal orderAmount;

	@ApiModelProperty("购物车的商品总金额")
	private BigDecimal shopCarAmount;

	@ApiModelProperty(value = "订单商品的服务列表集合")
	private List<String> serviceNames;

	@ApiModelProperty(value = "运营人员")
	private String operationName;

	@ApiModelProperty("运营id")
	private Integer operationId;

	@ApiModelProperty("合同编号")
	private String contractNo;

	@ApiModelProperty("合同状态状态：状态:（0:等待用户签署、1：用户签署失败、2：等待甲方签署(用户签署成功) 3：用户签署失败、4：甲方签署成功、5：已完成")
	private Integer signStatus;

	@ApiModelProperty("合同归档日期")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
	private Date archiveDate;

	@ApiModelProperty(value = "合同签署方式,1:线上,0:线下")
	private Integer contractSignedWay;

	@ApiModelProperty(value = "标品的备注,字符不超过600")
	private String remark;

	@ApiModelProperty(value = "订单清单")
	private List<MallOrderProdListDTO> mallOrderProdListDTOList;

	@ApiModelProperty(value = "订单名称")
	private String orderName;

	@ApiModelProperty(value = "订单商品的数量")
	private Integer goodsNum;

	@ApiModelProperty(value = "所选规格")
	private List<OGSkuSpecDTO> ogSkuSpecDTOList;

	@ApiModelProperty(value = "管理员专用备注")
	private String mRemark;

	@ApiModelProperty("减免金额")
	private BigDecimal deductAmount;

	@ApiModelProperty("优惠金额")
	private BigDecimal discountAmount;

	@ApiModelProperty("实付金额(订单价格-优惠券金额-手动折扣)0406")
	private BigDecimal realityAmount;

	@ApiModelProperty("分享状态")
	private Integer shareStatus;

	@ApiModelProperty("分享人id")
	private Integer shareId;

	@ApiModelProperty("订单使用的优惠券")
	private List<OrderCouponDTO> orderCouponDTOS;

	@ApiModelProperty("优惠券折扣金额")
	private BigDecimal couponDiscountAmount;

	@ApiModelProperty("手填折扣金额")
	private BigDecimal manualDiscountAmount;
}
