package com.mmc.oms.model.vo.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

import java.io.Serializable;
import java.util.Set;

/**
 * @author: zj
 * @Date: 2023/6/3 16:19
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class MallShopCarVO implements Serializable {
    private static final long serialVersionUID = -1189463082638114016L;
    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;
    @ApiModelProperty(value = "商品id")
    private Integer goodsInfoId;
    @ApiModelProperty(value = "购买数量")
    private Integer buyNum;
    @ApiModelProperty(value = "推荐人id")
    private Integer recMallUserId;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "产品or行业")
    @NonNull
    private Integer directoryId;
    @ApiModelProperty(value = "商品最小规格id")
    private Set<Integer> mallSkuSpecIds;
}