package com.mmc.oms.common.coupon;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 15:23
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ExcelTarget("couponUserExcel")
public class CouponUserExcel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Excel(name = "优惠券id", orderNum = "1", width = 25)
    private Integer couponId;

    @Excel(name = "领取人id", orderNum = "2", width = 25)
    private Integer uid;

    @Excel(name = "领取人手机号码", orderNum = "3", width = 25)
    private String userPhone;

    @Excel(name = "优惠券名称", orderNum = "4", width = 25)
    private String couponName;

    @Excel(name = "获取方式", orderNum = "5", width = 25)
    private String gainType;

    @Excel(name = "状态", orderNum = "6", width = 25)
    private String status;

    @Excel(name = "领取时间", orderNum = "7", width = 25, databaseFormat = "yyyyMMddHHmmss", format = "yyyy-MM-dd hh:mm:ss", isImportField = "true_st", timezone = "Asia/Shanghai")
    private Date createTime;

    @Excel(name = "使用时间", orderNum = "8", width = 25, databaseFormat = "yyyyMMddHHmmss", format = "yyyy-MM-dd hh:mm:ss", isImportField = "true_st", timezone = "Asia/Shanghai")
    private Date useTime;

    @Excel(name = "订单编码", orderNum = "9", width = 25)
    private String orderNo;

}
