package com.mmc.oms.service.demand.Impl;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.common.ResultEnum;
import com.mmc.oms.common.json.JsonUtil;
import com.mmc.oms.common.result.ResultBody;
import com.mmc.oms.common.util.CodeUtil;
import com.mmc.oms.common.util.TDateUtil;
import com.mmc.oms.controller.demand.util.EmojiUtils;
import com.mmc.oms.dao.demand.DemandReleaseOrderDao;
import com.mmc.oms.dao.demand.PublishServiceOrderDao;
import com.mmc.oms.dao.topup.TopUpOrderDao;
import com.mmc.oms.entity.demand.DemandReleaseOrderDO;
import com.mmc.oms.entity.demand.GetOrderNumberDO;
import com.mmc.oms.entity.demand.GetOrderNumberDTO;
import com.mmc.oms.entity.topup.TopUpOrderDO;
import com.mmc.oms.model.vo.demand.CommonPaymentVO;
import com.mmc.oms.model.vo.demand.DemandReleaseOrderVO;
import com.mmc.oms.model.vo.demand.OrderRequestParamsVO;
import com.mmc.oms.model.vo.demand.UserPayInfoVO;
import com.mmc.oms.service.demand.DemandReleaseOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author small
 * @Date 2023/7/25 15:49
 * @Version 1.0
 */
@Service
public class DemandReleaseOrderServiceImpl implements DemandReleaseOrderService {


    @Autowired
    private PublishServiceOrderDao serviceOrderDao;


    @Autowired
    private DemandReleaseOrderDao releaseOrderDao;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${payment.url}")
    private String paymentUrl;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private TopUpOrderDao topUpOrderDao;

    @Override
    public ResultBody publish(DemandReleaseOrderVO demandReleaseOrderVO, HttpServletRequest request) {
        DemandReleaseOrderDO requirementsInfoDO = new DemandReleaseOrderDO(demandReleaseOrderVO);
        releaseOrderDao.addRequirementsInfo(requirementsInfoDO);
        return ResultBody.success();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody orderPayment(CommonPaymentVO commonPaymentVO, HttpServletRequest request, Integer userAccountId) {
        String token = request.getHeader("token");
        switch (commonPaymentVO.getOrderPort().toString()) {
            case "3":
                return orderPost(commonPaymentVO, token);
            case "4":
                //发布服务需求支付
                return publishServicePay(commonPaymentVO, token, userAccountId);
            case "5":
                return topUpOrder(commonPaymentVO, token, userAccountId);
            default:
                return ResultBody.error("无效的订单类型操作！");
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public ResultBody topUpOrder(CommonPaymentVO commonPaymentVO, String token, Integer userAccountId) {
        // 生成充值订单编号 规则T加时间戳加用户id加随机数4位
        ResultBody resultBody = null;
        try {
            String TOrderNo = "T" + TDateUtil.getDateStr(new Date(), TDateUtil.TYPE) + userAccountId + CodeUtil.getRandomNum(4);
            OrderRequestParamsVO orderRequestParamsVO = new OrderRequestParamsVO();
            orderRequestParamsVO.setAmount(commonPaymentVO.getAmount());
            orderRequestParamsVO.setOrderNo(TOrderNo);
            orderRequestParamsVO.setDescription("云享金充值");
            orderRequestParamsVO.setOrderPort(5);
            orderRequestParamsVO.setAttach("TOP_UP");
            TopUpOrderDO topUpOrderDO = new TopUpOrderDO(orderRequestParamsVO, userAccountId);
            topUpOrderDO.setTradeState("WAIT");
            topUpOrderDO.setDescription("充值云享金");
            // 充值订单记录至充值订单表
            topUpOrderDao.insertTopUpOrder(topUpOrderDO);
            resultBody = releaseOrder(orderRequestParamsVO, token);
            if (!"200".equals(resultBody.getCode())) {
                throw new RuntimeException("调用微信支付方法失败！");
            }
        } catch (RuntimeException e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        } finally {
            return resultBody;
        }
    }

    /**
     * 服务需求发布
     *
     * @param commonPaymentVO
     * @param token
     * @param userAccountId
     * @return
     */
    private ResultBody publishServicePay(CommonPaymentVO commonPaymentVO, String token,Integer userAccountId) {

        if ("4".equals(commonPaymentVO.getOrderPort().toString())){
            String orderNumber = commonPaymentVO.getOrderNumber();
            String json = stringRedisTemplate.opsForValue().get(orderNumber);
            GetOrderNumberDTO getOrderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);
            GetOrderNumberDO getOrderNumberDO = new GetOrderNumberDO(getOrderNumberDTO);
            if (getOrderNumberDTO.getRequirementsInfoId()!=null){
                int i = releaseOrderDao.selectOrderNumberDO(getOrderNumberDO.getRequirementsInfoId());
                if (i!=0){
                    return ResultBody.error("当前需求已有人支付");
                }
            }
            releaseOrderDao.insertService(getOrderNumberDO);
            BigDecimal paramMoney = getOrderNumberDO.getWeChatPay();
            BigDecimal multiply = paramMoney.multiply(new BigDecimal(100));
            int i = multiply.intValue();
            OrderRequestParamsVO orderRequestParamsVO = getOrderNumberDO.orderRequestParamsVO();
            orderRequestParamsVO.setAmount(i);
            ResultBody resultBody = releaseOrder(orderRequestParamsVO, token);
            stringRedisTemplate.opsForValue().set(getOrderNumberDO.getPaymentOrderNumber()+getOrderNumberDO.getUserAccountId(), JsonUtil.parseObjToJson(getOrderNumberDO));
            return resultBody;
        }
        return ResultBody.success();
    }

    private ResultBody orderPost(CommonPaymentVO commonPaymentVO, String token) {
        if ("3".equals(commonPaymentVO.getOrderPort().toString())) {
            DemandReleaseOrderDO demandReleaseOrderDO = releaseOrderDao.orderPayment(commonPaymentVO.getOrderNumber());
            BigDecimal paramMoney = demandReleaseOrderDO.getParamMoney();
            BigDecimal multiply = paramMoney.multiply(new BigDecimal(100));
            int i = multiply.intValue();
            OrderRequestParamsVO orderRequestParamsVO = demandReleaseOrderDO.buildOrderRequestParamsVO();
            orderRequestParamsVO.setAmount(i);
            BigDecimal practicalMoney = demandReleaseOrderDO.getPracticalMoney();
            if (practicalMoney != null) {
                return ResultBody.error(ResultEnum.THE_CURRENT_DEMAND_IS_PAID);
            }
            if (i != 0) {
                return releaseOrder(orderRequestParamsVO, token);
            } else if (i == 0) {
                return ResultBody.error(ResultEnum.NO_PAYMENT_REQUIRED);
            }
        }
        return ResultBody.success();
    }


    @Override
    public ResultBody getPublishPhone(CommonPaymentVO commonPaymentVO, HttpServletRequest request, Integer
            userAccountId) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<UserPayInfoVO> exchange = restTemplate.exchange(paymentUrl + "/wechat/queryUserPayInfo" + "?orderNo=" + commonPaymentVO.getOrderNumber(), HttpMethod.GET, entity, UserPayInfoVO.class);

        UserPayInfoVO body = exchange.getBody();
        if (body.getWxNotifyPayerTotal() != null) {
            BigDecimal divide = BigDecimal.valueOf(Long.valueOf(body.getWxNotifyPayerTotal())).divide(new BigDecimal(100));
            DemandReleaseOrderDO requirementsInfoDO = new DemandReleaseOrderDO(body, divide);
            releaseOrderDao.updateOrderDemand(requirementsInfoDO);
            DemandReleaseOrderDO demandReleaseOrderDO = releaseOrderDao.selectPhone(requirementsInfoDO.getOrderNumber());
            stringRedisTemplate.opsForValue().set(demandReleaseOrderDO.getRequirementsInfoId().toString(), JsonUtil.parseObjToJson(demandReleaseOrderDO));
            return ResultBody.success(demandReleaseOrderDO.getPublishPhone());
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody getDelete(Integer requirementsInfoId) {
        return releaseOrderDao.getDelete(requirementsInfoId);
    }

    public ResultBody releaseOrder(OrderRequestParamsVO orderRequestParamsVO, String token) {
        boolean emoji = EmojiUtils.containsEmoji(orderRequestParamsVO.getDescription());
        if (emoji == true) {
            orderRequestParamsVO.setDescription(EmojiUtils.emojiConverter2Html(orderRequestParamsVO.getDescription()));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(orderRequestParamsVO), headers);
        ResponseEntity<Object> exchange = null;
        Map<String, Object> map = new HashMap<>();
        try {
            exchange = restTemplate.exchange(paymentUrl + "wechat/pay", HttpMethod.POST, entity, Object.class);
            map.put("Ok", exchange.getBody());
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THIRD_PARTY_ERRORS);
        }
        return ResultBody.success(map);
    }
}
