package com.mmc.oms.mq.listener;

import com.alibaba.fastjson.JSONObject;
import com.mmc.oms.dao.topup.TopUpOrderDao;
import com.mmc.oms.entity.topup.TopUpOrderDO;
import com.mmc.oms.model.vo.wallet.TopUpOrderVO;
import com.mmc.oms.mq.constant.RabbitmqConstant;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/6/29 10:35 概要：
 */
@Slf4j
@Component
public class MqConsumer {
    @Resource
    TopUpOrderDao topUpOrderDao;

    @RabbitListener(queues = RabbitmqConstant.USER_TOP_UP_DIRECT_QUEUE)
    public void subscribeDirectQueue(@Payload String topUpOrder, Channel channel, Message message) {
        TopUpOrderVO topUpOrderVO = JSONObject.parseObject(topUpOrder, TopUpOrderVO.class);
        log.info("<==========用户充值订单消费开始：订单信息是---->{}==========>", topUpOrderVO);
        // 根据消费的消息修改充值订单的信息
        TopUpOrderDO topUpOrderDO = new TopUpOrderDO();
        topUpOrderDO.setTradeState(topUpOrderVO.getTradeState());
        topUpOrderDO.setTradeStateDesc(topUpOrderVO.getTradeStateDesc());
        topUpOrderDO.setOrderNo(topUpOrderVO.getOrderNo());
        topUpOrderDao.updateTopUpOrderInfo(topUpOrderDO);
        log.info("<==========用户充值订单消费结束==========>");
    }
}
