package com.mmc.oms.model.dto.mall;

import com.mmc.oms.common.publicinterface.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/6/2 20:59
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class UserAddressDTO implements Serializable {
    private static final long serialVersionUID = -4644500806706169486L;

    @ApiModelProperty(value = "唯一标识")
    @NotNull(message = "id不能为空",groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "收货人姓名")
    private String takeName;

    @ApiModelProperty(value = "收货人电话")
    private String takePhone;

    @ApiModelProperty(value = "收货地址")
    private String takeRegion;

    @ApiModelProperty(value = "收货详细地址")
    private String takeAddress;

    @ApiModelProperty(value = "使用类型;0默认，1普通")
    private Integer type;
}
