package com.mmc.oms.model.dto.mall;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/3 20:21
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.mall.dto.OrderGoodsIndstDTO", description = "行业订单DTO")
public class OrderGoodsIndstDTO implements Serializable {
    private static final long serialVersionUID = -1809741999941834440L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "订单id")
    private Integer orderId;
    @ApiModelProperty(value = "购物车id")
    private Integer mallIndstShopCarId;
    @ApiModelProperty(value = "商品id")
    private Integer goodsInfoId;
    @ApiModelProperty(value = "商品所属类型id")
    private Integer directoryId;
    @ApiModelProperty(value = "商品所有规格金额")
    private BigDecimal goodsAmount;
    @ApiModelProperty(value = "商品编号")
    private String goodsNo;
    @ApiModelProperty(value = "商品名称")
    private String goodsName;
    @ApiModelProperty(value = "商品主图")
    private String mainImg;
    @ApiModelProperty(value = "购买数量")
    private Integer buyNum;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "是否有效")
    private Boolean valid;

    @ApiModelProperty(value = "行业订单规格")
    private List<OrderGoodsIndstDetailDTO> orderGoodsIndstDetailDTOS;

    @ApiModelProperty("商品服务列表")
    private List<GoodsServiceDTO> services;
}