package com.mmc.oms.entity.coupon;

import com.baomidou.mybatisplus.annotation.*;
import com.mmc.oms.common.coupon.CouponConstants;
import com.mmc.oms.model.dto.coupon.CouponActivityDTO;
import com.mmc.oms.model.dto.coupon.CouponDTO;
import com.mmc.oms.model.dto.coupon.CouponListDTO;
import com.mmc.oms.model.vo.coupon.CouponInfoActivityVO;
import com.mmc.oms.model.vo.coupon.CouponInfoVO;
import com.mmc.oms.model.vo.coupon.RedEnvelopeVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.experimental.Tolerate;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/24 13:29
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("coupon")
@ApiModel(value = "Coupon对象", description = "优惠券表")
public class CouponDO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户范围（1所有用户 2渠道用户 3非渠道用户 4注册用户）", required = true, example = "1")
    @NotBlank(message = "用户范围")
    private Integer userScope;

    @ApiModelProperty(value = "优惠券ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "优惠券名称")
    private String couponName;

    @ApiModelProperty(value = "优惠券面值")
    private BigDecimal couponMoney;

    @ApiModelProperty(value = "优惠券折扣")

    private BigDecimal couponDiscount;

    @ApiModelProperty(value = "是否限量, 默认0不限量， 1限量")
    private Boolean isLimited;

    @ApiModelProperty(value = "每人限制领取张数")
    private Integer restrictedAccess;

    @ApiModelProperty(value = "发放总数")
    private Integer couponTotal;

    @ApiModelProperty(value = "剩余数量")
    private Integer lastTotal;

    /**
     * @see
     */
    @ApiModelProperty(value = "优惠券类型 1打折券, 2减免券 3无门槛")
    private Integer couponType;

    @ApiModelProperty(value = "优惠券使用类型 1vip券, 2品牌券")
    private Integer useType;

    @ApiModelProperty(value = "最低消费")
    private BigDecimal minPrice;

    @ApiModelProperty(value = "所属 品牌范围id")
    private String primaryKey;

    /**
     * @see
     */
    @ApiModelProperty(value = "有效期时间方式：0 固定使用时间, 1领取当日起 2领取次日起")
    private Integer isFixedTime;

    @ApiModelProperty(value = "有效期时间范围 开始时间")
    private Date useStartTime;

    @ApiModelProperty(value = "有效期时间范围 结束时间")
    private Date useEndTime;

    @ApiModelProperty(value = "有效期时间天数")
    private Integer couponDay;

    /**
     * @see
     */
    @ApiModelProperty(value = "优惠券发放方式 1 手动领取 2 系统发放 3 批量导入用户")
    private Integer getType;

    @ApiModelProperty(value = "用户标签")
    private Integer userTag;

    @ApiModelProperty(value = "状态（0：关闭，1：开启）")
    private Boolean couponStatus;

    @ApiModelProperty(value = "是否删除 状态（0：否，1：是）")
    private Boolean isDel;

    @ApiModelProperty(value = "最多优惠")
    private BigDecimal preferentialLimit;

    @ApiModelProperty(value = "是否多次核销 0单次核销 1多次核销")
    private Boolean verificationType;

    @TableField(value = "create_time", fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "分享者优惠券id")
    private Integer parentId;

    @ApiModelProperty(value = "分享者-分享人数")
    private Integer peopleNumber;

    @ApiModelProperty(value = "批量导入文件url")
    private String fileUrl;

    @TableField(exist = false)
    @ApiModelProperty(value = "已领取的数量")
    private String quantityClaimed;


    public CouponDTO bilIdCouponDTO() {
        return CouponDTO.builder().id(this.id).couponName(this.couponName).couponDiscount(this.couponDiscount)
                .couponMoney(this.couponMoney).isLimited(this.isLimited).restrictedAccess(this.restrictedAccess)
                .couponTotal(this.couponTotal).lastTotal(this.lastTotal).couponType(this.couponType)
                .useType(this.useType).minPrice(this.minPrice).primaryKey(this.primaryKey).isFixedTime(this.isFixedTime)
                .useStartTime(this.useStartTime).useEndTime(this.useEndTime).couponDay(this.couponDay)
                .getType(this.getType).userTag(this.userTag).couponStatus(this.couponStatus).isDel(this.isDel)
                .preferentialLimit(this.preferentialLimit).verificationType(this.verificationType).quantityClaimed(this.quantityClaimed)
                .createTime(this.createTime).updateTime(this.updateTime).fileUrl(this.fileUrl).build();

    }

    public CouponListDTO bilIdCouponListDTO() {
        return CouponListDTO.builder().id(this.id).couponName(this.couponName).couponDiscount(this.couponDiscount)
                .couponMoney(this.couponMoney).isLimited(this.isLimited).restrictedAccess(this.restrictedAccess)
                .lastTotal(this.lastTotal).couponType(this.couponType).useType(this.useType).minPrice(this.minPrice)
                .primaryKey(this.primaryKey).isFixedTime(this.isFixedTime).useStartTime(this.useStartTime)
                .useEndTime(this.useEndTime).couponDay(this.couponDay).getType(this.getType).userTag(this.userTag)
                .preferentialLimit(this.preferentialLimit).isUse(false).receivedCount(0).build();

    }

    public CouponActivityDTO bilIdCouponActivityDTO() {
        return CouponActivityDTO.builder().id(this.id).couponName(this.couponName).couponDiscount(this.couponDiscount)
                .couponMoney(this.couponMoney).isLimited(this.isLimited).restrictedAccess(this.restrictedAccess)
                .couponTotal(this.couponTotal).lastTotal(this.lastTotal).couponType(this.couponType)
                .useType(this.useType).minPrice(this.minPrice).primaryKey(this.primaryKey).isFixedTime(this.isFixedTime)
                .useStartTime(this.useStartTime).useEndTime(this.useEndTime).couponDay(this.couponDay)
                .getType(this.getType).userTag(this.userTag).couponStatus(this.couponStatus)
                .verificationType(this.verificationType).createTime(this.createTime).updateTime(this.updateTime)
                .parentId(this.parentId).activityRole("share").amountReceived(this.couponTotal - this.lastTotal)
                .peopleNumber(this.peopleNumber).build();

    }

    @Tolerate
    public CouponDO(CouponInfoVO payment) {
        this.couponName = payment.getCouponName();
        this.couponMoney = payment.getCouponMoney();
        this.couponDiscount = payment.getCouponDiscount();
        this.isLimited = payment.getIsLimited();
        this.couponTotal = payment.getCouponTotal();
        this.couponType = payment.getCouponType();
        this.useType = payment.getUseType();
        this.primaryKey = payment.getPrimaryKey();
        this.minPrice = payment.getMinPrice();
        this.isFixedTime = payment.getIsFixedTime();
        this.useStartTime = payment.getUseStartTime();
        this.useEndTime = payment.getUseEndTime();
        this.couponDay = payment.getCouponDay();
        this.getType = payment.getGetType();
        this.userTag = payment.getUserTag();
        this.restrictedAccess = payment.getRestrictedAccess();
        this.preferentialLimit = payment.getPreferentialLimit();
        this.verificationType = payment.getVerificationType();
        this.fileUrl = payment.getFileUrl();
    }

    @Tolerate
    public CouponDO(CouponInfoActivityVO couponInfoActivityVO) {
        this.couponName = couponInfoActivityVO.getCouponName();
        this.useType = couponInfoActivityVO.getUseType();
        this.primaryKey = couponInfoActivityVO.getPrimaryKey();
        this.useStartTime = couponInfoActivityVO.getUseStartTime();
        this.useEndTime = couponInfoActivityVO.getUseEndTime();
        this.couponMoney = couponInfoActivityVO.getCouponMoney();
        this.minPrice = couponInfoActivityVO.getMinPrice();
        this.couponType = couponInfoActivityVO.getCouponType();
        this.couponDiscount = couponInfoActivityVO.getCouponDiscount();
        this.verificationType = couponInfoActivityVO.getVerificationType();
        this.couponTotal = couponInfoActivityVO.getCouponTotal();
        this.restrictedAccess = couponInfoActivityVO.getRestrictedAccess();

        this.preferentialLimit = couponInfoActivityVO.getPreferentialLimit();
        this.peopleNumber = couponInfoActivityVO.getPeopleNumber();
        this.isLimited = true;
        this.isFixedTime = CouponConstants.COUPON_USE_TIME_FIXED;
        this.getType = CouponConstants.COUPON_USR_TYPE_ACTIVITY;
    }

    @Tolerate
    public CouponDO(RedEnvelopeVO redEnvelopeVO, Integer type) {
        this.couponName = redEnvelopeVO.getCouponName();
        this.useType = redEnvelopeVO.getBeSharedUseType();
        this.useStartTime = redEnvelopeVO.getUseStartTime();
        this.useEndTime = redEnvelopeVO.getUseEndTime();
        this.couponMoney = redEnvelopeVO.getBeSharedCouponMoney();
        this.couponTotal = redEnvelopeVO.getBeSharedCouponTotal();
        this.userTag = redEnvelopeVO.getUserTag();
        this.restrictedAccess = 1;
        this.isLimited = true;
        this.isFixedTime = CouponConstants.COUPON_USE_TIME_FIXED;
        this.getType = CouponConstants.COUPON_USR_TYPE_ACTIVITY;
        this.userScope = redEnvelopeVO.getUserScope();
    }


    @Tolerate
    public CouponDO(CouponInfoActivityVO couponInfoActivityVO, Integer type) {
        this.couponName = couponInfoActivityVO.getCouponName();
        this.useType = couponInfoActivityVO.getBeSharedUseType();
        this.primaryKey = couponInfoActivityVO.getBeSharedPrimaryKey();
        this.useStartTime = couponInfoActivityVO.getUseStartTime();
        this.useEndTime = couponInfoActivityVO.getUseEndTime();
        this.couponMoney = couponInfoActivityVO.getBeSharedCouponMoney();
        this.minPrice = couponInfoActivityVO.getBeSharedMinPrice();
        this.couponType = couponInfoActivityVO.getBeSharedCouponType();
        this.couponDiscount = couponInfoActivityVO.getBeSharedCouponDiscount();
        this.verificationType = couponInfoActivityVO.getBeSharedVerificationType();
        this.couponTotal = couponInfoActivityVO.getBeSharedCouponTotal();
        this.preferentialLimit = couponInfoActivityVO.getBeSharedPreferentialLimit();
        this.userTag = couponInfoActivityVO.getUserTag();
        this.restrictedAccess = 1;
        this.isLimited = true;
        this.isFixedTime = CouponConstants.COUPON_USE_TIME_FIXED;
        this.getType = CouponConstants.COUPON_USR_TYPE_ACTIVITY;
    }


    @Tolerate
    public CouponDO(RedEnvelopeVO redEnvelopeVO) {
        this.couponName = redEnvelopeVO.getCouponName();
        this.useType = redEnvelopeVO.getUseType();
        this.useStartTime = redEnvelopeVO.getUseStartTime();
        this.useEndTime = redEnvelopeVO.getUseEndTime();
        this.couponMoney = redEnvelopeVO.getCouponMoney();
        this.couponTotal = redEnvelopeVO.getCouponTotal();
        this.userScope = redEnvelopeVO.getUserScope();
        this.peopleNumber = redEnvelopeVO.getPeopleNumber();
        this.isLimited = true;
        this.isFixedTime = CouponConstants.COUPON_USE_TIME_FIXED;
        this.getType = CouponConstants.COUPON_USR_TYPE_ACTIVITY;
    }
}
