package com.mmc.oms.model.excel;

import lombok.SneakyThrows;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * @author LW
 * @Description
 */
public class ExcelTool {
    /**
     * 克隆sheet
     * 注意传入的文件流在执行本方法后将关闭
     * @param excelIns excel文件流
     * @param tplSheetIndex 需要克隆的模板索引
     * @param newSheetNames 所需要生成的excel最终的sheet名
     * @return 新的InputStream
     */
    @SneakyThrows
    public static InputStream cloneSheet(InputStream excelIns, int tplSheetIndex, String... newSheetNames){
        Workbook workbook = ExcelTool.isXlsx(excelIns) ? new XSSFWorkbook(excelIns) : new HSSFWorkbook(excelIns);
        //模板sheet
        Sheet tplSheet = workbook.getSheetAt(tplSheetIndex);
        for (int i = 0; i < newSheetNames.length; i++) {
            String sheetName = newSheetNames[i];
            //第一个,直接改名即可
            if(0 == i){
                workbook.setSheetName(0,sheetName);
            }else{
                Sheet newSheet = workbook.cloneSheet(0);
                //同时复制打印设置
                PrintSetup tplPrintSetup = tplSheet.getPrintSetup();
                PrintSetup newPrintSetup = newSheet.getPrintSetup();
                //打印方向，true：横向，false：纵向(默认)
                newPrintSetup.setLandscape(tplPrintSetup.getLandscape());
                //纸张类型
                newPrintSetup.setPaperSize(tplPrintSetup.getPaperSize());
                int sheetIndex = workbook.getSheetIndex(newSheet);
                workbook.setSheetName(sheetIndex,sheetName);
            }
        }
        try(ByteArrayOutputStream bos = new ByteArrayOutputStream()){
            workbook.write(bos);
            byte[] bytes = bos.toByteArray();
            return new ByteArrayInputStream(bytes);
        } finally {
            excelIns.close();
        }

    }

    /**
     * 判断是否excel的07格式
     * @param ins
     * @return
     */
    @SneakyThrows
    public static boolean isXlsx(InputStream ins){
        return FileMagic.valueOf(ins) == FileMagic.OOXML;
    }

    /**
     * 根据url下载文件流
     * @param urlStr
     * @return
     */
    public static InputStream getInputStreamFromUrl(String urlStr) {
        InputStream inputStream=null;
        try {
            //url解码
            URL url = new URL(java.net.URLDecoder.decode(urlStr, "UTF-8"));
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            //设置超时间为3秒
            conn.setConnectTimeout(3 * 1000);
            //防止屏蔽程序抓取而返回403错误
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            //得到输入流
            inputStream = conn.getInputStream();
        } catch (IOException e) {

        }
        return inputStream;
    }
}