package com.mmc.csf.release.dao;

import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.*;
import com.mmc.csf.infomation.vo.LiabilityProblemVO;
import com.mmc.csf.infomation.vo.ServiceSettleAccountsVO;
import com.mmc.csf.release.entity.information.PersonSendOrderDO;
import com.mmc.csf.release.entity.requirements.*;
import io.swagger.models.auth.In;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 14:27
 */
@Mapper
public interface RequirementsDao {
    /**
     * 需求类型列表
     *
     * @return
     */
    List<RequirementsTypeDO> listType();

    /**
     * 添加需求
     *
     * @param requirementsInfoDO
     */
    void addRequirementsInfo(RequirementsInfoDO requirementsInfoDO);

    /**
     * 获取需求
     *
     * @param requirementsInfoId
     */
    RequirementsInfoDO getRequirementsInfoById(Integer requirementsInfoId);

    /**
     * 解决需求
     *
     * @param requirementsInfoId
     */
    void solveRequire(Integer requirementsInfoId);

    /**
     * 需求发布的数量
     *
     * @param industryCaseQO
     * @return
     */
    int countListPublishPage(IndustryCaseQO industryCaseQO);

    /**
     * 需求发布列表
     *
     * @param industryCaseQO
     * @return
     */
    List<RequirementsInfoDO> listPublishPage(IndustryCaseQO industryCaseQO);

    /**
     * 删除需求
     *
     * @param requirementsInfoId
     */
    void removeRequire(Integer requirementsInfoId);

    List<RequirementsTypeDO> listTypeReq(Integer id);

    Integer findPublish(RequirementsInfoDO requirementsInfoDO);

    void updatePublish(RequirementsInfoDO requirementsInfoDO);

    Integer findPublishCount(Integer id, Integer userAccountId);

    void requirementsDao(Integer id);


    /**
     * 取消的订单或者被抢完的订单就不展示
     * @param requirementsInfoQO 排序条件
     * @return {@link List}<{@link RequirementsInfoDO}>
     */
    List<RequirementsInfoDO> appPublishList(RequirementsInfoQO requirementsInfoQO);


    /**
     * 所有的订单全部查出来展示到小程序上，后续运营起来请用上面的
     * @param requirementsInfoQO 排序条件
     * @return {@link List}<{@link RequirementsInfoDO}>
     */
    List<RequirementsInfoDO> appPublishList1(RequirementsInfoQO requirementsInfoQO);

    RequirementsInfoDO detailPublish(Integer id);

    RequirementsInfoDO detailSendPublish(Integer id);
    /**
     * 获取被拒绝飞手具体订单信息
     * @param id 订单id
     * @return {@link RequirementsInfoDO}
     */
    RequirementsInfoDO selectDetailRefusePilotInfo(Integer id);
    int addPublishService(ServiceRequirementsDO requirementsInfoDO);


    void addPublishServiceSon(ServiceRequirementsSonDO serviceRequirementsSonDO);

    ServiceRequirementsDO grabTheOrder(Integer requirementsInfoId);

    void updateGrabTheOrder(Integer requirementsInfoId, Integer repertory);

    void insertService(RequirementsServiceDO requirementsServiceDO);

    void arriveAtTheScene(ServiceArriveSceneDO serviceArriveSceneDO);

    void updateScene(Integer requirementsInfoId, Integer serviceFlowId);

    ServiceArriveSceneDO arriveAtTheSceneDetails(Integer requirementsInfoId, Integer userAccountId);

    void fulfilATask(ServiceFulfilATaskDO serviceFulfilATaskDO);

    void updateTaskUrl(@Param("taskUrl") String taskUrl,@Param("requirementsInfoId") Integer requirementsInfoId);

    ServiceFulfilATaskDO fulfilATaskDetails(Integer requirementsInfoId, Integer userAccountId);

    void settleAccounts(ServiceSettleAccountsDO settleAccountsDO);

    int selectSettleAccountEs(Integer requirementsInfoId);

    ServiceSettleAccountsDO settleAccountsDetails(Integer requirementsInfoId, Integer userAccountId);

    void evaluate(ServiceEvaluateDO serviceEvaluateDO);


    ServiceEvaluateDO evaluateDetails(Integer requirementsInfoId, Integer userAccountId);

    List<RequirementsInfoDO> myPublish(MyPublishQO param);


    int mySendPublishCount(MyPublishQO param);
    /**
     * 获取需要管理员（飞手团队后台账号对应的小程序用户id） 同意或者指派的订单
     * @param param 条件
     * @return {@link List}<{@link RequirementsInfoDO}>
     */
    List<RequirementsInfoDO> mySendPublish(MyPublishQO param);

    List<RequirementsInfoDO> myPreempt(MyPreemptQO param);

    RequirementsServiceDO droneFlyerCancel(Integer requirementsInfoId, Integer userAccountId);

    RequirementsServiceDO customerDroneFlyerCancel(Integer requirementsInfoId);

    RequirementsInfoDO publisherCancel(Integer requirementsInfoId, Integer userAccountId);

    RequirementsInfoDO publisherCancelFlyers(Integer requirementsInfoId);

    RequirementsInfoDO customerPublisherCancel(Integer requirementsInfoId, Integer userAccountId);

    RequirementsInfoDO publisherCancelFlyer(Integer requirementsInfoId);

    RequirementsInfoDO publisherOrderNumber(String publisherNumber);

    List<FlowDictionaryDO> flowDictionary();

    void addAmount(RequirementsAmountDO requirementsAmountDO);


    void updateInfo(Integer requirementsInfoId, Integer serviceFlowId);

    void updateFlow(Integer requirementsInfoId, Integer serviceFlowId);

    int myPublishcount(MyPublishQO param);

    int myPreemptCount(MyPreemptQO param);

    List<RequirementsInfoDO> orderRequirements(String format);

    void updateServiceAmount(Integer id);

    void InsertRequirementsAmountLog(RequirementsInfoDO requirementsInfoDO);

    void updateAmount(RequirementsAmountDO amountDO);

    void updateRequirementsInfo(RequirementsInfoDO infoDO);

    RequirementsServiceDTO requirementsServiceDTO(Integer requirementsInfoId);

    ServiceArriveSceneDTO serviceArriveSceneDTO(Integer requirementsInfoId);

    AgreePilotOrderDTO serviceAgreePilotOrderDTO(Integer requirementsInfoId);

    ServiceFulfilATaskDTO serviceFulfilATaskDTO(Integer requirementsInfoId);

    ServiceSettleAccountsDTO settleAccountsDTO(Integer requirementsInfoId);

    ServiceEvaluateDTO serviceEvaluateDTO(Integer requirementsInfoId);

    RequirementsInfoDO selectSettleAccounts(ServiceSettleAccountsVO settleAccountsVO);

    RequirementsInfoDO flyHandAgree(Integer requirementsInfoId);

    RequirementsServiceDO serviceSettleAccounts(ServiceSettleAccountsVO settleAccountsVO);

    void deletePublishService(Integer requirementsInfoId);

    Integer selectDeletePreempt(Integer requirementsInfoId, Integer userAccountId);


    void deletePreempt(Integer requirementsInfoId);

    void requirementsAmountUpdate(RequirementsAmountUpdateDO amountUpdateDO);

    RequirementsAmountUpdateDO selectAmountUpdate(Integer requirementsInfoId);

    RequirementsAmountUpdateDTO amountUpdateDTO(Integer requirementsInfoId);

    void insertPlatformOrderEarnings(BigDecimal earnings, Integer requirementsInfoId, Integer userAccountId);

    void updatePlatformOrderEarnings(BigDecimal earnings, Integer requirementsInfoId, Integer userAccountId);

    void updateRequirementsAmount(RequirementsInfoDO requirementsInfoDO);

    void updateAmounts(RequirementsServiceDO requirementsServiceDO);

    ReleaseSuccessDTO releaseSuccessDTO(Integer requirementsInfoId);

    void updateOrderEarnings(BigDecimal orderAmount, Integer id);

    void updatePlatformorderAmount(BigDecimal bigDecimal2, Integer id);

    RequirementsServiceDO serviceReq(Integer requirementsInfoId);

    void updateRepertory(Integer requirementsInfoId);

    int findAmountUpdate(Integer requirementsInfoId);

    void updateRequirementsAmountUpdate(RequirementsAmountUpdateDO amountUpdateDO);

    RequirementsAmountUpdateDO findUpdateAmount(Integer requirementsInfoId);

    int selectInfo(Integer id);

    void customerServiceIntervention(LiabilityProblemVO liabilityProblemVO);

    int selectCustomer(Integer requirementsInfoId);

    int getOrderReleaseCount();

    BigDecimal getServiceOrderAmount();

    /**
     * 根据父订单获取子订单中没被抢的id
     * @param fatherRequireId 父订单id
     * @return {@link Integer} 没被抢的子订单id 只返回一个
     */
    Integer getRequirementsSonInfoId(Integer fatherRequireId);


    /**
     * 修改父订单中还需多少人字段
     * @param fatherRequireId 父订单id
     * @param fatherRepertory 还需多少人
     * @return {@link Integer}
     */
    Integer updateRequirementsInfoRepertory(Integer fatherRequireId,Integer fatherRepertory);

    /**
     * 查找用户有没有已经抢过这个多人订单了
     * @param fatherRequireId 父订单id
     * @param userId 抢单用户id
     * @return {@link Integer}1 就是已经抢过这个订单了 0 就是没抢过
     */
    Integer selectBooleanByFatherIdAndUserId(Integer fatherRequireId,Integer userId);


    /**
     * 根据父订单id 查找所有子订单信息
     * @param param 父订单id
     * @return {@link List}<{@link RequirementsInfoDO}>
     */
    List<RequirementsInfoDO> selectRequireSonInfo(MyPublishQO param);

    /**
     * 保存飞手被同意或拒绝接单信息
     * @param param 是否同意飞手信息
     */
    void insertAgreePilotOrder(AgreeOrRefusePilotQO param);

    /**
     * 根据订单id修改所需人数以及该订单的状态
     * @param requireInfoId 订单id
     */
    void updateRequirementsInfoByRefusePilot(Integer requireInfoId);

    /**
     * 根据订单查找父订单id
     * @param requireInfoId 订单id
     * @return {@link Integer}
     */
    Integer selectFatherRequireIdBySonId(Integer requireInfoId);

    /**
     * 根据订单id查找该订单还需人数
     * @param requireInfoId 订单id
     * @return {@link Integer}
     */
    Integer selectRepertoryByRequireId(Integer requireInfoId);

    /**
     * 根据订单id和飞手用户id删除接单的信息
     * @param requireInfoId 订单id
     * @param pilotUserId 飞手id
     * @return {@link Integer}
     */
    Integer updateRequirementsService(Integer requireInfoId,Integer pilotUserId);

    /**
     * 根据订单id和飞手用户id查询该飞手是被拒绝还是同意
     * @param requirementsId 订单id 对应requirement_info表的id
     * @param userAccountId 用户的id
     * @return {@link Integer} 2 就是同意 11 是拒绝
     */
    Integer selectServiceIdByRequireIdAndUserId(Integer requirementsId,Integer userAccountId);

    /**
     * 根绝订单id获取所需总人数
     * @param requirementsId 订单id
     * @return {@link Integer}
     */
    int selectRequirementsNum(Integer requirementsId);

    /**
     * 根据父订单id查询不满足状态条件的子订单数量
     * @param requirementsId 父订单id
     * @return {@link Integer}
     */
    Integer selectServiceFlowIdByFatherId(Integer requirementsId);


    /**
     * 去抢单表中查看用户是否被拒绝过
     * @param requireId 订单的id
     * @param userAccountId 抢单飞手的用户id
     * @return {@link Integer}
     */
    Integer selectRequirementsRefuse(Integer requireId,Integer userAccountId);

    /**
     * 取消后删除抢过的订单
     * @param requireId 订单iD
     * @param userAccountId 用户id
     */
    void deleteRequirementsServiceInfo(Integer requireId,Integer userAccountId);

    /**
     * 根据订单id和用户id查找这个订单是不是被拒绝过
     * @param requireId 订单id
     * @param userAccountId 接单飞手id
     * @return {@link Integer}
     */
    Integer selectServiceFlowIdFromAgreePilot(Integer requireId,Integer userAccountId);

    RequirementsServicePilotInfoDO selectPilotInfoByRequireId(Integer requireId);


    /**
     * 获取临时表对应的订单信息
     * @param requireId
     * @return {@link RequirementsServicePilotInfoDO}
     */
    RequirementsServicePilotInfoDO selectTempPilotInfoByRequireId(Integer requireId);

    /**
     * 根据流程id查询订单所处状态
     * @param serviceFlowId
     * @return {@link String}
     */
    String selectOrderStatusByServiceFlowId(Integer serviceFlowId);

    /**
     * 查询订单所处的状态
     * @param requireId 订单id
     * @return {@link Integer}
     */
    Integer selectServiceIdByRequireId(Integer requireId);

    /**
     * 获取后台修改后的金额
     * @param requireId 订单id
     * @return {@link Integer}
     */
    BigDecimal getChangedOrderAmount(Integer requireId);

    /**
     * 获取用户是否确认后台修改的金额
     * @param requireId
     * @return {@link Integer}
     */
    Integer selectUserSureChangeAmount(Integer requireId);

    /**
     * 给飞手接的单子设置默认的工作时间
     * @param requireId 订单id
     */
    void setWorkTimeByPilot(Integer requireId);

    /**
     * 根据订单id获取发单用户id
     * @param requireId 订单id
     * @return {@link Integer}
     */
    Integer getUserIdByRequireId(Integer requireId);

    /**
     * 根据订单id获取接单飞手id
     * @param requireId 订单id
     * @return {@link Integer}
     */
    Integer getPilotUserIdByRequireId(Integer requireId);

    /**
     * 根据飞手进行派单操作
     */
    Integer personSendOrder(PersonSendOrderDO personSendOrderDO);
    /**
     * 查询父订单下面的所有子订单id
     */
    List<Integer> selectAllSuborder(Integer fatherRequireId);

    /**
     * 修改info表中的状态
     */
    Integer updateInfoStatus(@Param("id") Integer requireId,@Param("status")Integer status);
    /**
     * 查询飞手是否重复派单
     */
    Integer isReSendOrder(Integer requireId);
    Integer reSendOrder(@Param("requireId") Integer requireId,@Param("userAccountId")Integer userAccountId);

    /**
     * 查询飞手订单是否被抢
     */
    Integer isLootedByPilot(Integer requireId);

    /**
     * 查询团队订单是否被抢
     */
    Integer isLootedByTeam(Integer requireId);
    /**
     * 查询是否是团队派单
     */
    Integer isTeamSendOrder(@Param("requireId") Integer requireId);
    /**
     * 查询派单信息
     */
    PersonSendOrderDO selectSendOrderById(Integer id);
    /**
     * 飞手是否确认接单
     */
    Integer orderConfirmationByPilot(@Param("id") Integer id,@Param("status") Integer status);

    /**
     * 查询飞手是否重复确认
     */
    Integer isReConfirm(Integer id);

    void updateSendOrder(PersonSendOrderDO personSendOrderDO);

    void deleteSendOrder(Integer requirementsInfoId);

    /**
     * 管理员确认接单
     */
    Integer orderConfirmationByTeam(@Param("id") Integer id,@Param("status") Integer status);

    /**
     * 飞手拒绝后订单发往抢单大厅
     */
    Integer updateCount(Integer id);

    /**
     * 根据飞手ID查询派单的列表数量
     */
    Integer mySendOderListCount(MyPreemptQO param);

    /**
     * 根据飞手ID查询派单的列表
     */
    List<RequirementsInfoDO> mySendOderList(MyPreemptQO param);

    /**
     * 根据订单id查询发单用户的id
     */
    Integer selectSenderId(Integer id);


    /**
     * 修改
     * @param requireId
     * @param num
     */
    void updateOrderRequireNum(Integer requireId,int num);
}
