package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.DynamicAuditSumDTO;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.release.auth.qo.UserAccountQO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.BackstageForumDao;
import com.mmc.csf.release.dao.DynamicDao;
import com.mmc.csf.release.dao.LikeDAO;
import com.mmc.csf.release.dao.gambit.GambitDao;
import com.mmc.csf.release.entity.forum.DynamicGambitDO;
import com.mmc.csf.release.entity.forum.ForumDynamicDO;
import com.mmc.csf.release.entity.forum.ForumLikeDO;
import com.mmc.csf.release.entity.forum.ForumResourceDO;
import com.mmc.csf.release.entity.gambit.ForumGambitDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.forum.dto.DynamicInfoDTO;
import com.mmc.csf.release.forum.qo.DynamicQO;
import com.mmc.csf.release.forum.vo.UserBaseInfoVO;
import com.mmc.csf.release.service.BackstageForumService;
import com.mmc.csf.user.vo.ChangeUserPointVO;
import com.mmc.csf.user.vo.WxMsgVO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/6/19 10:47 概要：
 */
@Service
public class BackstageForumServiceImpl implements BackstageForumService {
    @Autowired
    BackstageForumDao backstageForumDao;
    @Autowired
    DynamicDao dynamicDao;
    @Autowired
    UserAppApi userAppApi;
    @Autowired
    LikeDAO likeDAO;
    @Autowired
    private GambitDao gambitDao;

    @Override
    public PageResult listDynamic(DynamicQO dynamic, HttpServletRequest request) {
        List<Integer> userIds = null;
        if (dynamic.getKeyword() != null) {
            UserAccountQO userAccountQO = new UserAccountQO();
            userAccountQO.setKeyword(dynamic.getKeyword());
            // 获取筛选的用户id
            List<UserAccountSimpleDTO> userAccountSimpleDTOS =
                    userAppApi.feignListAppUserAccount(userAccountQO, request.getHeader(TokenConstant.TOKEN));
            if (CollectionUtils.isNotEmpty(userAccountSimpleDTOS)) {
                // 获取用户id
                userIds =
                        userAccountSimpleDTOS.stream()
                                .map(UserAccountSimpleDTO::getId)
                                .collect(Collectors.toList());
            }
            if (userIds == null) {
                return PageResult.buildPage(dynamic.getPageNo(), dynamic.getPageSize(), 0);
            }
        }
        int count = backstageForumDao.countDynamic(userIds);
        if (count == 0) {
            return PageResult.buildPage(dynamic.getPageNo(), dynamic.getPageSize(), count);
        }
        int itemIndex = (dynamic.getPageNo() - 1) * dynamic.getPageSize();
        // 获取动态信息
        List<ForumDynamicDO> dynamicList =
                backstageForumDao.listDynamicInfo(userIds, itemIndex, dynamic.getPageSize(),dynamic.getStatus());
        for (ForumDynamicDO forumDynamicDO : dynamicList) {
            Integer id = forumDynamicDO.getDynamicId();
            ArrayList<String> list = new ArrayList<>();
            List<ForumGambitDO> gambitDOS = dynamicDao.selectGambitBack(id);
            for (ForumGambitDO gambitDO : gambitDOS) {
                list.add(gambitDO.getGambitName());
            }
            forumDynamicDO.setGambitName(list);
        }

        // 动态id集合
        List<Integer> ids =
                dynamicList.stream().map(ForumDynamicDO::getId).collect(Collectors.toList());
        // 根据id集合查询图片
        List<ForumResourceDO> forumImageList = dynamicDao.listDynamicPicture(ids);
        Map<Integer, List<ForumResourceDO>> ImageMap =
                forumImageList.stream().collect(Collectors.groupingBy(ForumResourceDO::getDynamicId));
        // 获取用户信息
        Set<Integer> listUserIds =
                dynamicList.stream().map(ForumDynamicDO::getUserAccountId).collect(Collectors.toSet());
        List<Integer> userIdList = new ArrayList<>(listUserIds);
        UserAccountQO accountQO = new UserAccountQO();
        accountQO.setUserIds(userIdList);
        List<UserAccountSimpleDTO> userAccountSimpleList =
                userAppApi.feignListAppUserAccount(accountQO, request.getHeader(TokenConstant.TOKEN));
        Map<Integer, UserAccountSimpleDTO> userAccountInfoMap =
                userAccountSimpleList.stream()
                        .collect(Collectors.toMap(UserAccountSimpleDTO::getId, Function.identity()));
        List<DynamicInfoDTO> list =
                dynamicList.stream()
                        .map(
                                d -> {
                                    DynamicInfoDTO dynamicInfoDTO = d.buildDynamicInfoDTO();
                                    List<ForumResourceDO> forumResourceDOList = ImageMap.get(d.getId());
                                    if (CollectionUtils.isNotEmpty(forumResourceDOList)) {
                                        dynamicInfoDTO.setMediaVO(
                                                forumResourceDOList.stream()
                                                        .map(ForumResourceDO::buildMedia)
                                                        .collect(Collectors.toList()));
                                    }
                                    UserAccountSimpleDTO userAccountSimpleDTO =
                                            userAccountInfoMap.get(d.getUserAccountId());
                                    if (userAccountSimpleDTO != null) {
                                        UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                                        userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                                        userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                                        userBaseInfoVO.setUserName(userAccountSimpleDTO.getUserName());
                                        userBaseInfoVO.setPhone(userAccountSimpleDTO.getPhoneNum());
                                        userBaseInfoVO.setUid(userAccountSimpleDTO.getUid());
                                        dynamicInfoDTO.setUserBaseInfo(userBaseInfoVO);
                                    }
                                    return dynamicInfoDTO;
                                })
                        .collect(Collectors.toList());
        return PageResult.buildPage(dynamic.getPageNo(), dynamic.getPageSize(), count, list);
    }

    @Override
    public ResultBody getDynamicAuditSum() {
        DynamicAuditSumDTO dynamicAuditSumDTO = new DynamicAuditSumDTO();
        dynamicAuditSumDTO.setUnDynamicAuditSum(backstageForumDao.getDynamicAuditSum(0));
        dynamicAuditSumDTO.setFailDynamicAuditSum(backstageForumDao.getDynamicAuditSum(2));
        dynamicAuditSumDTO.setPassDynamicAuditSum(backstageForumDao.getDynamicAuditSum(1));
        return ResultBody.success(dynamicAuditSumDTO);
    }

    @Override
    public ResultBody deleteDynamic(Integer dynamicId) {
        List<DynamicGambitDO> dynamicGambitDOS = gambitDao.selectDynamicGambit(dynamicId);
        if (dynamicGambitDOS!=null){
            for (DynamicGambitDO dynamicGambitDO : dynamicGambitDOS) {
               gambitDao.updateGambits(dynamicGambitDO.getGambitId());
            }
        }
        dynamicDao.deleteDynamic(dynamicId);
        gambitDao.deleteForumGambit(dynamicId);
        return ResultBody.success();
    }

    @Override
    public ResultBody hiddenDynamic(Integer dynamicId) {
        dynamicDao.hiddenDynamic(dynamicId);
        return ResultBody.success();
    }

    @Override
    public ResultBody likeUserInfo(Integer dynamicId, HttpServletRequest request) {
        List<ForumLikeDO> forumLikeList = likeDAO.selectUserAccountId(dynamicId);
        if (forumLikeList != null) {
            List<Integer> list =
                    forumLikeList.stream().map(ForumLikeDO::getUserAccountId).collect(Collectors.toList());
            UserAccountQO accountQO = new UserAccountQO();
            accountQO.setUserIds(list);
            List<UserAccountSimpleDTO> userAccountSimpleList =
                    userAppApi.feignListAppUserAccount(accountQO, request.getHeader(TokenConstant.TOKEN));
            List<UserBaseInfoVO> userBaseInfoList = new ArrayList<>();
            userAccountSimpleList.forEach(
                    d -> {
                        UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                        userBaseInfoVO.setNickName(d.getNickName());
                        userBaseInfoVO.setUserImg(d.getUserImg());
                        userBaseInfoVO.setUserName(d.getUserName());
                        userBaseInfoVO.setPhone(d.getPhoneNum());
                        userBaseInfoVO.setUid(d.getUid());
                        userBaseInfoList.add(userBaseInfoVO);
                    });
            return ResultBody.success(userBaseInfoList);
        }
        return ResultBody.success();
    }


    @Override
    public ResultBody checkDynamic(Integer dynamicId, Boolean status, String token) {
        if (status) {
            //审核通过
            dynamicDao.updateCheckDynamic(dynamicId, 1);
            gambitDao.updateDynamicGambit(dynamicId,1);
            List<DynamicGambitDO> gambitDOList=  gambitDao.selectGambitDynamic(dynamicId);
            for (DynamicGambitDO gambitDO : gambitDOList) {
                Integer checkStatus = gambitDO.getCheckStatus();
                if (checkStatus!=1){
                    gambitDO.setCheckStatus(1);
                    gambitDao.updateForumGambit(gambitDO);
                }
                dynamicDao.updateDynamic(gambitDO.getGambitId());
            }
            List<DynamicGambitDO> ga= gambitDao.selectGambitList();
            List<ForumGambitDO> gambitDOS= gambitDao.selectCountList();
            for (ForumGambitDO gambitDO : gambitDOS) {
                long count = ga.stream().filter(u -> u.getGambitId().equals(gambitDO.getId())).count();
                dynamicDao.updateDiscussionCount(gambitDO.getId(),count);
            }
            ForumDynamicDO dynamicDO = dynamicDao.getDynamicInfoById(dynamicId);
            // 论坛通过发积分，暂时先发5积分
            ChangeUserPointVO changePoint = new ChangeUserPointVO();
            changePoint.setUserAccountId(dynamicDO.getUserAccountId());
            changePoint.setChangeType(3);
            changePoint.setChangePoint(5);
            userAppApi.changeUserPoint(changePoint, token);
            // 微信公众号发送通知
            WxMsgVO ws = new WxMsgVO();
            ws.setDataObject(spellMsg("发布帖子","审核通过"));
            ws.setUserAccountId(dynamicDO.getUserAccountId());
            ws.setTemplateId("9qvgBhfW9yoQJY91iMfhrog8y5eZUPSbo9PLvQzS_vk");
            userAppApi.feignSendWxMsg(token, ws);
        } else {
            dynamicDao.updateCheckDynamic(dynamicId, 2);
            List<DynamicGambitDO> gambitDOList=  gambitDao.selectGambitDynamic(dynamicId);
            for (DynamicGambitDO gambitDO : gambitDOList) {
                Integer checkStatus = gambitDO.getCheckStatus();
                if (checkStatus!=1){
                    gambitDO.setCheckStatus(2);
                    gambitDao.dedateForumGambitTrue(gambitDO.getGambitId());
                }
            }
            gambitDao.deleteForumGambit(dynamicId);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody getNotCheckDynamicSum() {
        return ResultBody.success(backstageForumDao.getDynamicAuditSum(0));
    }


    public JSONObject spellMsg(String name, String result){
        JSONObject data=new JSONObject();

        //申请项目{{thing3.DATA}}
        JSONObject thing3=new JSONObject();
        thing3.put("value",name);
        data.put("thing3",thing3);

        //审核时间{{time6.DATA}}
        JSONObject time6=new JSONObject();
        time6.put("value",new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        data.put("time6",time6);

        //审核结果{{thing5.DATA}}
        JSONObject thing5=new JSONObject();
        thing5.put("value",result);
        data.put("thing5",thing5);

        return data;
    }
}
