package com.mmc.csf.infomation.vo;

import java.io.Serializable;
import java.util.Date;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Others;
import com.mmc.csf.release.model.group.Update;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author small
 * @Date 2023/5/23 14:23
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.BannerInfoVO", description = "banner新增修改VO")
public class BannerInfoVO implements Serializable {
    private static final long serialVersionUID = -8278140378110070217L;
    @ApiModelProperty(value = "banner的id")
    @NotNull(message = "id不能为空", groups = { Update.class, Others.class})
    private Integer id;
    @ApiModelProperty(value = "模块id")
    @NotNull(message = "模块id不能为空", groups = {Create.class, Update.class})
    private Integer moduleId;
    @ApiModelProperty(value = "banner名称",example = "首页")
    @NotNull(message = "名称不能为null", groups = {Create.class, Update.class})
    @Size(max = 70, message = "名称不能超过70个字符", groups = { Create.class, Update.class })
    private String bannerName;
    @ApiModelProperty(value = "banner类型")
    private Integer bannerType;
    @ApiModelProperty(value = "商品id")
    private Integer goodsId;
    @ApiModelProperty(value = "点击后的页面地址")
    private String bannerUrl;
    @NotNull(message = "请先上传内容图片", groups = {Create.class, Update.class})
    @ApiModelProperty(value = "banner图片url")
    @NotEmpty(message = "请先上传内容图片", groups = { Create.class})
    private String bannerImg;
    @ApiModelProperty(value = "banner海报url")
    private String bannerPoster;
    @ApiModelProperty(value = "顺序")
    @NotNull(message = "sort不能为空", groups = { Others.class})
    private Integer sort;
    //@NotNull(message = "有效开始时间不能为null", groups = { Create.class})
    @ApiModelProperty(value = "有效开始时间")
    private Date startTime;
    //@NotNull(message = "有效结束时间不能为null", groups = { Create.class})
    @ApiModelProperty(value = "有效结束时间")
    private Date endTime;
    @ApiModelProperty(value = "是否使用 0未上架，1上架" ,example = "1")
    @NotNull(message = "状态不能为空", groups = { Create.class})
    private Integer using;
    @ApiModelProperty(value = "描述信息")
    private String detailInfo;
    @ApiModelProperty(value = "富文本内容")
    private String textContent;
}
