package com.mmc.csf.release.controller.countDown;

import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.config.IsNullConvertZeroUtil;
import com.mmc.csf.infomation.vo.*;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.entity.requirements.RequirementsAmountUpdateDO;
import com.mmc.csf.release.entity.requirements.RequirementsInfoDO;
import com.mmc.csf.release.entity.requirements.RequirementsServiceDO;
import com.mmc.csf.release.entity.requirements.ServiceSettleAccountsDO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.http.*;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/28 16:31
 * @Version 1.0
 */
@Transactional
@Component
@Slf4j
public class RedisKeyExpirationListener extends KeyExpirationEventMessageListener {

    @Autowired
    private RestTemplate restTemplate;

    @Value("${iuav.payment.url}")
    private String paymentApp;

    @Value("${iuav.userapp.url}")
    private String userApp;

    @Autowired
    private RequirementsDao requirementsDao;


    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public RedisKeyExpirationListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    /**
     * 飞手未确认按照钱的计算
     * @param message
     * @param pattern
     */
    @Override
    public void onMessage(Message message, byte[] pattern) {
        //  获取失效的key
        String expiredKey = message.toString();
        String prefix = "";
        if (expiredKey.indexOf("_") != -1) {
            prefix = expiredKey.substring(0, expiredKey.indexOf("_"));
        }
        //根据key的前缀判断是不是属于订单过期
        if ("order".equals(prefix)) {
            String orderId = expiredKey.substring(expiredKey.indexOf("_") + 1);
            log.info("订单编号：{}已过期，开始处理==========", orderId);
            RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherOrderNumber(orderId);
            System.out.println(requirementsInfoDO);

            ResultBody resultBody = getResultBody(requirementsInfoDO);
        }
    }


    private ResultBody getResultBody(RequirementsInfoDO infoDO) {

        int count = requirementsDao.selectInfo(infoDO.getId());
        if (count!=0){
            return ResultBody.error("已结算");
        }
        ServiceSettleAccountsVO settleAccountsVO = new ServiceSettleAccountsVO();
        settleAccountsVO.setRequirementsInfoId(infoDO.getId());
        //  RequirementsInfoDO infoDO = requirementsDao.selectSettleAccounts(settleAccountsVO);
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(infoDO.getId(), infoDO.getUserAccountId());
        RequirementsServiceDO requirementsServiceDO = requirementsDao.serviceSettleAccounts(settleAccountsVO);
        if (requirementsInfoDO.getServiceFlowId()==5 || requirementsInfoDO.getServiceFlowId()==6
        || requirementsInfoDO.getServiceFlowId()==7){
            return ResultBody.error("已结算");
        }

        RequirementsAmountUpdateDO updateAmount = requirementsDao.findUpdateAmount(infoDO.getId());
        IsNullConvertZeroUtil.checkIsNull(infoDO);
        IsNullConvertZeroUtil.checkIsNull(requirementsServiceDO);

        ServiceSettleAccountsDO settleAccountsDO = new ServiceSettleAccountsDO(settleAccountsVO);
        int i = requirementsDao.selectSettleAccountEs(settleAccountsDO.getRequirementsInfoId());
        if (i==0){
            requirementsDao.settleAccounts(settleAccountsDO);
        }
        requirementsDao.updateScene(settleAccountsVO.getRequirementsInfoId(), 5);
        requirementsDao.updateInfo(settleAccountsVO.getRequirementsInfoId(), 5);
        //正常结算
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        FlyerWalletFlowVO flyerWalletFlowVO = new FlyerWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(flyerWalletFlowVO);

        //给发布者发送
        BigDecimal orderAmount = infoDO.getOrderAmount();
        BigDecimal bigDecimal = new BigDecimal(0.9);
        BigDecimal bigDecimal1 = orderAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal bigDecimal2 = new BigDecimal(0.1);
        BigDecimal orderEarnings = orderAmount.multiply(bigDecimal2).setScale(2, BigDecimal.ROUND_HALF_UP);
        BigDecimal orderEarnings1 = requirementsInfoDO.getOrderEarnings();
        BigDecimal add = orderEarnings1.add(orderEarnings);
        //平台收益
        requirementsDao.updateOrderEarnings(add,requirementsInfoDO.getId());

        publisherWalletFlowVO.setModeOfPayment(900);
        publisherWalletFlowVO.setFlyerSalaryAmount(bigDecimal1);
        publisherWalletFlowVO.setCashAmount(infoDO.getCashAmount().negate());
        publisherWalletFlowVO.setSalaryAmount(infoDO.getSalaryAmount().negate());
        //需要退回后面支付的金额
        if (updateAmount.getCashAmount().compareTo(BigDecimal.ZERO)!=0||
        updateAmount.getSalaryAmount().compareTo(BigDecimal.ZERO)!=0){
            publisherWalletFlowVO.setRefundCashAmount(updateAmount.getCashAmount());
            publisherWalletFlowVO.setRefundSalaryAmount(updateAmount.getSalaryAmount());
        }
        //推发布者微信支付的金额
        if (updateAmount.getWeChat().compareTo(BigDecimal.ZERO)!=0){
            ApplyRefundVO applyRefundVO = new ApplyRefundVO();
            applyRefundVO.setReason("飞手未确认退款");
            applyRefundVO.setRefund(updateAmount.getWeChat().multiply(new BigDecimal(100)).longValue());
            applyRefundVO.setOutTradeNo(updateAmount.getWechatPayOrderNumber());
            applyRefund(applyRefundVO,"");
        }

        publisherWalletFlowVO.setUserAccountId(infoDO.getUserAccountId());
        publisherWalletFlowVO.setOperateUserAccountId(0);

        if ("TOP_ORDER".equals(infoDO.getOrderLevel())) {
            publisherWalletFlowVO.setTopYxjAmount(infoDO.getLevelCashAmount().negate());
            publisherWalletFlowVO.setTopSalaryAmount(infoDO.getLevelSalaryAmount().negate());
        } else if ("RUSH_ORDER".equals(infoDO.getOrderLevel())) {
            publisherWalletFlowVO.setUrgentYxjAmount(infoDO.getLevelCashAmount().negate());
            publisherWalletFlowVO.setUrgentSalaryAmount(infoDO.getLevelSalaryAmount().negate());
        }

        //退飞手钱
        flyerWalletFlowVO.setModeOfPayment(900);
        flyerWalletFlowVO.setCashAmount(requirementsServiceDO.getCashAmount());
        flyerWalletFlowVO.setSalaryAmount(requirementsServiceDO.getSalaryAmount());
        flyerWalletFlowVO.setUserAccountId(requirementsServiceDO.getPilotCertificationUserId());
        flyerWalletFlowVO.setOperateUserAccountId(0);


        ApplyRefundVO applyRefundVO = new ApplyRefundVO();
        if (requirementsServiceDO.getWeChat().compareTo(BigDecimal.ZERO) != 0) {
            applyRefundVO.setReason("原路退回");
            applyRefundVO.setOutTradeNo(requirementsServiceDO.getWechatPayOrderNumber());
            BigDecimal weChat = requirementsServiceDO.getWeChat();
            BigDecimal decimal = new BigDecimal(100);
            long longValueWeChat = weChat.multiply(new BigDecimal(100)).longValue();
            applyRefundVO.setRefund(longValueWeChat);
            applyRefund(applyRefundVO, "");
        }

        //推发布者微信账户
        walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
        walletFlowVO.setFlyerWalletFlowVO(flyerWalletFlowVO);
        flyerCancel(walletFlowVO, "");
        return ResultBody.success();
    }

    /**
     * 公共调用
     *
     * @param walletFlowVO
     * @param token
     * @return
     */
    public ResultBody flyerCancel(WalletFlowVO walletFlowVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(walletFlowVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/feignWalletFlowNO", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }

    /**
     * 退款
     */
    public ResultBody applyRefund(ApplyRefundVO applyRefundVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(applyRefundVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(paymentApp + "/payment/wechat/feignApplyRefund", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }
}
