package com.mmc.csf.release.service.licence.impl;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.licence.dto.LicenceGradeDTO;
import com.mmc.csf.licence.dto.LicenceModelsDTO;
import com.mmc.csf.licence.dto.LicenceScaleDTO;
import com.mmc.csf.licence.dto.LicenceTypeDTO;
import com.mmc.csf.release.dao.licence.LicenceCommonDao;
import com.mmc.csf.release.entity.licence.LicenceGradeDO;
import com.mmc.csf.release.entity.licence.LicenceModelsDO;
import com.mmc.csf.release.entity.licence.LicenceScaleDO;
import com.mmc.csf.release.entity.licence.LicenceTypeDO;
import com.mmc.csf.release.service.licence.LicenceCommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/7/13 14:34
 * @Version 1.0
 */
@Service
public class LicenceCommonServiceImpl implements LicenceCommonService {

    @Autowired
    private LicenceCommonDao licenceCommonDao;


    @Override
    public ResultBody licenceGradeList() {
        List<LicenceGradeDO> licenceGradeList = licenceCommonDao.licenceGradeList();
        List<LicenceGradeDTO> collect = licenceGradeList.stream().map(l -> {
            return l.licenceGradeDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody licenceModelsList() {
        List<LicenceModelsDO> licenceGradeList = licenceCommonDao.licenceModelsList();
        List<LicenceModelsDTO> collect = licenceGradeList.stream().map(l -> {
            return l.licenceModelsDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody licenceTypeList() {
        List<LicenceTypeDO> licenceGradeList = licenceCommonDao.licenceTypeList();
        List<LicenceTypeDTO> collect = licenceGradeList.stream().map(l -> {
            return l.licenceTypeDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody licenceScaleList() {
        List<LicenceScaleDO> licenceGradeList = licenceCommonDao.licenceScaleList();
        List<LicenceScaleDTO> collect = licenceGradeList.stream().map(l -> {
            return l.licenceScaleDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(collect);
    }
}
