package com.mmc.csf.release.entity.requirements;

import com.mmc.csf.config.IsNullConvertZero;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/26 14:18
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RequirementsAmountUpdateDO {

    @ApiModelProperty(value = "服务需求id", example = "1")
    private Integer requirementTypeId;

    @ApiModelProperty(value = "发布者修改后的订单金额", example = "100")
    @IsNullConvertZero
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "需要支付的云享金", example = "100")
    @IsNullConvertZero
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "微信支付金额", example = "100")
    @IsNullConvertZero
    private BigDecimal weChat;

    @ApiModelProperty(value = "佣金", example = "100")
    @IsNullConvertZero
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信支付的订单编号", example = "100")
    @IsNullConvertZero
    private BigDecimal wechatPayOrderNumber;

    @ApiModelProperty(value = "修改原因", example = "未按时完成任务")
    private String reason;

    @ApiModelProperty(value = "图片地址", example = "http://")
    private String url;

    @ApiModelProperty(value = "用户id", example = "1")
    private Integer userAccountId;


}
