package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.PayWalletDTO;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.release.auth.qo.UserAccountQO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.CommentDAO;
import com.mmc.csf.release.dao.DynamicDao;
import com.mmc.csf.release.dao.LikeDAO;
import com.mmc.csf.release.dao.gambit.GambitDao;
import com.mmc.csf.release.entity.forum.*;
import com.mmc.csf.release.entity.gambit.ForumGambitDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.forum.vo.*;
import com.mmc.csf.release.gambit.dto.ForumGambitDTO;
import com.mmc.csf.release.gambit.qo.ForumGambitQO;
import com.mmc.csf.release.gambit.vo.ForumGambitVO;
import com.mmc.csf.release.service.DynamicService;
import com.mmc.csf.release.service.WxApiService;
import com.mmc.csf.release.service.gambit.GambitService;
import com.mmc.csf.user.vo.UserAccountVO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author LW
 * @date 2023/5/15 10:29 概要：动态信息实现层
 */
@Service
public class DynamicServiceImpl implements DynamicService {

    @Resource
    private DynamicDao dynamicDao;
    @Resource
    private LikeDAO likeDAO;
    @Resource
    private CommentDAO commentDAO;
    @Autowired
    private UserAppApi userAppApi;
    @Resource
    private WxApiService wxApiService;

    @Autowired
    private GambitDao gambitDao;


    @Autowired
    private RestTemplate restTemplate;

    @Value("${iuav.userapp.url}")
    private String userApp;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody insertDynamic(DynamicVO dynamicVO, Integer userAccountId, HttpServletRequest request) {
        // 获取用户openid
        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(userAccountId, request.getHeader(TokenConstant.TOKEN));
        // 插入动态基本信息
        ForumDynamicDO forumDynamicDO = new ForumDynamicDO(dynamicVO);
        forumDynamicDO.setRootPath(null);
        forumDynamicDO.setUserAccountId(userAccountId);
        //插入用户
        int count = dynamicDao.selectForumCount(userAccountId);
        if (count==0){
            dynamicDao.insertForumCount(userAccountId);
        }
        // 插入动态资源
        if (CollectionUtils.isNotEmpty(dynamicVO.getMediaVO())) {
            forumDynamicDO.setCheckStatus(0);
            dynamicDao.insertDynamic(forumDynamicDO);
            for (MediaVO mediaVO : dynamicVO.getMediaVO()) {
                dynamicDao.insertResource(forumDynamicDO.getId(), mediaVO.getType(), mediaVO.getUrl());
            }
            //话题通过
            List<String> gambitName = dynamicVO.getGambitName();
            ForumGambitDO forumGambitDO = new ForumGambitDO(forumDynamicDO);
            if (gambitName.size()!=0){
                for (String s : gambitName) {
                    boolean b = s.startsWith("#");
                    if (b==true){
                        forumGambitDO.setGambitName(s);
                        ForumGambitDO forumGambitDO1 = gambitDao.selectGambitMessage(forumGambitDO.getGambitName());
                        if (forumGambitDO1==null){
                            dynamicDao.insertforumGambit(forumGambitDO);
                        }
                        if (forumGambitDO1!=null){
                            forumGambitDO.setId(forumGambitDO1.getId());
                        }
                        DynamicGambitDO dynamicGambitDO = new DynamicGambitDO(forumDynamicDO,forumGambitDO);
                        dynamicDao.insertDynamicGambit(dynamicGambitDO);
                    }
                }
            }
            return ResultBody.success("您的信息通过审核后，即可向其他人展示");
        } else {
            ResultBody resultBody = wxApiService.msgSecCheck(userAccountSimpleDTO.getOpenid(), dynamicVO.getDescription());
            if (resultBody.getCode().equals("200")) {
                //审核通过
                forumDynamicDO.setCheckStatus(1);
                dynamicDao.insertDynamic(forumDynamicDO);
                //话题通过
                List<String> gambitName = dynamicVO.getGambitName();
                ForumGambitDO forumGambitDO = new ForumGambitDO(forumDynamicDO);
                if (gambitName.size()!=0){
                    for (String s : gambitName) {
                        boolean b = s.startsWith("#");
                        if (b==true){
                            forumGambitDO.setGambitName(s);
                            ForumGambitDO forumGambitDO1 = gambitDao.selectGambitMessage(forumGambitDO.getGambitName());
                            if (forumGambitDO1==null){
                                dynamicDao.insertforumGambit(forumGambitDO);
                            }
                            if (forumGambitDO1!=null){
                                forumDynamicDO.setId(forumGambitDO1.getId());
                            }
                            DynamicGambitDO dynamicGambitDO = new DynamicGambitDO(forumDynamicDO,forumGambitDO);
                            dynamicDao.insertDynamicGambit(dynamicGambitDO);
                        }
                    }
                }

            } else {
                forumDynamicDO.setCheckStatus(2);
                dynamicDao.insertDynamic(forumDynamicDO);
            }
            return resultBody;
        }
    }

    @Override
    public ResultBody likeDynamic(Integer userId, Integer dynamicId) {
        // 获取动态信息
        ForumDynamicDO forumDynamicDO = dynamicDao.getDynamicInfo(dynamicId);
        if (!likeDAO.isLiked(userId, dynamicId)) {
            likeDAO.insertLike(userId, dynamicId);
            dynamicDao.updateDynamicLikeCount(dynamicId, forumDynamicDO.getVersion());
            dynamicDao.forumCount(forumDynamicDO.getUserAccountId());
            //评论
        } else {
            likeDAO.deleteLike(userId, dynamicId);
            dynamicDao.updateSubDynamicLikeCount(dynamicId, forumDynamicDO.getVersion());
            dynamicDao.forumCountNO(forumDynamicDO.getUserAccountId());
        }
        return ResultBody.success();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody commentDynamic(CommentVO commentVO, Integer userAccountId, HttpServletRequest request) {
        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(userAccountId, request.getHeader(TokenConstant.TOKEN));
        ForumDynamicDO forumDynamicDO = dynamicDao.getDynamicInfo(commentVO.getDynamicId());
        if (forumDynamicDO == null) {
            return ResultBody.error("动态不存在或已删除");
        }
        // todo openid 需要获取
        ResultBody resultBody = wxApiService.msgSecCheck(userAccountSimpleDTO.getOpenid(), commentVO.getContent());
        if (resultBody.getCode().equals("200")) {
            // 新增评论
            commentVO.setUserAccountId(userAccountId);
            ForumFirstLevelReviewDO forumFirstLevelReviewDO = new ForumFirstLevelReviewDO(commentVO);
            // dynamicDao.insertDynamic(comment);
            dynamicDao.insertforumFirstLevelReview(forumFirstLevelReviewDO);
            // 修改评论数量
            dynamicDao.updateDynamicCommentCount(commentVO.getDynamicId(), forumDynamicDO.getVersion());
            return ResultBody.success();
        } else {
            return resultBody;
        }
    }

    @Override
    public ResultBody deleteComment(Integer id) {
        commentDAO.deleteComment(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody dynamicDetails(Integer dynamicId, Integer userId, HttpServletRequest request) {
        // 判断此动态是否还存在
        ForumDynamicDO dynamicInfo = dynamicDao.getDynamicInfoById(dynamicId);
        if (dynamicInfo == null) {
            return ResultBody.error("动态不存在！");
        }
        DynamicVO dynamicVO = dynamicInfo.buildDynamicVO();
        // 设置是否点赞
        boolean liked = likeDAO.isLiked(userId, dynamicId);
        UserAccountSimpleDTO userAccountSimpleDTO =
                userAppApi.feignGetUserSimpleInfo(
                        dynamicInfo.getUserAccountId(), request.getHeader(TokenConstant.TOKEN));
        UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
        userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
        userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
        dynamicVO.setUserBaseInfo(userBaseInfoVO);
        dynamicVO.setLikes(liked);
        // 获取媒体资源
        List<ForumResourceDO> forumResourceList = dynamicDao.listDynamicResources(dynamicId);
        if (CollectionUtils.isNotEmpty(forumResourceList)) {
            List<MediaVO> MediaVOList =
                    forumResourceList.stream().map(ForumResourceDO::buildMedia).collect(Collectors.toList());
            dynamicVO.setMediaVO(MediaVOList);
        }
        // 动态评论列表
        List<DynamicVO> listDynamic = getCommentInfo(dynamicId, request);
        dynamicVO.setCommentAndReplyVO(listDynamic);
        return ResultBody.success(dynamicVO);
    }

    private List<DynamicVO> getCommentInfo(Integer dynamicId, HttpServletRequest request) {
        // 获取下面所有的一级评论
        List<ForumDynamicDO> forumDynamic = dynamicDao.getDynamicComment(dynamicId.toString());
        if (forumDynamic == null) {
            return new ArrayList<>();
        }
        List<Integer> userAccountIds =
                forumDynamic.stream().map(ForumDynamicDO::getUserAccountId).collect(Collectors.toList());
        UserAccountQO bUserAccountQO = new UserAccountQO();
        bUserAccountQO.setUserIds(userAccountIds);
        bUserAccountQO.setPageNo(1);
        bUserAccountQO.setPageSize(999);
        // 获取用户的信息
        List<UserAccountSimpleDTO> userAccountSimpleDTOS =
                userAppApi.feignListAppUserAccount(bUserAccountQO, request.getHeader(TokenConstant.TOKEN));

        List<DynamicVO> listDynamic =
                forumDynamic.stream().map(ForumDynamicDO::buildDynamicVO).collect(Collectors.toList());
        for (DynamicVO dynamicVO : listDynamic) {
            for (UserAccountSimpleDTO userAccountSimpleDTO : userAccountSimpleDTOS) {
                if (dynamicVO.getUserAccountId().equals(userAccountSimpleDTO.getId())) {
                    UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                    userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                    userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                    userBaseInfoVO.setUserName(userAccountSimpleDTO.getUserName());
                    userBaseInfoVO.setPhone(userAccountSimpleDTO.getPhoneNum());
                    userBaseInfoVO.setUid(userAccountSimpleDTO.getUid());
                    dynamicVO.setUserBaseInfo(userBaseInfoVO);
                    break;
                }
            }
        }
        return listDynamic;
    }

    @Override
    public PageResult dynamicList(
            Integer pageNo, Integer pageSize, Integer userId, HttpServletRequest request) {
        int count = dynamicDao.countDynamicList();
        if (count == 0) {
            return PageResult.buildPage(pageNo, pageSize, 0);
        }
        int itemIndex = (pageNo - 1) * pageSize;
        List<ForumDynamicDO> forumDynamicList = dynamicDao.dynamicList(itemIndex, pageSize);

        for (ForumDynamicDO forumDynamicDO : forumDynamicList) {
            Integer id = forumDynamicDO.getDynamicId();
            ArrayList<String> list = new ArrayList<>();
            List<ForumGambitDO> gambitDOS = dynamicDao.selectGambit(id);
            for (ForumGambitDO gambitDO : gambitDOS) {
                list.add(gambitDO.getGambitName());
            }
            forumDynamicDO.setGambitName(list);
        }

        // 动态id集合
        List<Integer> ids =
                forumDynamicList.stream().map(ForumDynamicDO::getId).collect(Collectors.toList());
        // 根据id集合查询评论
        List<ForumDynamicDO> commentList = dynamicDao.firstTwoItemsComment(ids);
        Map<String, List<ForumDynamicDO>> commentMap = commentList.stream().collect(Collectors.groupingBy(ForumDynamicDO::getRootPath));
        // 根据id集合查询图片
        List<ForumResourceDO> forumImageList = dynamicDao.listDynamicPicture(ids);
        Map<Integer, List<ForumResourceDO>> ImageMap =
                forumImageList.stream().collect(Collectors.groupingBy(ForumResourceDO::getDynamicId));
        // 获取用户信息
        Set<Integer> userIds =
                forumDynamicList.stream().map(ForumDynamicDO::getUserAccountId).collect(Collectors.toSet());
        List<Integer> userIdList = new ArrayList<>(userIds);
        UserAccountQO bUserAccountQO = new UserAccountQO();
        bUserAccountQO.setUserIds(userIdList);
        List<UserAccountSimpleDTO> userAccountSimpleDTOS =
                userAppApi.feignListAppUserAccount(bUserAccountQO, request.getHeader(TokenConstant.TOKEN));
        Map<Integer, UserAccountSimpleDTO> userAccountInfoMap =
                userAccountSimpleDTOS.stream()
                        .collect(Collectors.toMap(UserAccountSimpleDTO::getId, Function.identity()));
        // 获取liked信息
        List<ForumDynamicDO> forumDynamicDOS = likeDAO.selectLiked(userId, ids);
        List<DynamicVO> dynamicVOList =
                forumDynamicList.stream()
                        .map(
                                d -> {
                                    DynamicVO dynamicVO = d.buildDynamicVO();
                                    if (ImageMap != null) {
                                        List<ForumResourceDO> forumResourceDOList = ImageMap.get(d.getId());
                                        if (CollectionUtils.isNotEmpty(forumResourceDOList)) {
                                            dynamicVO.setMediaVO(
                                                    forumResourceDOList.stream()
                                                            .map(ForumResourceDO::buildMedia)
                                                            .collect(Collectors.toList()));
                                        }
                                    }
                                    if (commentMap != null) {
                                        List<ForumDynamicDO> comment = commentMap.get(d.getId().toString());
                                        if (CollectionUtils.isNotEmpty(comment)) {
                                            List<Integer> commentUserIds = comment.stream().map(ForumDynamicDO::getUserAccountId).collect(Collectors.toList());
                                            bUserAccountQO.setUserIds(commentUserIds);
                                            List<UserAccountSimpleDTO> commentUserAccountSimple =
                                                    userAppApi.feignListAppUserAccount(bUserAccountQO, request.getHeader(TokenConstant.TOKEN));
                                            List<DynamicVO> commentAndReply = comment.stream().limit(2).map(ForumDynamicDO::buildDynamicVO).collect(Collectors.toList());
                                            for (DynamicVO vo : commentAndReply) {
                                                for (UserAccountSimpleDTO userAccountSimpleDTO : commentUserAccountSimple) {
                                                    if (vo.getUserAccountId().equals(userAccountSimpleDTO.getId())) {
                                                        UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                                                        userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                                                        userBaseInfoVO.setUserName(userAccountSimpleDTO.getUserName());
                                                        userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                                                        userBaseInfoVO.setRegion(userAccountSimpleDTO.getRegion());
                                                        vo.setUserBaseInfo(userBaseInfoVO);
                                                        break;
                                                    }
                                                }
                                            }
                                            dynamicVO.setCommentAndReplyVO(commentAndReply);
                                        }
                                    }
                                    UserAccountSimpleDTO userAccountSimpleDTO =
                                            userAccountInfoMap.get(d.getUserAccountId());
                                    if (userAccountSimpleDTO != null) {
                                        UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                                        userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                                        userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                                        userBaseInfoVO.setRegion(userAccountSimpleDTO.getRegion());
                                        dynamicVO.setUserBaseInfo(userBaseInfoVO);
                                    }
                                    // 设置是否点赞
                                    for (ForumDynamicDO forumDynamicDO : forumDynamicDOS) {
                                        if (forumDynamicDO.getId().equals(d.getId())) {
                                            dynamicVO.setLikes(true);
                                            break;
                                        } else {
                                            dynamicVO.setLikes(false);
                                        }
                                    }
                                    return dynamicVO;
                                })
                        .collect(Collectors.toList());
        return PageResult.buildPage(pageNo, pageSize, count, dynamicVOList);
    }

    @Override
    public ResultBody recentNewsList(Integer userAccountId) {
        List<ForumDynamicUserDO> forumDynamicDOS = dynamicDao.recentNewsList(userAccountId);
        for (ForumDynamicUserDO forumDynamicDO : forumDynamicDOS) {
            UserAccountVO info = info(forumDynamicDO.getUserAccountId());
            forumDynamicDO.setUserAccountVO(info);
        }
        return ResultBody.success(forumDynamicDOS);
    }

    @Override
    public PageResult appGambitList(ForumGambitQO forumGambitQO) {
        Integer pageNo = forumGambitQO.getPageNo();
        forumGambitQO.buildCurrentPage();
        int count =   dynamicDao.appGambitListCount(forumGambitQO);
        List<ForumGambitDO> forumGambitDOList= dynamicDao.appGambitList(forumGambitQO);
        List<ForumGambitDTO> collect = forumGambitDOList.stream().map(ForumGambitDO::buildForumGambitDTO).collect(Collectors.toList());
        return  PageResult.buildPage(pageNo, forumGambitQO.getPageSize(),count,collect);
    }

    /**
     *点赞或者取消
     * @param id
     * @param userAccountId
     * @param status
     * @return
     */
    @Override
    public ResultBody reviewLikes(Integer id, Integer userAccountId, Boolean status) {

        if (status.equals(true)){
            dynamicDao.updateLikeCountAdd(id);
            dynamicDao.insertReviewLikes(id,userAccountId);
        }else{
            dynamicDao.subtractLikeCount(id);
            dynamicDao.deleteReview(id,userAccountId);
        }
        return ResultBody.success();
    }


    public UserAccountVO info( Integer userAccountId) {
        String token = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(userAccountId.toString(), headers);
        ResponseEntity<String> exchange = restTemplate.exchange(userApp + "/userapp/user-account/interiorInfo?userAccountId=" + userAccountId , HttpMethod.GET, entity, String.class);
        Object body = exchange.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String) body);
        JSONObject result1 = (JSONObject) jsonObject.get("result");
        UserAccountVO userAccountVO = JSON.parseObject(result1.toJSONString(), UserAccountVO.class);
        return userAccountVO;
    }


}
