package com.mmc.csf.release.service.data.impl;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.data.dto.ReleaseReportDTO;
import com.mmc.csf.release.dao.DynamicDao;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.service.data.ReleaseReportService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/9/18 10:44
 * 概要：
 */
@Service
public class ReleaseReportServiceImpl implements ReleaseReportService {
    @Resource
    private RequirementsDao requirementsDao;
    @Resource
    private DynamicDao dynamicDao;

    @Override
    public ResultBody<ReleaseReportDTO> getReleaseReportData() {
        ReleaseReportDTO releaseReportDTO = new ReleaseReportDTO();
        // 获取订单发布数量总数
        int orderCount = requirementsDao.getOrderReleaseCount();
        releaseReportDTO.setOrderReleaseCount(orderCount);
        // 获取帖子发布总数
        int dynamicCount = dynamicDao.getDynamicCount();
        releaseReportDTO.setPostsReleaseCount(dynamicCount);
        // 获取话题发布总数
        int gambitReleaseCount = dynamicDao.getGambitReleaseCount();
        releaseReportDTO.setTopicReleaseCount(gambitReleaseCount);
        // 信息发布总数
        releaseReportDTO.setReleaseCount(orderCount + dynamicCount + gambitReleaseCount);
        return ResultBody.success(releaseReportDTO);
    }
}
