package com.mmc.csf.release.controller.data;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.data.dto.ReleaseReportDTO;
import com.mmc.csf.release.service.data.ReleaseReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author LW
 * @date 2023/9/18 9:46
 * 概要：
 */
@Api(tags = "云享飞发数据看板")
@RequestMapping("/release/report")
@RestController
public class ReleaseReportController {

    @Autowired
    private ReleaseReportService releaseReportService;

    @ApiOperation(value = "获取信息发布报表数据")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ReleaseReportDTO.class)})
    @GetMapping("/getReleaseReportData")
    public ResultBody<ReleaseReportDTO> getUserReportData() {
        return releaseReportService.getReleaseReportData();
    }
}
