package com.mmc.csf.release.forum.dto;

import com.mmc.csf.release.forum.vo.MediaVO;
import com.mmc.csf.release.forum.vo.UserBaseInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2023/6/19 14:25 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class DynamicInfoDTO {
    @ApiModelProperty(value = "动态id")
    private Integer id;

    @ApiModelProperty(value = "动态描述")
    private String description;

    @ApiModelProperty(value = "图片/视频")
    private List<MediaVO> mediaVO;

    @ApiModelProperty(value = "show: 0显示 1隐藏")
    private Integer show;

    @ApiModelProperty(value = "发布动态用户信息")
    private UserBaseInfoVO userBaseInfo;

    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;

    @ApiModelProperty(value = "动态发布时间")
    private Date dynamicPublishTime;

    @ApiModelProperty(value = "审核状态：0审核中 1通过 2未通过")
    private Integer checkStatus;

    @ApiModelProperty(value = "话题名称",example = "#深圳暴雨,#深圳大雨")
    private List<String> gambitName;

    @ApiModelProperty(value = "点赞数")
    private Integer likesCount;
}
