package com.mmc.csf.release.forum.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 *
 * @date 2023/5/15 10:29 概要：评论信息参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CommentAndReplyVO implements Serializable {
  @ApiModelProperty(value = "评论id")
  private Integer id;

  @ApiModelProperty(value = "用户信息")
  private UserBaseInfoVO userBaseInfoVO;

  @ApiModelProperty(value = "评论内容")
  private String content;

  @ApiModelProperty(value = "评论点赞数")
  private Integer likesCount;

  @ApiModelProperty(value = "评论时间")
  private Date createTime;

  private List<CommentAndReplyVO> children;
}
