package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.infomation.dto.BannerInfoDTO;
import com.mmc.csf.infomation.dto.ModuleInfoDTO;
import com.mmc.csf.infomation.qo.BannerInfoQO;
import com.mmc.csf.infomation.qo.ModuleInfoQO;
import com.mmc.csf.infomation.vo.BannerInfoVO;
import com.mmc.csf.release.dao.ModuleInfoDao;
import com.mmc.csf.release.entity.BannerInfoDO;
import com.mmc.csf.release.entity.ModuleInfoDO;
import com.mmc.csf.release.flyer.vo.ModuleInfoVO;
import com.mmc.csf.release.service.ModuleInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/5/23 14:12
 * @Version 1.0
 */
@Service
public class ModuleInfoServiceImpl implements ModuleInfoService {
    @Autowired
    private ModuleInfoDao moduleInfoDao;

    @Override
    public ResultBody insertModuleInfo(ModuleInfoVO moduleInfoVO) {
        int count = moduleInfoDao.getCountSameNameOfModuleInfo(moduleInfoVO.getModuleType(), moduleInfoVO.getModuleName());
        if(count > 0){
            return ResultBody.error(ResultEnum.EXIST_SAME_NAME_OF_MODULE_ERROR);
        }
        if(moduleInfoDao.getCountSameCode(moduleInfoVO.getModuleCode()) > 0){
            return ResultBody.error(ResultEnum.EXIST_SAME_CODE_OF_MODULE_ERROR);
        }
        ModuleInfoDO moduleInfoDO = new ModuleInfoDO(moduleInfoVO);
        moduleInfoDao.insertModuleInfo(moduleInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateModuleInfo(ModuleInfoVO moduleInfoVO) {
        int count = moduleInfoDao.getCountSameNameNotItSelfOfModule(moduleInfoVO.getId(), moduleInfoVO.getModuleType(), moduleInfoVO.getModuleName());
        if(count > 0){
            return ResultBody.error(ResultEnum.EXIST_SAME_NAME_OF_MODULE_ERROR);
        }
        if(moduleInfoDao.getCountSameCodeOfItSelf(moduleInfoVO.getId() ,moduleInfoVO.getModuleCode()) > 0){
            return ResultBody.error(ResultEnum.EXIST_SAME_CODE_OF_MODULE_ERROR);
        }
        //判断之前有没有修改过moduleType
        ModuleInfoDO moduleInfoDO = new ModuleInfoDO(moduleInfoVO);
        moduleInfoDao.updateModuleInfo(moduleInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody removeModuleInfo(Integer id) {
        moduleInfoDao.removeModuleInfo(id);
        moduleInfoDao.removeBanners(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateModuleInfoRemark(Integer id, String remark) {
        moduleInfoDao.updateModuleInfoRemark(id, remark);
        return ResultBody.success();
    }

    @Override
    public ResultBody listModuleInfoPage(ModuleInfoQO param) {
        int count = moduleInfoDao.countListModuleInfoPage(param);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(param.getPageNo(), param.getPageSize(), count));
        }
        int pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<ModuleInfoDO> list = moduleInfoDao.listModuleInfoPage(param);
        List<ModuleInfoDTO> pageList = list.stream().map(d->{
            return d.buildModuleInfoDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, param.getPageSize(), count, pageList));
    }

    @Override
    public ResultBody listBannerInfoPage(BannerInfoQO param) {
        int count = moduleInfoDao.countListBannerInfoPage(param);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(param.getPageNo(), param.getPageSize(), count));
        }
        int pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<BannerInfoDO> list = moduleInfoDao.listBannerInfoPage(param);
        List<BannerInfoDTO> pageList = list.stream().map(d->{
            return d.buildBannerInfoDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, param.getPageSize(), count, pageList));
    }

    @Override
    public ResultBody removeBannerInfo(Integer id) {
        moduleInfoDao.removeBannerInfo(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody insertBannerInfo(BannerInfoVO bannerInfoVO) {
        int countSameName = moduleInfoDao.getCountSameNameOfBannerInfo(bannerInfoVO.getModuleId(), bannerInfoVO.getBannerName());
        if(countSameName > 0){
            return ResultBody.error(ResultEnum.EXIST_SAME_NAME_OF_BANNER_ERROR);
        }
        BannerInfoDO bannerInfoDO = new BannerInfoDO(bannerInfoVO);
        //sort设置
        int count = moduleInfoDao.getCountBannerInfoOfModule(bannerInfoVO.getModuleId());
        bannerInfoDO.setSort(count+1);
        moduleInfoDao.insertBannerInfo(bannerInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateBannerInfo(BannerInfoVO bannerInfoVO) {
        int countSameName = moduleInfoDao.getCountSameNameNotItSelfOfBanner(bannerInfoVO.getId(), bannerInfoVO.getModuleId(), bannerInfoVO.getBannerName());
        if(countSameName > 0){
            return ResultBody.error(ResultEnum.EXIST_SAME_NAME_OF_BANNER_ERROR);
        }
        BannerInfoDO bannerInfoDO = new BannerInfoDO(bannerInfoVO);
        if("0".equals(bannerInfoVO.getBannerType().toString())){
            bannerInfoDO.setBannerUrl("");
            bannerInfoDO.setBannerPoster("");
        }else if("1".equals(bannerInfoVO.getBannerType().toString())){
            bannerInfoDO.setBannerUrl("");
        }else if("2".equals(bannerInfoVO.getBannerType().toString())){
            bannerInfoDO.setBannerPoster("");
        }
        moduleInfoDao.updateBannerInfo(bannerInfoDO);
        return ResultBody.success();
    }

    @Transactional
    @Override
    public ResultBody exchangeBannerInfo(List<BannerInfoVO> list) {
        Integer sort = list.get(0).getSort();
        BannerInfoDO bannerInfoDO0 = new BannerInfoDO();
        bannerInfoDO0.setId(list.get(0).getId());
        bannerInfoDO0.setSort(list.get(1).getSort());
        moduleInfoDao.updateBannerInfo(bannerInfoDO0);

        BannerInfoDO bannerInfoDO1 = new BannerInfoDO();
        bannerInfoDO1.setId(list.get(1).getId());
        bannerInfoDO1.setSort(sort);
        moduleInfoDao.updateBannerInfo(bannerInfoDO1);
        return ResultBody.success();
    }

    @Override
    public ResultBody listBannerImg(String moduleCode) {
        List<BannerInfoDO> list = moduleInfoDao.listBannerImg(moduleCode);
        List<BannerInfoDTO> pageList = list.stream().map(d->{
            return d.buildBannerInfoDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(pageList);
    }

    @Override
    public ResultBody batchRemoveBannerInfo(List<Integer> list) {
        moduleInfoDao.batchRemoveBannerInfo(list);
        return ResultBody.success();
    }
}
