package com.mmc.csf.common.util.web;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "com.mmc.csf.common.util.web.XETResultBody", description = "小鹅通请求响应体")
public class XETResultBody<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 响应代码
     */
    @ApiModelProperty(value = "响应代码")
    private Integer code;

    /**
     * 响应消息
     */
    @ApiModelProperty(value = "响应消息")
    private String msg;

    /**
     * 响应结果
     */
    @ApiModelProperty(value = "响应结果")
    private T data;

    /**
     * 成功
     *
     * @return
     */
    public static XETResultBody success() {
        return success(null);
    }

    /**
     * 成功
     *
     * @param data
     * @return
     */
    public static <T> XETResultBody success(T data) {
        XETResultBody rb = new XETResultBody();
        rb.setCode(0);
        rb.setMsg(ResultEnum.SUCCESS.getResultMsg());
        rb.setData(data);
        return rb;
    }

    /**
     * 签名、权限等异常
     * @param data
     * @param <T>
     * @return
     */
    public static <T> XETResultBody powerError(T data){
        XETResultBody rb = new XETResultBody();
        rb.setCode(-1);
        rb.setMsg(ResultEnum.SUCCESS.getResultMsg());
        rb.setData(data);
        return rb;
    }

    /**
     * 业务接口异常
     * @param data
     * @param <T>
     * @return
     */
    public static <T> XETResultBody bizError(T data){
        XETResultBody rb = new XETResultBody();
        rb.setCode(1);
        rb.setMsg(ResultEnum.SUCCESS.getResultMsg());
        rb.setData(data);
        return rb;
    }
}
