package com.mmc.csf.release.forum.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2023/5/15 10:29
 * 概要：动态信息参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class DynamicVO implements Serializable {
    @ApiModelProperty(value = "模拟用户id")
    private Integer userId;
    @ApiModelProperty(value = "动态id")
    private Integer id;
    @ApiModelProperty(value = "动态标题")
    private String title;
    @ApiModelProperty(value = "动态描述")
    private String description;
    @ApiModelProperty(value = "位置信息")
    private String location;
    @ApiModelProperty(value = "纬度")
    private BigDecimal lat;
    @ApiModelProperty(value = "经度")
    private BigDecimal lon;
    @ApiModelProperty(value = "图片/视频")
    private MediaVO mediaVO;
    @ApiModelProperty(value = "点赞数")
    private Integer likesCount;
    @ApiModelProperty(value = "评论数")
    private Integer commentCount;
    @ApiModelProperty(value = "是否点赞")
    private Boolean likes;
    @ApiModelProperty(value = "动态发布时间")
    private Date dynamicPublishTime;
    @ApiModelProperty(value = "评论信息")
    private List<CommentAndReplyVO> commentAndReplyVO;
}
