package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.qo.IndustryNewsQO;
import com.mmc.csf.infomation.vo.IndustryNewsDTO;
import com.mmc.csf.infomation.vo.IndustryNewsVO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.IndustryNewsDao;
import com.mmc.csf.release.entity.information.IndustryNewsDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.service.IndustryNewsService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/5/19 13:41
 */
@Service
public class IndustryNewsServiceImpl implements IndustryNewsService {
    @Autowired
    private IndustryNewsDao industryNewsDao;

    @Autowired
    private UserAppApi userAppApi;

    @Override
    public ResultBody listNewsPage(IndustryCaseQO industryCaseQO, HttpServletRequest request) {
        //查询对应地区的用户
        //查询对应地区的用户， 默认查广东
        if (industryCaseQO.getProvinceCode() != null) {
            List<Integer> userIds = userAppApi.feignListUserAccountIds(industryCaseQO.getProvinceCode(), industryCaseQO.getCityCode(), industryCaseQO.getDistrictCode(), request.getHeader(TokenConstant.TOKEN));
            if (CollectionUtils.isEmpty(userIds)) {
                return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), 0));
            }
            industryCaseQO.setUserIds(userIds);
        }
        int count = industryNewsDao.countListNewsPage(industryCaseQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), count));
        }
        Integer pageNo = industryCaseQO.getPageNo();
        industryCaseQO.buildCurrentPage();
        List<IndustryNewsDO> industryNewsDOList = industryNewsDao.listNewsPage(industryCaseQO);
        List<IndustryNewsDTO> industryNewsDTOS = industryNewsDOList.stream().map(IndustryNewsDO::buildIndustryNewsDTO).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, industryCaseQO.getPageSize(), count, industryNewsDTOS));
    }

    @Override
    public ResultBody details(Integer id) {
        IndustryNewsDO industryNewsDO = industryNewsDao.details(id);
        if (industryNewsDO!= null) {
            return ResultBody.success(industryNewsDO.buildIndustryNewsDTO());
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody insertIndustryNews(IndustryNewsVO param, Integer userAccountId) {
        IndustryNewsDO industryNewsDO = IndustryNewsDO.builder().newsTitle(param.getNewsTitle()).build();
        Integer count = industryNewsDao.count(industryNewsDO);
        if(count>0){
            return ResultBody.error(ResultEnum.INDUSTRY_NEWS_TITLE_EXISTS);
        }
        industryNewsDO = new IndustryNewsDO(param.getId(), param.getNewsTitle(), param.getNewsAuthor(), userAccountId, param.getSurfaceImg(), param.getNewsContents(), param.getOrigin(),param.getIsHot());
        industryNewsDao.insert(industryNewsDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody upDateIndustryNews(IndustryNewsVO param, Integer userAccountId) {
        IndustryNewsDO industryNewsDO = new IndustryNewsDO(param.getId(), param.getNewsTitle(), param.getNewsAuthor(), userAccountId, param.getSurfaceImg(), param.getNewsContents(), param.getOrigin(),param.getIsHot());
        industryNewsDao.update(industryNewsDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deleteIndustryNews(Integer id) {
        IndustryNewsDO industryNewsDO = IndustryNewsDO.builder().id(id).isDeleted(1).build();
        industryNewsDao.update(industryNewsDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody<IndustryNewsDTO> backgroundListNewsPage(IndustryNewsQO industryNewsQO, HttpServletRequest request) {
        Integer count = industryNewsDao.countPage(industryNewsQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryNewsQO.getPageNo(), industryNewsQO.getPageSize(), count));
        }
        Integer pageNo = industryNewsQO.getPageNo();
        industryNewsQO.buildCurrentPage();
        List<IndustryNewsDO> industryNewsDOList = industryNewsDao.backgroundListNewsPage(industryNewsQO);
        List<IndustryNewsDTO> industryNewsDTOS = industryNewsDOList.stream().map(IndustryNewsDO::buildIndustryNewsDTO).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, industryNewsQO.getPageSize(), count, industryNewsDTOS));
    }
}
