package com.mmc.csf.release.dao;

import com.mmc.csf.release.entity.forum.ForumDynamicDO;
import com.mmc.csf.release.entity.forum.ForumLikeDO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author LW
 *
 * @date 2023/5/15 10:29 概要：点赞信息数据访问层
 */
@Mapper
public interface LikeDAO {

  /**
   * 插入点赞信息
   *
   * @param userId 用户id
   * @param dynamicId 动态id
   */
  void insertLike(@Param("userId") int userId, @Param("dynamicId") int dynamicId);

  /**
   * 删除点赞信息
   *
   * @param userId 用户id
   * @param dynamicId 动态id
   * @return int
   */
  int deleteLike(@Param("userId") int userId, @Param("dynamicId") int dynamicId);

  /**
   * 是否是点赞过的
   *
   * @param userId 用户id
   * @param dynamicId 动态id
   * @return boolean
   */
  boolean isLiked(@Param("userId") int userId, @Param("dynamicId") int dynamicId);

  /**
   * 点赞数
   *
   * @param dynamicId 动态id
   * @return int
   */
  int getLikesCount(int dynamicId);

  List<ForumDynamicDO> selectLiked(Integer userId, List<Integer> ids);

  List<ForumLikeDO> selectUserAccountId(Integer dynamicId);
}
