package com.mmc.csf.release.service;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.qo.IndustryNewsQO;
import com.mmc.csf.infomation.vo.IndustryNewsDTO;
import com.mmc.csf.infomation.vo.IndustryNewsVO;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/19 13:40
 */
public interface IndustryNewsService {
    /**
     * 新闻列表-web
     * @param industryCaseQO
     * @param request
     * @return
     */
    ResultBody listNewsPage(IndustryCaseQO industryCaseQO, HttpServletRequest request);

    /**
     * 新闻详情
     * @param id
     * @return
     */
    ResultBody details(Integer id);

    /**
     * 新闻插入
     */
    ResultBody insertIndustryNews(IndustryNewsVO industryNewsVO, Integer userAccountId);

    /**
     * 新闻编辑
     */
    ResultBody upDateIndustryNews(IndustryNewsVO industryNewsVO, Integer userAccountId);

    /**
     * 新闻列表-后台
     */
    ResultBody<IndustryNewsDTO> backgroundListNewsPage(IndustryNewsQO industryNewsQO, HttpServletRequest request);
}
