package com.mmc.csf.infomation.vo;

import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/18 15:14
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class RequirementsInfoVO implements Serializable {
    private static final long serialVersionUID = -447951390213113317L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "省份编码", required = false)
    //@NotNull(message = "省份编码不能为空", groups = {Insert.class})
    private Integer provinceCode;
    @ApiModelProperty(value = "市编码", required = false)
    private Integer cityCode;
    @ApiModelProperty(value = "区编码", required = false)
    private Integer districtCode;
    @ApiModelProperty(value = "需求类型id")
    @NotNull(message = "需求类型id不能为空", groups = {Insert.class})
    private Integer requirementTypeId;
    @ApiModelProperty(value = "需求类型名称")
    private String requirementTypeName;
    @ApiModelProperty(value = "用户id")
    //@NotNull(message = "用户id不能为空", groups = {Insert.class})
    private Integer userAccountId;
    @ApiModelProperty(value = "发布者姓名")
    @NotNull(message = "发布者姓名不能为空", groups = {Insert.class})
    private String publishName;
    @ApiModelProperty(value = "发布者电话")
    @NotNull(message = "发布者电话不能为空", groups = {Insert.class})
    private String publishPhone;
    @ApiModelProperty(value = "需求描述")
    @NotNull(message = "需求描述不能为空", groups = {Insert.class})
    private String requireDescription;
    @ApiModelProperty(value = "是否已解决")
    private Integer solved;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
