package com.mmc.csf.release.forum.vo;

import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class MallGoodsVO implements Serializable {

    @ApiModelProperty(value = "id", example = "1")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "商品名称", example = "这是商品名称", required = true)
    @NotBlank(message = "商品名称不能为空", groups = {Update.class, Create.class})
    private String tradeName;

    @ApiModelProperty(value = "商品描述", example = "商品描述", required = true)
    @NotBlank(message = "商品描述不能为空", groups = {Update.class, Create.class})
    private String description;

    @ApiModelProperty(value = "商品资源:图片or视频及其他")
    @NotEmpty(message = "图片不能为空")
    private List<GoodsResourcesVO> resourcesList;

    @ApiModelProperty(value = "商品状态", example = "1", required = true)
    @NotNull(message = "商品状态不能为空", groups = {Update.class, Create.class})
    private Integer shelfStatus;

    @ApiModelProperty(value = "商品标签")
    private String goodsLabel;

    @ApiModelProperty(value = "价格是否显示 0不显示 1显示")
    private Integer priceShow;

    @ApiModelProperty(value = "标签是否显示 0否 1是")
    private Integer labelShow;

    @ApiModelProperty(value = "是否推荐 0否 1是")
    private Integer recommend;

    @ApiModelProperty(value = "商品详情 富文本")
    private String goodsDetails;

    @ApiModelProperty(value = "创建时间 用作列表回显")
    private Date createTime;

    @ApiModelProperty(value = "店铺id 小程序用")
    private Integer userAccountId;

    @ApiModelProperty(value = "单位名称")
    private String companyName;

    @ApiModelProperty(value = "关联话题id")
    private Integer gambitId;

}
