package com.mmc.csf.release.flyer.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.mmc.csf.release.model.group.Insert;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author LW
 * @date 2023/5/17 14:28
 * 概要:课程信息
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CurriculumInfoVO implements Serializable {
    private static final long serialVersionUID = -7343885960160805850L;
    @ApiModelProperty(value = "课程id")
    private Integer id;

    @ApiModelProperty(value = "1级课程分类ID")
    @NotNull(message = "1级课程分类ID不能为空" ,groups = {Insert.class})
    private Integer oneCourseId;

    @ApiModelProperty(value = "2级课程分类ID")
    private Integer twoCourseId;

    @ApiModelProperty(value = "课程名称，长度30")
    @Length(max = 30)
    private String curriculumName;

    @ApiModelProperty(value = "课程介绍（简介）, 长度255")
    @Length(max = 255)
    private String curriculumDesc;

    @ApiModelProperty(value = "课程封面")
    private String surfaceUrl;

    @ApiModelProperty(value = "课程视频")
    private String videoUrl;

    @ApiModelProperty(value = "课程属性: 0:免费 1：积分兑换 2：付费 ")
    private Integer courseAttribute;

    @ApiModelProperty(value = "价格")
    private BigDecimal requireAmout;

    @ApiModelProperty(value = "积分")
    private Integer requireIntegral;

    @ApiModelProperty(value = "课程是否热门 0：否 1：是")
    private Integer isHot;

    @ApiModelProperty(value = "课程详情")
    private String detailContent;

    @ApiModelProperty(value = "创建时间")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty(value = "用户是否购买过")
    private boolean isBuy;

}
