package com.mmc.csf.infomation.dto;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/18 20:46
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ServiceFulfilATaskDTO {
    private Integer id;

    @ApiModelProperty(value = "完成任务描述", example = "完成任务描述一下")
    private String taskDescribe;

    @ApiModelProperty(value = "完成任务图片", example = "http://")
    private String taskUrl;

    @ApiModelProperty(value = "需求id", example = "83")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "完成任务的用户", example = "1", hidden = true)
    private Integer userAccountId;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty(value = "", hidden = true)
    private Integer serviceFlowId;

    private FlowDictionaryDTO flowDictionaryDTO;

}
