package com.mmc.csf.infomation.vo;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/17 10:22
 * @Version 1.0
 */
public enum OrderLevelEnum {

    //普通订单
    REGULAR_ORDER("REGULAR_ORDER", new BigDecimal(0)),
    //紧急订单
    RUSH_ORDER("RUSH_ORDER", new BigDecimal(100)),
    //置顶订单
    TOP_ORDER("TOP_ORDER", new BigDecimal(300));

    private String key;
    private BigDecimal value;


    private OrderLevelEnum(String key, BigDecimal value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public BigDecimal getValue() {
        return value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public static OrderLevelEnum match(String key) {
        OrderLevelEnum result = null;
        for (OrderLevelEnum s : values()) {
            if (s.getKey() == key) {
                result = s;
                break;
            }
        }
        return result;
    }

    public static OrderLevelEnum catchMessage(BigDecimal value) {

        OrderLevelEnum result = null;

        for (OrderLevelEnum s : values()) {
            if (s.getValue().equals(value)) {
                result = s;
                break;
            }
        }

        return result;
    }


}
