package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.date.TDateUtil;
import com.mmc.csf.common.util.math.CodeUtil;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.entity.curriculum.CurriculumInfoDO;
import com.mmc.csf.release.entity.curriculum.CurriculumOrderDO;
import com.mmc.csf.release.entity.curriculum.CurriculumOrderQO;
import com.mmc.csf.release.feign.PmsAppApi;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.flyer.qo.CurriculumQo;
import com.mmc.csf.release.flyer.vo.*;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.model.group.Update;
import com.mmc.csf.release.service.FlyerTrainingService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;


/**
 * @Author LW
 * @date 2023/5/13 11:00
 * 概要：
 */
@Api(tags = {"web-小程序-飞手培训-模块"})
@RestController
@RequestMapping("/curriculum/")
public class FlyerTrainingController extends BaseController {

    @Resource
    private FlyerTrainingService flyerTrainingService;

    @Qualifier("com.mmc.csf.release.feign.UserAppApi")
    @Autowired
    private UserAppApi userAppApi;

    @ApiOperation(value = "飞手报名")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/pilotRegistration")
    public ResultBody pilotRegistration(@RequestBody RegistrationVO registrationVO, HttpServletRequest request) {
        return flyerTrainingService.pilotRegistration(registrationVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }


    @ApiOperation(value = "无人机驾驶员执照-树形图")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DronePilotLicenseVO.class)})
    @GetMapping("/getDronePilotLicense")
    public ResultBody getDronePilotLicense() {
        return flyerTrainingService.getDronePilotLicense();
    }

    @ApiOperation(value = "行业应用认证-下拉列表(课程技能列表)")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = FlightSkillsVO.class)})
    @GetMapping("/getIndustryFlightSkills")
    public ResultBody getIndustryFlightSkills() {
        return flyerTrainingService.getIndustryFlightSkills();
    }

    @ApiOperation(value = "考证-技能")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @GetMapping("/licenseOrSkillQueryCurriculum")
    public ResultBody licenseOrSkillQueryCurriculum(@ApiParam(value = "考证/技能 0：考证 1：技能") @RequestParam(value = "type") Integer type) {
        return flyerTrainingService.licenseOrSkillQueryCurriculum(type);
    }

    @ApiOperation(value = "飞手技能列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = FlightSkillsVO.class)})
    @GetMapping("treeCurriculumSkill")
    public ResultBody treeCurriculumSkill() {
        return flyerTrainingService.treeCurriculumSkill();
    }

    @ApiOperation(value = "V1.0.1课程视频列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @PostMapping("/queryCurriculumInfoList")
    public ResultBody queryCurriculumInfoList(@RequestBody CurriculumQo curriculumQo) {
        return ResultBody.success(flyerTrainingService.queryCurriculumInfoList(curriculumQo));
    }

    @ApiOperation(value = "feign-V1.0.1课程视频列表", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @GetMapping("/feignCurriculumInfoList")
    public List<CurriculumInfoVO> feignCurriculumInfoList(@RequestParam Integer categoriesId) {
        return flyerTrainingService.feignCurriculumInfoList(categoriesId);
    }

    @ApiOperation(value = "feign-V1.0.1课程视频列表数量", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = Integer.class)})
    @GetMapping("/feignCountCurriculumInfo")
    public int feignCountCurriculumInfo(@RequestParam Integer categoriesId) {
        return flyerTrainingService.feignCountCurriculumInfo(categoriesId);
    }

    @ApiOperation(value = "V1.0.1课程视频详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @GetMapping("/curriculumDetails")
    public ResultBody curriculumDetails(@ApiParam(value = "课程id") @RequestParam(value = "id") Integer id) {
        return flyerTrainingService.curriculumDetails(id);
    }

    @ApiOperation(value = "V1.0.1新增课程")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @PostMapping("addCurriculum")
    public ResultBody addCurriculum(@Validated(Insert.class) @RequestBody CurriculumInfoVO curriculumInfoVO) {
        return ResultBody.success(flyerTrainingService.addCurriculum(curriculumInfoVO));
    }

    @ApiOperation(value = "V1.0.1修改课程")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @PostMapping("updateCurriculum")
    public ResultBody updateCurriculum(@Validated(Update.class) @RequestBody CurriculumInfoVO curriculumInfoVO) {
        return ResultBody.success(flyerTrainingService.updateCurriculum(curriculumInfoVO));
    }

    @ApiOperation(value = "V1.0.1删除课程")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeCurriculum")
    public ResultBody removeCurriculum(@RequestParam Integer id) {
        return ResultBody.success(flyerTrainingService.removeCurriculum(id));
    }

    @Autowired
    private PmsAppApi pmsAppApi;

    @ApiOperation(value = "V1.0.1test")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("test")
    public ResultBody test() {
        return ResultBody.success(pmsAppApi.feignQqueryCategoryInfoByType(3));
    }

    @ApiOperation(value = "获取课程总数")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = Integer.class)})
    @GetMapping("getCurriculumCount")
    @ApiIgnore
    public Integer getCurriculumCount() {
        return flyerTrainingService.getCurriculumCount();
    }


    @ApiOperation(value = "后台——获取课程订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumOrderDO.class)})
    @PostMapping("getCurriculumOrderList")
    public ResultBody<List<CurriculumOrderDO>> getCurriculumOrderList(@ApiParam(value = "订单查询QO", required = true) @Validated(Page.class) @RequestBody CurriculumOrderQO param) {
        return flyerTrainingService.getCurriculumOrderList(param);
    }

    @ApiOperation(value = "后台——删除课程订单详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumOrderDO.class)})
    @GetMapping("deleteCurriculumOrderInfo")
    public ResultBody<CurriculumOrderDO> deleteCurriculumOrderInfo(@ApiParam(value = "删除订单id", required = true) @Validated(Page.class) @RequestParam(value = "id") Integer id) {
        return flyerTrainingService.deleteCurriculumOrderInfo(id);
    }

    @ApiOperation(value = "新增课程分类")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumClassifyVO.class)})
    @PostMapping("addCurriculumClassify")
    public ResultBody addCurriculumClassify(@Validated(Insert.class) @RequestBody CurriculumClassifyVO curriculumClassifyVO) {
        return ResultBody.success(flyerTrainingService.addCurriculumClassify(curriculumClassifyVO));
    }

    @ApiOperation(value = "修改课程分类")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumClassifyVO.class)})
    @PostMapping("updateCurriculumClassify")
    public ResultBody updateCurriculumClassify(@Validated(Update.class) @RequestBody CurriculumClassifyVO curriculumClassifyVO) {
        return ResultBody.success(flyerTrainingService.updateCurriculumClassify(curriculumClassifyVO));
    }
    @ApiOperation(value = "删除课程分类")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumClassifyVO.class)})
    @PostMapping("removeCurriculumClassify")
    public ResultBody removeCurriculumClassify(Integer id) {
        return flyerTrainingService.removeCurriculumClassify(id);
    }

    @ApiOperation(value = "所有课程分类列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumClassifyVO.class)})
    @GetMapping("/selectCurriculumClassify")
    public ResultBody selectCurriculumClassify() {
        return flyerTrainingService.selectCurriculumClassify();
    }

    @ApiOperation(value = "购买课程-使用积分-去支付")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/curriculumPayByIntegral")
    public ResultBody curriculumPayByIntegral(HttpServletRequest request, @RequestParam Integer id) {
        CurriculumInfoDO curriculumInfo = flyerTrainingService.selectCurriculumInfoById(id);
        ResultBody resultBody = userAppApi.feignChangeUserPoints(request.getHeader("token"),request, - curriculumInfo.getRequireIntegral(), "购买课程");
        if("200".equals(resultBody.getCode())){
            CurriculumOrderDO curriculumOrderDO = new CurriculumOrderDO();
            curriculumOrderDO.setUserAccountId(this.getUserLoginInfoFromRedis(request).getUserAccountId());
            curriculumOrderDO.setCurriculumInfoId(id);
            curriculumOrderDO.setJifenConsume(curriculumInfo.getRequireIntegral());
            // 生成支付流水号(规则"CO" + 时间戳 + 用户id + 随机数4位)
            curriculumOrderDO.setOrderNo("CO" + TDateUtil.getDateStr(new Date(), "yyyyMMddHHmmss") + id + CodeUtil.getRandomNum(4));
            return ResultBody.success(flyerTrainingService.curriculumPayByIntegral(curriculumOrderDO));
        } else {
            return ResultBody.error("积分不足，购买失败");
        }
    }

    @ApiOperation(value = "购买课程-使用金额-去支付")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/curriculumPayByMoney")
    public ResultBody curriculumPayByMoney(HttpServletRequest request,@RequestBody CurriculumPayVO curriculumPayVO) {

        return  flyerTrainingService.curriculumPayByMoney(request,curriculumPayVO,this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }
}
