package com.mmc.csf.infomation.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/17 10:14
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ServiceRequirementsVO implements Serializable {

    private static final long serialVersionUID = -447951390213113317L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "id", example = "1")
    @NotNull(message = "服务类型名称不能为空", groups = {Insert.class, Update.class})
    private Integer serviceId;

    @ApiModelProperty(value = "飞行日期——任务开始时间", example = "2023-07-25", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskStartTime;

    @ApiModelProperty(value = "飞行日期——任务结束时间", example = "2023-07-26", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskEndTime;

    @ApiModelProperty(value = "飞行位置——任务地址", example = "广东省深圳市", required = true)
    @NotBlank(message = "任务地址不能为空", groups = {Insert.class, Update.class})
    private String taskAddress;


    @ApiModelProperty(value = "飞行位置——任务经度", example = "23.344324", required = true)
    private Double longitude;

    @ApiModelProperty(value = "飞行位置——任务纬度", example = "44.344324", required = true)
    private Double latitude;


    @ApiModelProperty(value = "任务需求描述", example = "描述一下", required = true)
    @NotNull(message = "任务需求描述不能为空", groups = {Insert.class})
    @Length(max = 300, message = "字符过长")
    private String requireDescription;

    @ApiModelProperty(value = "订单金额", example = "100", required = true)
    @NotNull(message = "订单金额", groups = {Insert.class})
    // @DecimalMin(value = "100", message = "订单金额不小于100")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "飞手保险1飞手保险 2三者保险 3机身保险", example = "1,2,3", required = true)
    @NotNull(message = "飞手保险", groups = {Insert.class})
    private String insurance;

    @ApiModelProperty(value = "订单级别 todo:前端传英文,后台自己获取金额 订单级别(REGULAR_ORDER,RUSH_ORDER,TOP_ORDER)", example = "REGULAR_ORDER", required = true)
    @NotNull(message = "订单级别", groups = {Insert.class})
    private OrderLevelEnum orderLevelEnum;

    @ApiModelProperty(value = "后台获取token里面的用户id", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "发布者姓名", example = "张三")
    private String publishName;

    @ApiModelProperty(value = "发布者电话", example = "1892994543", required = true)
    @NotNull(message = "发布者电话不能为空", groups = {Insert.class})
    private String publishPhone;


    @ApiModelProperty(value = "云享金", example = "10", hidden = true)
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金", example = "10", hidden = true)
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信支付订单编号", example = "R202308191657303116170")
    private String wechatPayOrderNumber;

    @ApiModelProperty(value = "支付方式，云享金：1，佣金：2，微信支付：3", example = "1,2,3")
    private String paymentType;

    @ApiModelProperty(value = "微信金额", example = "10", hidden = true)
    private BigDecimal weChat;

    @ApiModelProperty(value = "地区编码", example = "307013")
    private String adcode;

    @ApiModelProperty(value = "省份编码", required = false)
    //@NotNull(message = "省份编码不能为空", groups = {Insert.class})
    private Integer provinceCode;
    @ApiModelProperty(value = "市编码", required = false)
    private Integer cityCode;
    @ApiModelProperty(value = "区编码", required = false)
    private Integer districtCode;

    @ApiModelProperty(value = "订单总共需要多少人")
    private Integer requireNum;

    @ApiModelProperty(value = "订单项目号")
    private String projectCode;

    @ApiModelProperty(value = "二级服务分类")
    private String inspectionId;
}
