package com.mmc.csf.release.timerTask;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.service.RequirementsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * @Author small
 * @Date 2023/8/24 20:59
 * @Version 1.0
 */
@EnableScheduling
@Component
public class ServiceTakeDownTask {

    @Autowired
    private RequirementsService requirementsService;

    //0 30 0 * * ?
    //* * * * * ?
    //@Scheduled(cron = "0 30 0 * * ?")
    //@Scheduled(cron = "* * * * * ?")
   // @Scheduled(cron = "0 0/3 * * * ?")
     @Scheduled(cron = "0 30 0 * * ?")
    public void orderCheck() {
        String format = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        ResultBody resultBody = requirementsService.orderRequirements(format);
        System.out.println(resultBody);
        System.out.println("查询订单成功");
    }
}
