package com.mmc.csf.release.gambit.qo;

import com.mmc.csf.release.model.group.Freeze;
import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/9/18 11:01
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TopicDynamicsQO {
    @ApiModelProperty(value = "页码",example = "1")
    @NotNull(message = "页码不能为空", groups = { Page.class, Freeze.class })
    @Min(value = 1, groups = Page.class,message = "pageNo不能少于1")
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数",example = "10")
    @NotNull(message = "每页显示数不能为空", groups = { Page.class, Freeze.class })
    @Min(value = 1, groups = Page.class,message = "pageSize不能少于1")
    private Integer pageSize;

    @ApiModelProperty(value = "话题id",example = "1")
    private Integer gambitId;


    /**
     * 初始化起始查询行并返回当前页
     */
    public Integer buildCurrentPage() {
        Integer pageNo = this.pageNo;
        this.pageNo = (pageNo - 1) * pageSize;
        return pageNo;
    }

}
