package com.mmc.csf.infomation.dto;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/29 9:37
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RequirementsAmountUpdateDTO {
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    private FlowDictionaryDTO flowDictionaryDTO;

    @ApiModelProperty(value = "", hidden = true)
    private Integer serviceFlowId;

    @ApiModelProperty(value = "服务需求id", required = true)
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "图片地址", example = "http://")
    private String url;

}
