package com.mmc.csf.release.gambit.dto;

import com.mmc.csf.release.forum.vo.DynamicVO;
import com.mmc.csf.release.forum.vo.ForumReviewVO;
import com.mmc.csf.release.forum.vo.MediaVO;
import com.mmc.csf.release.forum.vo.UserBaseInfoVO;
import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/9/26 15:32
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ForumDynamicGambitDTO {
    @ApiModelProperty(value = "话题名称",example = "#深圳暴雨,#深圳大雨")
    private List<String> gambitName;

    @ApiModelProperty(value = "话题图标",example = "小程序给默认值")
    @NotBlank(message = "话题图标不能为空",groups = {Create.class, Update.class})
    private String gambitIcon;

    @ApiModelProperty(value = "话题封面",example = "小程序给默认封面")
    @NotBlank(message = "话题封面不能为空",groups = {Create.class,Update.class})
    private String gambitCover;


    @ApiModelProperty(value = "发布动态用户信息")
    private UserBaseInfoVO userBaseInfo;

    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;

    @ApiModelProperty(value = "动态id")
    private Integer id;

    @ApiModelProperty(value = "动态描述")
    private String description;

    @ApiModelProperty(value = "位置信息")
    private String location;

    @ApiModelProperty(value = "纬度")
    private BigDecimal lat;

    @ApiModelProperty(value = "经度")
    private BigDecimal lon;

    @ApiModelProperty(value = "媒体资源")
    private List<MediaVO> mediaVO;

    @ApiModelProperty(value = "点赞数")
    private Integer likesCount;

    @ApiModelProperty(value = "评论数")
    private Integer commentCount;

    @ApiModelProperty(value = "是否点赞")
    private Boolean likes;

    @ApiModelProperty(value = "动态发布时间")
    private Date dynamicPublishTime;

    @ApiModelProperty(value = "评论信息")
    private List<DynamicVO> commentAndReplyVO;

    @ApiModelProperty("评论")
    private ForumReviewVO forumReviewVO;

    @ApiModelProperty(value = "话题列表")
    private List<ForumGambitDTO> forumGambitDTOList;

    @ApiModelProperty(value = "转发数")
    private Integer transpond;

}
