
package com.mmc.csf.release.flyer.qo;

import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2023/5/17 14:16
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CurriculumQo implements Serializable {
    private static final long serialVersionUID = 3124398495152234751L;
    @ApiModelProperty(value = "课程名称")
    private String curriculumName;
    @ApiModelProperty(value = "省份编码")
    private Integer provinceCode;
    @ApiModelProperty(value = "执照id")
    private Integer licenseId;
    @ApiModelProperty(value = "技能id")
    private Integer flightSkillsId;
    @ApiModelProperty(value = "课程类型id")
    private Integer categoriesId;
    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = { Page.class })
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = { Page.class })
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;
    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
