package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.flyer.qo.CurriculumQo;
import com.mmc.csf.release.flyer.vo.CurriculumInfoVO;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import com.mmc.csf.release.service.FlyerTrainingService;
import com.mmc.csf.release.flyer.vo.DronePilotLicenseVO;
import com.mmc.csf.release.flyer.vo.FlightSkillsVO;
import com.mmc.csf.release.flyer.vo.RegistrationVO;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;


/**
 * @Author LW
 * @date 2023/5/13 11:00
 * 概要：
 */
@Api(tags = {"web-小程序-飞手培训-模块"})
@RestController
@RequestMapping("/curriculum/")
public class FlyerTrainingController extends BaseController{

    @Resource
    private FlyerTrainingService flyerTrainingService;

    @ApiOperation(value = "飞手报名")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/pilotRegistration")
    public ResultBody pilotRegistration(@RequestBody RegistrationVO registrationVO, HttpServletRequest request) {
        return flyerTrainingService.pilotRegistration(registrationVO,this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }


    @ApiOperation(value = "无人机驾驶员执照-树形图")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DronePilotLicenseVO.class)})
    @GetMapping("/getDronePilotLicense")
    public ResultBody getDronePilotLicense() {
        return flyerTrainingService.getDronePilotLicense();
    }

    @ApiOperation(value = "行业应用认证-下拉列表(课程技能列表)")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = FlightSkillsVO.class)})
    @GetMapping("/getIndustryFlightSkills")
    public ResultBody getIndustryFlightSkills() {
        return flyerTrainingService.getIndustryFlightSkills();
    }

    @ApiOperation(value = "考证-技能")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @GetMapping("/licenseOrSkillQueryCurriculum")
    public ResultBody licenseOrSkillQueryCurriculum(@ApiParam(value = "考证/技能 0：考证 1：技能") @RequestParam(value = "type") Integer type) {
        return flyerTrainingService.licenseOrSkillQueryCurriculum(type);
    }

    @ApiOperation(value = "V1.0.1课程技能列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = FlightSkillsVO.class)})
    @GetMapping("treeCurriculumSkill")
    public ResultBody treeCurriculumSkill() {
        return flyerTrainingService.treeCurriculumSkill();
    }

    @ApiOperation(value = "V1.0.1课程视频列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @PostMapping("/queryCurriculumInfoList")
    public ResultBody queryCurriculumInfoList(@RequestBody CurriculumQo curriculumQo) {
        return ResultBody.success(flyerTrainingService.queryCurriculumInfoList(curriculumQo));
    }

    @ApiOperation(value = "V1.0.1课程视频详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @GetMapping("/curriculumDetails")
    public ResultBody curriculumDetails(@ApiParam(value = "课程id") @RequestParam(value = "id") Integer id) {
        return flyerTrainingService.curriculumDetails(id);
    }

    @ApiOperation(value = "V1.0.1新增课程")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @PostMapping("addCurriculum")
    public ResultBody addCurriculum(@Validated(Insert.class)@RequestBody CurriculumInfoVO curriculumInfoVO) {
        return ResultBody.success(flyerTrainingService.addCurriculum(curriculumInfoVO));
    }

    @ApiOperation(value = "V1.0.1修改课程")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CurriculumInfoVO.class)})
    @PostMapping("updateCurriculum")
    public ResultBody updateCurriculum(@Validated(Update.class) @RequestBody CurriculumInfoVO curriculumInfoVO) {
        return ResultBody.success(flyerTrainingService.updateCurriculum(curriculumInfoVO));
    }

    @ApiOperation(value = "V1.0.1删除课程")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeCurriculum")
    public ResultBody removeCurriculum(@RequestParam Integer id) {
        return ResultBody.success(flyerTrainingService.removeCurriculum(id));
    }
}
