package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.json.JsonUtil;
import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.HttpsRequestUtil;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.config.IsNullConvertZeroUtil;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.qo.MyPreemptQO;
import com.mmc.csf.infomation.qo.MyPublishQO;
import com.mmc.csf.infomation.vo.*;
import com.mmc.csf.release.constant.*;
import com.mmc.csf.release.controller.countDown.RedisUtil;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.entity.requirements.*;
import com.mmc.csf.release.feign.PmsAppApi;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.industry.IndustryTypeDTO;
import com.mmc.csf.release.industry.UserPayInfoVO;
import com.mmc.csf.release.service.RequirementsService;
import com.mmc.csf.release.util.RestTemplateUtil;
import lombok.extern.slf4j.Slf4j;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static com.mmc.csf.common.util.redis.RedisConstant.createWxToken;

/**
 * @author: zj
 * @Date: 2023/5/18 14:29
 */
@Slf4j
@Service
public class RequirementsServiceImpl implements RequirementsService {

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private RequirementsDao requirementsDao;

    @Autowired
    private UserAppApi userAppApi;

    @Autowired
    private RestTemplateUtil restTemplateUtil;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${iuav.omsapp.url}")
    private String omsApp;

    @Autowired
    private PmsAppApi pmsAppApi;

    @Value("${iuav.userapp.url}")
    private String userApp;

    @Value("${iuav.pmsapp.url}")
    private String pmsApp;
    @Value("${iuav.payment.url}")
    private String paymentApp;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private UserSystemConstant userSystemConstant;

    @Override
    public ResultBody listType(Integer id) {
        List<RequirementsTypeDO> requirementsTypeDOList = requirementsDao.listTypeReq(id);
        List<RequirementsTypeVO> requirementsTypeVOList = requirementsTypeDOList.stream().map(RequirementsTypeDO::buildRequirementsTypeVO).collect(Collectors.toList());
        return ResultBody.success(requirementsTypeVOList);
    }

    @Override
    public ResultBody publish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        //是否完成认证
//        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(requirementsInfoVO.getUserAccountId());
//        if (userAccountSimpleDTO == null || !userAccountSimpleDTO.getCompanyAuthStatus().toString().equals("1")){
//            return ResultBody.error(ResultEnum.COMPANY_NOT_VERIFY_ERROR);
//        }

        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        requirementsInfoDO.setPublisherNumber(randomOrderCode());
        requirementsDao.addRequirementsInfo(requirementsInfoDO);
        return ResultBody.success();
    }

    HttpHeaders headers = new HttpHeaders();


    @Override
    public ResultBody solveRequire(Integer requirementsInfoId, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.getRequirementsInfoById(requirementsInfoId);
        if (!requirementsInfoDO.getUserAccountId().toString().equals(userAccountId.toString())) {
            return ResultBody.error("无权限");
        }
        requirementsDao.solveRequire(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody listPublishPage(IndustryCaseQO industryCaseQO, HttpServletRequest request) {
        //查询对应地区的用户
        int count = requirementsDao.countListPublishPage(industryCaseQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), count));
        }
        Integer pageNo = industryCaseQO.getPageNo();
        industryCaseQO.buildCurrentPage();
        List<RequirementsInfoDO> requirementsInfoDOList = requirementsDao.listPublishPage(industryCaseQO);
        List<RequirementsInfoVO> requirementsInfoVOS = requirementsInfoDOList.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        Map<Integer, String> collect = requirementsDao.listType().stream().collect(Collectors.toMap(RequirementsTypeDO::getId, d -> d.getTypeName()));
        for (RequirementsInfoVO requirementsInfoVO : requirementsInfoVOS) {
            requirementsInfoVO.setRequirementTypeName(collect.get(requirementsInfoVO.getRequirementTypeId()));
        }
        return ResultBody.success(PageResult.buildPage(pageNo, industryCaseQO.getPageSize(), count, requirementsInfoVOS));
    }

    @Override
    public ResultBody deleteRequire(Integer requirementsInfoId, Integer userAccountId) {
        requirementsDao.removeRequire(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody updatePublish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        Integer publish = requirementsDao.findPublish(requirementsInfoDO);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_MODIFY_REQUIREMENTS_PUBLISHED_BY_OTHERS);
        }
        requirementsDao.updatePublish(requirementsInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deletePublish(Integer id, Integer userAccountId) {
        Integer publish = requirementsDao.findPublishCount(id, userAccountId);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_DELETE_REQUIREMENTS_POSTED_BY_OTHERS);
        }
        requirementsDao.requirementsDao(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody appPublishList() {
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.appPublishList();
        //远程调用服务一级分类
        List<IndustryTypeDTO> industryTypeDTOS = listIndustry();
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        for (RequirementsInfoVO requirementsInfoVO : collect) {
            for (IndustryTypeDTO industryTypeDTO : industryTypeDTOS) {
                if (requirementsInfoVO.getServiceId() != null && requirementsInfoVO.getServiceId().equals(industryTypeDTO.getId())) {
                    requirementsInfoVO.setServiceName(industryTypeDTO.getTypeName());
                }
            }
        }
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody detailPublish(Integer id, HttpServletRequest request, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(id);
        RequirementsInfoVO requirementsInfoVO = requirementsInfoDO.buildRequirementsInfoVO();
        if (userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.00));
        } else if (!userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.10));
        }
        requirementsInfoVO.setOrderNumber(randomOrderCode());
        requirementsInfoVO.setPublishAccountId(requirementsInfoDO.getUserAccountId());
        requirementsInfoVO.setRequirementsInfoId(requirementsInfoDO.getId());
        //IndustryTypeDTO industryTypeDTO = pmsAppApi.feignQquerygetIndustryTypeById(requirementsInfoVO.getServiceId());
        IndustryTypeDTO industryTypeDTO = getIndustryTypeById(requirementsInfoVO.getServiceId());
        requirementsInfoVO.setServiceName(industryTypeDTO.getTypeName());
        //已经支付
        String s = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getId().toString());
        RequirementsInfoVO orderVO = JSON.parseObject(s, RequirementsInfoVO.class);
        if (s != null) {
            if (requirementsInfoDO.getId().equals(orderVO.getRequirementsInfoId()) && userAccountId.equals(orderVO.getUserAccountId())) {
                requirementsInfoVO.setParamMoney(new BigDecimal(0));
                requirementsInfoVO.setOrderNumber(orderVO.getOrderNumber());
                requirementsInfoVO.setPublishPhone("");
                return ResultBody.success(requirementsInfoVO);
            }
        }
        //生成
        ResultBody resultBody = releaseOrder(requirementsInfoVO, request.getHeader("token"));
        if (resultBody.getCode().equals(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED.getResultCode())) {
            return resultBody;
        }
        if (requirementsInfoVO.getPublish() == 0) {
            requirementsInfoVO.setPublishPhone("");
        }
        return ResultBody.success(requirementsInfoVO);
    }


    @Override
    public ResultBody backDetailPublish(Integer id, HttpServletRequest request, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(id);
        RequirementsInfoVO requirementsInfoVO = requirementsInfoDO.buildRequirementsInfoVO();
        if (userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.00));
        } else if (!userAccountId.equals(requirementsInfoVO.getUserAccountId())) {
            requirementsInfoVO.setParamMoney(BigDecimal.valueOf(0.10));
        }
        requirementsInfoVO.setOrderNumber(randomOrderCode());
        requirementsInfoVO.setPublishAccountId(requirementsInfoDO.getUserAccountId());
        requirementsInfoVO.setRequirementsInfoId(requirementsInfoDO.getId());

        //已经支付
        String s = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getId().toString());
        RequirementsInfoVO orderVO = JSON.parseObject(s, RequirementsInfoVO.class);
        if (s != null) {
            if (requirementsInfoDO.getId().equals(orderVO.getRequirementsInfoId()) && userAccountId.equals(orderVO.getUserAccountId())) {
                requirementsInfoVO.setParamMoney(new BigDecimal(0));
                requirementsInfoVO.setOrderNumber(orderVO.getOrderNumber());
                requirementsInfoVO.setPublishPhone("");
                return ResultBody.success(requirementsInfoVO);
            }
        }

        //生成
        ResultBody resultBody = releaseOrder(requirementsInfoVO, request.getHeader("token"));
        if (resultBody.getCode().equals(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED.getResultCode())) {
            return resultBody;
        }
        requirementsInfoVO.setPublishPhone("");
        return ResultBody.success(requirementsInfoVO);
    }

    @Override
    public ResultBody<GetOrderNumberDTO> publisherNumber(GetOrderNumberVO getOrderNumberVO, HttpServletRequest request) {
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();

        ServiceRequirementsDO requirementsInfoDO = new ServiceRequirementsDO();
        IsNullConvertZeroUtil.checkIsNull(requirementsInfoDO);
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        //用户钱包信息接口
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        GetOrderNumberDTO orderNumberDTO = new GetOrderNumberDTO();
        orderNumberDTO.setUserAccountId(getOrderNumberVO.getUserAccountId());
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();
        //用户云享金+用户佣金>总金额
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        //用户云享金加上佣金的总金额
        BigDecimal cashAndSalary = cashAmt.add(salaryAmt);
        //需要支付的总金额
        BigDecimal totalAmount = getOrderNumberVO.getOrderAmount().add(OrderLevelEnum.match(getOrderNumberVO.getOrderLevelEnum().getKey()).getValue());
        BigDecimal rushAndTop = OrderLevelEnum.match(getOrderNumberVO.getOrderLevelEnum().getKey()).getValue();
        String orderLevelEnum = OrderLevelEnum.match(getOrderNumberVO.getOrderLevelEnum().getKey()).getKey();
        //需要支付的总金额
        BigDecimal orderAmount = getOrderNumberVO.getOrderAmount();
        String paymentType = getOrderNumberVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        //用户剩余的佣金
        BigDecimal userSalaryAmt = new BigDecimal(0);
        //云享金余额还剩余多少
        BigDecimal userCashAmt = new BigDecimal(0);
        BigDecimal tempTotalAmount = new BigDecimal(0);
        //存在置顶或加急
        if (rushAndTop.compareTo(BigDecimal.ZERO) != 0) {
            tempTotalAmount = rushAndTop;
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                //加急云享金支付
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentYxjAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelCashAmount(tempTotalAmount);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {

                                    if (rushAndTop.compareTo(cashAmt) == 1) {
                                        publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                        requirementsInfoDO.setLevelCashAmount(tempTotalAmount);
                                    } else if (rushAndTop.compareTo(cashAmt) == -1) {
                                        // userCashAmt = cashAmt.subtract(rushAndTop);
                                        publisherWalletFlowVO.setTopYxjAmount(rushAndTop);
                                        requirementsInfoDO.setLevelCashAmount(rushAndTop);
                                    }
                                }
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                // walletFlowVO.setCashAmount(cashAmt);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentYxjAmount(cashAmt);
                                    requirementsInfoDO.setLevelCashAmount(cashAmt);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    System.out.println(cashAmt);

                                    publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                    requirementsInfoDO.setLevelCashAmount(cashAmt);
                                }
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                //  walletFlowVO.setSalaryAmount(tempTotalAmount);
                                publisherWalletFlowVO.setTopSalaryAmount(tempTotalAmount);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentSalaryAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelSalaryAmount(tempTotalAmount);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopSalaryAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelSalaryAmount(tempTotalAmount);
                                }

                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                // walletFlowVO.setSalaryAmount(salaryAmt);
                                publisherWalletFlowVO.setTopSalaryAmount(salaryAmt);
                                requirementsInfoDO.setLevelSalaryAmount(salaryAmt);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentSalaryAmount(salaryAmt);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopSalaryAmount(salaryAmt);
                                    requirementsInfoDO.setLevelSalaryAmount(salaryAmt);
                                }
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            //需要支付微信
                            requirementsInfoDO.setLevelWeChatAmount(tempTotalAmount);
                            // walletFlowVO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }

            System.out.println(requirementsInfoDO);
            System.out.println(publisherWalletFlowVO);

            if (orderLevelEnum.equals("RUSH_ORDER")) {
                //加急的云享金
                BigDecimal urgentYxjAmount = publisherWalletFlowVO.getUrgentYxjAmount();
                userCashAmt = cashAmt.subtract(urgentYxjAmount);
                BigDecimal urgentSalaryAmount = publisherWalletFlowVO.getUrgentSalaryAmount();
                userSalaryAmt = salaryAmt.subtract(urgentSalaryAmount);

            } else if (orderLevelEnum.equals("TOP_ORDER")) {
                //置顶的云享金
                BigDecimal topYxjAmount = publisherWalletFlowVO.getTopYxjAmount();
                userCashAmt = cashAmt.subtract(topYxjAmount);
                BigDecimal topSalaryAmount = publisherWalletFlowVO.getTopSalaryAmount();
                userSalaryAmt = salaryAmt.subtract(topSalaryAmount);
            }
            tempTotalAmount = orderAmount;
            //剩下的用于支付任务佣金
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (userCashAmt.compareTo(tempTotalAmount) == 1 || userCashAmt.compareTo(tempTotalAmount) == 0) {
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                publisherWalletFlowVO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(userCashAmt);
                                publisherWalletFlowVO.setCashAmount(userCashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (userSalaryAmt.compareTo(tempTotalAmount) == 1 || userSalaryAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(userSalaryAmt);
                                publisherWalletFlowVO.setSalaryAmount(userSalaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            // publisherWalletFlowVO.setWeChat(tempTotalAmount);
                            requirementsInfoDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }
        }
        //不存在加急或者置顶
        if (rushAndTop.compareTo(BigDecimal.ZERO) == 0) {
            if (getOrderNumberVO.getOrderMode() == 2) {
                Integer requirementsInfoId = getOrderNumberVO.getRequirementsInfoId();
                orderNumberDTO.setRequirementsInfoId(requirementsInfoId);
                RequirementsInfoDO requirementsInfoDO1 = requirementsDao.detailPublish(requirementsInfoId);
                BigDecimal orderAmount1 = requirementsInfoDO1.getOrderAmount();
                BigDecimal bigDecimal = new BigDecimal(0.3);
                tempTotalAmount = orderAmount1.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
            } else if (getOrderNumberVO.getOrderMode() == 1) {
                tempTotalAmount = orderAmount;
            }
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setCashAmount(tempTotalAmount);
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                publisherWalletFlowVO.setCashAmount(cashAmt);
                                //  walletFlowVO.setCashAmount(cashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                publisherWalletFlowVO.setSalaryAmount(salaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            requirementsInfoDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }
        }
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了
            System.out.println(requirementsInfoDO);
            System.out.println(publisherWalletFlowVO);
            BigDecimal weChat = requirementsInfoDO.getWeChat();

            BigDecimal levelWeChatAmount = requirementsInfoDO.getLevelWeChatAmount();
            BigDecimal add = weChat.add(levelWeChatAmount);
            orderNumberDTO.setWeChatPay(add);
            if (orderNumberDTO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
                stringRedisTemplate.opsForValue().set(orderNumberDTO.getPaymentOrderNumber(), JsonUtil.parseObjToJson(orderNumberDTO));
            }
            return ResultBody.success(orderNumberDTO);
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("下单失败");
        }


    }

    @Override
    public ResultBody<GetOrderNumberDTO> updatePublisherNumber(GetOrderNumberUpdateVO getOrderNumberUpdateVO, HttpServletRequest request) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(getOrderNumberUpdateVO.getRequirementsInfoId(), getOrderNumberUpdateVO.getUserAccountId());
        if (requirementsInfoDO == null) {
            return ResultBody.error("只能修改自己发布的服务需求");
        }
        Integer serviceFlowId = requirementsInfoDO.getServiceFlowId();
        if (serviceFlowId != 1) {
            return ResultBody.error("只有未抢单的信息才能被修改");
        }
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        ApplyRefundVO applyRefundVO = new ApplyRefundVO();

        // requirementsDao.updateInfo(requirementsInfoDO.getId(), 7);
        //  requirementsDao.updateServiceAmount(requirementsInfoDO.getId());
        RequirementsServiceDO requirementsServiceDO = new RequirementsServiceDO();

        //用户钱包信息接口
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        GetOrderNumberDTO orderNumberDTO = new GetOrderNumberDTO();
        IsNullConvertZeroUtil.checkIsNull(orderNumberDTO);
        orderNumberDTO.setUserAccountId(getOrderNumberUpdateVO.getUserAccountId());
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();
        //用户云享金+用户佣金>总金额
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        //需要支付的总金额
        BigDecimal orderAmount = getOrderNumberUpdateVO.getOrderAmount();
        String paymentType = getOrderNumberUpdateVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        BigDecimal tempTotalAmount = orderAmount;
        //不存在加急或者置顶
        for (String type : objects) {
            switch (type) {
                case "1":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                            requirementsServiceDO.setCashAmount(tempTotalAmount);
                            // walletFlowVO.setCashAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                            requirementsServiceDO.setCashAmount(cashAmt);
                            //  walletFlowVO.setCashAmount(cashAmt);
                        }
                    }
                    break;
                case "2":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                            requirementsServiceDO.setSalaryAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                            requirementsServiceDO.setSalaryAmount(salaryAmt);
                        }
                    }

                    break;
                case "3":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        requirementsServiceDO.setWeChat(tempTotalAmount);
                        tempTotalAmount = BigDecimal.ZERO;
                    }
                    break;
                default:
                    break;
            }
        }
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了
            System.out.println(requirementsServiceDO.getWechatPayOrderNumber());
            orderNumberDTO.setWeChatPay(requirementsServiceDO.getWeChat());
            IsNullConvertZeroUtil.checkIsNull(orderNumberDTO);
            if (orderNumberDTO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                orderNumberDTO.setWeChatPay(requirementsServiceDO.getWeChat());
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
                stringRedisTemplate.opsForValue().set(orderNumberDTO.getPaymentOrderNumber(), JsonUtil.parseObjToJson(orderNumberDTO));
            }
            return ResultBody.success(orderNumberDTO);
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("下单失败");
        }
    }


    @Override
    public ResultBody<GetOrderNumberDTO> updateAmountGetNumber(UpdateAmountGetNumberVO getNumberVO, HttpServletRequest request) {
        RequirementsAmountUpdateDO amountUpdateDO = new RequirementsAmountUpdateDO();
        IsNullConvertZeroUtil.checkIsNull(amountUpdateDO);
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(getNumberVO.getRequirementsInfoId(), getNumberVO.getUserAccountId());
        if (requirementsInfoDO == null) {
            return ResultBody.error("只能修改自己发布的服务需求");
        }
        //用户钱包信息接口
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        GetOrderNumberDTO orderNumberDTO = new GetOrderNumberDTO();
        IsNullConvertZeroUtil.checkIsNull(orderNumberDTO);
        orderNumberDTO.setUserAccountId(getNumberVO.getUserAccountId());
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();
        //用户云享金+用户佣金>总金额
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        //需要支付的总金额
        BigDecimal orderAmount = getNumberVO.getOrderAmount();
        String paymentType = getNumberVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        BigDecimal tempTotalAmount = orderAmount;
        //校验是退款还是需要继续支付
        //继续支付 需要增加冻结的任务佣金
        if (getNumberVO.getOrderAmount().compareTo(requirementsInfoDO.getOrderAmount()) == 1) {
            tempTotalAmount = getNumberVO.getOrderAmount().subtract(requirementsInfoDO.getOrderAmount());
            //不存在加急或者置顶
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                amountUpdateDO.setCashAmount(tempTotalAmount);
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                amountUpdateDO.setCashAmount(cashAmt);
                                //  walletFlowVO.setCashAmount(cashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                amountUpdateDO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                amountUpdateDO.setSalaryAmount(salaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            amountUpdateDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }
        }

        if (getNumberVO.getOrderAmount().compareTo(requirementsInfoDO.getOrderAmount()) == -1 ||
                getNumberVO.getOrderAmount().compareTo(requirementsInfoDO.getOrderAmount()) == 0) {
            tempTotalAmount = new BigDecimal(0);
        }

        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        ApplyRefundVO applyRefundVO = new ApplyRefundVO();


        System.out.println(amountUpdateDO);


        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了
            orderNumberDTO.setWeChatPay(amountUpdateDO.getWeChat());
            if (orderNumberDTO.getWeChatPay().compareTo(BigDecimal.ZERO) != 0) {
                orderNumberDTO.setWeChatPay(amountUpdateDO.getWeChat());
                orderNumberDTO.setPaymentOrderNumber(randomOrderCode());
                stringRedisTemplate.opsForValue().set(orderNumberDTO.getPaymentOrderNumber(), JsonUtil.parseObjToJson(orderNumberDTO));
            }
            return ResultBody.success(orderNumberDTO);
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("下单失败");
        }
    }


    @Override
    public PageResult myPreempt(Integer userAccountId, MyPreemptQO param) {
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        param.setUserAccountId(userAccountId);
        int count = requirementsDao.myPreemptCount(param);
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.myPreempt(param);
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        List<IndustryTypeDTO> industryTypeDTOS = listIndustry();
        for (RequirementsInfoVO requirementsInfoVO : collect) {
            for (IndustryTypeDTO industryTypeDTO : industryTypeDTOS) {
                if (requirementsInfoVO.getServiceId() != null && requirementsInfoVO.getServiceId().equals(industryTypeDTO.getId())) {
                    requirementsInfoVO.setServiceName(industryTypeDTO.getTypeName());
                }
            }
        }
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);
    }

    @Override
    public ResultBody droneFlyerCancel(Integer requirementsInfoId, Integer userAccountId, HttpServletRequest request) {
        RequirementsInfoDO infoDO = requirementsDao.publisherCancelFlyer(requirementsInfoId);
        RequirementsServiceDO requirementsServiceDO = requirementsDao.droneFlyerCancel(requirementsInfoId, userAccountId);
        IsNullConvertZeroUtil.checkIsNull(requirementsServiceDO);
        Integer serviceFlowId = requirementsServiceDO.getServiceFlowId();
        if (serviceFlowId != 2) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_CANCEL_THE_ORDER_AT_THIS_TIME.getResultMsg());
        }
        BigDecimal bigDecimal = new BigDecimal(0.9);
        BigDecimal preemptTotalAmount = requirementsServiceDO.getPreemptTotalAmount();
        BigDecimal percentagePenaltyOfOrder = preemptTotalAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
        //平台抽取百分之十
        BigDecimal earnings = preemptTotalAmount.multiply(new BigDecimal(0.1)).setScale(2, BigDecimal.ROUND_HALF_UP);
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        FlyerWalletFlowVO flyerWalletFlowVO = new FlyerWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(flyerWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(walletFlowVO);
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(walletFlowVO);
        flyerWalletFlowVO.setModeOfPayment(600);
        flyerWalletFlowVO.setPercentagePenaltyOfOrder(percentagePenaltyOfOrder.negate());
        flyerWalletFlowVO.setUserAccountId(userAccountId);
        flyerWalletFlowVO.setOperateUserAccountId(userAccountId);
        //如果微信里面的钱大于需要扣除的钱
       /* if (requirementsServiceDO.getWeChat().compareTo(preemptTotalAmount) == 1 ||
                requirementsServiceDO.getWeChat().compareTo(preemptTotalAmount) == 0) {
            //
        }*/
        //如果微信里面的钱小于需要扣除的金额
        if (requirementsServiceDO.getWeChat().compareTo(preemptTotalAmount) == -1) {
            //优先扣除微信的钱
            BigDecimal subtract = preemptTotalAmount.subtract(requirementsServiceDO.getWeChat());
            if (requirementsServiceDO.getSalaryAmount().compareTo(subtract) == -1) {
                BigDecimal sub2 = subtract.subtract(requirementsServiceDO.getSalaryAmount());
                flyerWalletFlowVO.setSalaryCashPledge(requirementsServiceDO.getSalaryAmount().negate());
                if (sub2.compareTo(requirementsServiceDO.getCashAmount()) == 0 ||
                        sub2.compareTo(requirementsServiceDO.getCashAmount()) == -1) {
                    //云享金扣除违约多少
                    flyerWalletFlowVO.setYxjCashPledge(sub2.negate());
                }
            } else if (requirementsServiceDO.getSalaryAmount().compareTo(subtract) == 1 ||
                    requirementsServiceDO.getSalaryAmount().compareTo(subtract) == 0) {
                flyerWalletFlowVO.setSalaryCashPledge(subtract.negate());
            }
        }
        walletFlowVO.setFlyerWalletFlowVO(flyerWalletFlowVO);
        //给发布者退钱
        publisherWalletFlowVO.setUserAccountId(infoDO.getUserAccountId());
        publisherWalletFlowVO.setModeOfPayment(600);
        publisherWalletFlowVO.setOperateUserAccountId(userAccountId);
        publisherWalletFlowVO.setSalaryAmount(infoDO.getSalaryAmount());
        publisherWalletFlowVO.setCashAmount(infoDO.getCashAmount());
        //退云享金和佣金
        if (infoDO.getOrderLevel().equals("RUSH_ORDER")) {
            publisherWalletFlowVO.setUrgentYxjAmount(infoDO.getLevelCashAmount());
            publisherWalletFlowVO.setUrgentSalaryAmount(infoDO.getLevelSalaryAmount());
        }
        if (infoDO.getOrderLevel().equals("TOP_ORDER")) {
            publisherWalletFlowVO.setTopYxjAmount(infoDO.getLevelCashAmount());
            publisherWalletFlowVO.setTopSalaryAmount(infoDO.getLevelSalaryAmount());
        }

        walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
        //给发布者微信退钱
        String wechatPayOrderNumber = infoDO.getWechatPayOrderNumber();
        if (wechatPayOrderNumber != null) {
            ApplyRefundVO applyRefundVO = new ApplyRefundVO();
            applyRefundVO.setRefund(infoDO.getWeChat().multiply(new BigDecimal(100)).longValue());
            applyRefundVO.setReason("退回微信支付金额");
            applyRefundVO.setOutTradeNo(infoDO.getWechatPayOrderNumber());
            applyRefund(applyRefundVO, request.getHeader("token"));
        }
        IsNullConvertZeroUtil.checkIsNull(infoDO);

        //任务佣金
        requirementsServiceDO.setPercentagePenaltyOfOrder(percentagePenaltyOfOrder);
        //飞手单方面取消将20之二十退回到发布者佣金里面
        flyerCancel(walletFlowVO, request.getHeader("token"));
        BigDecimal orderEarnings = requirementsServiceDO.getOrderEarnings();
        BigDecimal add = orderEarnings.add(earnings);
        requirementsServiceDO.setOrderEarnings(add);
        requirementsDao.updateAmounts(requirementsServiceDO);
        //  requirementsDao.insertPlatformOrderEarnings(earnings, requirementsInfoId, userAccountId);
        requirementsDao.updatePlatformOrderEarnings(earnings, requirementsInfoId, userAccountId);
        requirementsDao.updateScene(requirementsInfoId, 7);
        requirementsDao.updateInfo(requirementsInfoId, 7);
        requirementsDao.updateFlow(requirementsInfoId, 7);
        this.sendMsgPublishInfoAuth(requirementsServiceDO);
        return ResultBody.success(ResultEnum.PAYMENT_SUCCESS.getResultMsg());
    }


    private void sendMsgFlyerInfoAuth(RequirementsInfoDO requirementsInfoDO) {

        //订单编号

        JSONObject value1 = new JSONObject();
        value1.put("value", requirementsInfoDO.getPublisherNumber());

        //订单金额
        JSONObject value2 = new JSONObject();
        value2.put("value", requirementsInfoDO.getOrderAmount());

        //下单时间
        JSONObject value3 = new JSONObject();
        value3.put("value", requirementsInfoDO.getCreateTime());

        //取消时间
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
        String date = df.format(new Date());
        JSONObject value4 = new JSONObject();
        value4.put("value", date);

        JSONObject value5 = new JSONObject();
        String remark = "飞手已取消，你获得赔偿金" + requirementsInfoDO.getReceiveSalaryAmount() + "元";
        value5.put("value", remark);

        JSONObject datad = new JSONObject();
        //订单编号
        datad.put("character_string2", value1);
        //订单金额
        datad.put("amount3", value2);
        //下单时间
        datad.put("date5", value3);
        //取消时间
        datad.put("time7", value4);
        //备注
        datad.put("thing4", value5);

        AppletMsgVOS appletMsgVO = new AppletMsgVOS();
        appletMsgVO.setTouser(requirementsInfoDO.getFlyerOpenid());
        appletMsgVO.setTemplate_id(WxMsgTemplete.INDEMNIFY_FOR_PUBLICATION);
        appletMsgVO.setPage("pages/welcome/index");
        appletMsgVO.setData(datad);
        appletMsgVO.setMiniprogram_state(userSystemConstant.getMiniProgramState());
        appletMsgVO.setLang("zh_CN");
        sendUserAppletMsg(appletMsgVO);
    }


    private void sendMsgPublishInfoAuth(RequirementsServiceDO requirementsServiceDO) {

        //订单编号

        JSONObject value1 = new JSONObject();
        value1.put("value", requirementsServiceDO.getPublisherNumber());

        //订单金额
        JSONObject value2 = new JSONObject();
        value2.put("value", requirementsServiceDO.getOrderAmount());

        //下单时间
        JSONObject value3 = new JSONObject();
        value3.put("value", requirementsServiceDO.getCreateTime());

        //取消时间
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
        String date = df.format(new Date());
        JSONObject value4 = new JSONObject();
        value4.put("value", date);


     /*   //不通过原因
        String reason = null;
        if (param.getAuditStatus() == 1) {
            reason = userAccountDO.getUserName() + match.getMessage();
        }
        if (param.getAuditStatus() == 2) {
            PilotReasonDO pilotReasonDO = certificationDao.selectPilotReason(param.getReasonId());
            reason = pilotReasonDO.getReason();
        }
        value4.put("value", reason);*/


        JSONObject value5 = new JSONObject();
        String remark = "飞手已取消，你获得赔偿金" + requirementsServiceDO.getPercentagePenaltyOfOrder() + "元";
        value5.put("value", remark);

        JSONObject datad = new JSONObject();
        //订单编号
        datad.put("character_string2", value1);
        //订单金额
        datad.put("amount3", value2);
        //下单时间
        datad.put("date5", value3);
        //取消时间
        datad.put("time7", value4);
        //备注
        datad.put("thing4", value5);

        AppletMsgVOS appletMsgVO = new AppletMsgVOS();
        appletMsgVO.setTouser(requirementsServiceDO.getOpenid());
        appletMsgVO.setTemplate_id(WxMsgTemplete.INDEMNIFY_FOR_PUBLICATION);
        appletMsgVO.setPage("pages/welcome/index");
        appletMsgVO.setData(datad);
        appletMsgVO.setMiniprogram_state(userSystemConstant.getMiniProgramState());
        appletMsgVO.setLang("zh_CN");
        sendUserAppletMsg(appletMsgVO);
    }

    /**
     * 小程序-用户端-发送消息
     */
    public ResultBody sendUserAppletMsg(AppletMsgVOS aMsg) {
        System.out.println("###########开始发送-小程序-用户端消息##########");
        String accessToken = null;
        try {
            accessToken = getStableAccessToken();
            System.out.println("accesstoken:" + accessToken);
        } catch (Exception e) {
            System.out.println("accessToken获取失败:" + e.getMessage());
            return ResultBody.error(ResultEnum.WX_ACCESS_TOKEN_ERROR.getResultCode(),
                    ResultEnum.WX_ACCESS_TOKEN_ERROR.getResultMsg() + e.getMessage());
        }
        try {
            String url = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=" + accessToken;
            aMsg.setData(WxApiUtilS.buildMsgJson(aMsg.getData()));
            System.out.println(aMsg);

            String param = JsonUtil.parseObjToJson(aMsg);
            System.out.println("参数：" + param);
            String result = HttpsOpenUtil.httpSendPost(url, param);
            JSONObject resJson = JSONObject.parseObject(result);
            if ("40001".equals(resJson.getString("errcode"))) {
                UserSystemConstant userSystemConstant = new UserSystemConstant();
                stringRedisTemplate.delete(createWxToken(userSystemConstant.getWxAppId()));
                System.out.println("accessToken二次获取失败:" + resJson);
                return ResultBody.error(ResultEnum.WX_ACCESS_TOKEN_ERROR.getResultCode(),
                        ResultEnum.WX_ACCESS_TOKEN_ERROR.getResultMsg() + resJson);
            }
            System.out.println(result);
        } catch (Exception e) {
            System.out.println("系统异常：" + e.getMessage());
        }
        System.out.println("###########结束发送-小程序-消息##########");
        return ResultBody.success();
    }


    public String getStableAccessToken() {
        //token有效期为7200s，需要保存起来，先从redis中获取accessToken，没有则请求获取
        String accessToken = stringRedisTemplate.opsForValue().get(WxConstant.IUAV_MINI_PROGRAM_STABLE_ACCESS_TOKEN);
        if (org.apache.commons.lang.StringUtils.isBlank(accessToken)) {
            Map<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "client_credential");
            params.put("appid", userSystemConstant.getWxAppId());
            params.put("secret", userSystemConstant.getWxAppSecret());
            String stableAccessTokenUrl = "https://api.weixin.qq.com/cgi-bin/stable_token";
            String res = null;
            try {
                res = HttpsRequestUtil.httpsRequest(stableAccessTokenUrl, "POST", null, JSONObject.toJSONString(params));
            } catch (Exception e) {
                e.printStackTrace();
            }
            JSONObject tokenResult = JSONObject.parseObject(res);
            if (res.indexOf("access_token") == -1) {
                return null;
            }
            accessToken = tokenResult.getString("access_token");
            long expiresIn = tokenResult.getLong("expires_in");
            //保存进redis
            stringRedisTemplate.opsForValue().set(WxConstant.IUAV_MINI_PROGRAM_STABLE_ACCESS_TOKEN, accessToken, expiresIn, TimeUnit.SECONDS);
            return accessToken;
        }
        return accessToken;
    }


    @Override
    public ResultBody publisherCancel(Integer requirementsInfoId, Integer userAccountId, HttpServletRequest request) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(requirementsInfoId, userAccountId);
        RequirementsServiceDO serviceDO = requirementsDao.serviceReq(requirementsInfoId);
        IsNullConvertZeroUtil.checkIsNull(serviceDO);
        if (requirementsInfoDO == null) {
            return ResultBody.error("当前订单不存在");
        }
        if (requirementsInfoDO.getServiceFlowId() == 7) {
            return ResultBody.error("已取消请不要重复取消");
        }
        IsNullConvertZeroUtil.checkIsNull(requirementsInfoDO);
        Integer serviceFlowId = requirementsInfoDO.getServiceFlowId();
        ApplyRefundVO applyRefundVO = new ApplyRefundVO();
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        FlyerWalletFlowVO flyerWalletFlowVO = new FlyerWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(flyerWalletFlowVO);
        if (serviceFlowId == 1) {
            //飞手无责取消 将全部退回 不包含加急或者置顶
            //支付
            if (requirementsInfoDO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 ||
                    requirementsInfoDO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
                publisherWalletFlowVO.setModeOfPayment(200);
                publisherWalletFlowVO.setUserAccountId(userAccountId);
                publisherWalletFlowVO.setOperateUserAccountId(userAccountId);
                publisherWalletFlowVO.setSalaryAmount(requirementsInfoDO.getSalaryAmount());
                publisherWalletFlowVO.setCashAmount(requirementsInfoDO.getCashAmount());
                walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
                flyerCancel(walletFlowVO, request.getHeader("token"));
            }
            if (requirementsInfoDO.getWechatPayOrderNumber() != null
                    && requirementsInfoDO.getWeChat().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal weChat = requirementsInfoDO.getWeChat();
                BigDecimal multiply = weChat.multiply(new BigDecimal(100));
                Long longWeChat = multiply.longValue();
                applyRefundVO.setRefund(longWeChat);
                applyRefundVO.setOutTradeNo(requirementsInfoDO.getWechatPayOrderNumber());
                applyRefundVO.setReason("退发布者微信支付的任务佣金");
                applyRefund(applyRefundVO, request.getHeader("token"));
            }
            requirementsDao.updateInfo(requirementsInfoId, 7);
            requirementsDao.updateFlow(requirementsInfoId, 7);
            return ResultBody.success(ResultEnum.THE_AMOUNT_OF_THE_MISSION_WILL_BE_RETURNED.getResultMsg());
        }
        if (serviceFlowId != 2 && serviceFlowId != 1) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_CANCEL_THE_ORDER_AT_THIS_TIME.getResultMsg());
        }
        //单方面取消订单并且飞手已经抢单
        if (serviceFlowId == 2) {
            BigDecimal orderAmount = requirementsInfoDO.getOrderAmount();
            BigDecimal bigDecimal = new BigDecimal(0.7);
            //剩余金额
            BigDecimal residueOrderAmount = orderAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
            //先退微信 再退任务佣金 最后退云享金
            BigDecimal weChat = requirementsInfoDO.getWeChat();
            //微信需要退款多少金额
            //微信金额大于扣除之后的金额
            BigDecimal refundCashAmount = new BigDecimal(0);
            BigDecimal refundSalaryAmount = new BigDecimal(0);
            BigDecimal refundWeChat = new BigDecimal(0);
            //飞手获得的金额
            BigDecimal receiveSalaryAmount = orderAmount.multiply(new BigDecimal(0.2)).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal freeze = orderAmount.multiply(new BigDecimal(0.3)).setScale(2, BigDecimal.ROUND_HALF_UP);
            //微信支付金额大于需要退款金额
            if (weChat.compareTo(residueOrderAmount) == 1) {
                //用户退百分之七十的费用
                refundWeChat = residueOrderAmount;
                BigDecimal multiply = refundWeChat.multiply(new BigDecimal(100));
                Long longWeChat = multiply.longValue();
                applyRefundVO.setRefund(longWeChat);
                applyRefundVO.setReason("扣除飞手百分之三十的费用");
                applyRefundVO.setOutTradeNo(requirementsInfoDO.getWechatPayOrderNumber());
                //退款到微信
                applyRefund(applyRefundVO, request.getHeader("token"));
            }
            //微信支付金额小于需要退款金额
            if (weChat.compareTo(residueOrderAmount) == -1 ||
                    weChat.compareTo(refundCashAmount) == 0) {
                //优先扣除微信里面的钱
                BigDecimal returnToWechat = residueOrderAmount.subtract(requirementsInfoDO.getWeChat());

                BigDecimal residueAmount = new BigDecimal(0);
                if (returnToWechat.compareTo(requirementsInfoDO.getSalaryAmount()) == 1) {
                    //退回佣金
                    residueAmount = returnToWechat.subtract(requirementsInfoDO.getSalaryAmount());
                    publisherWalletFlowVO.setSalaryAmount(requirementsInfoDO.getSalaryAmount());
                    publisherWalletFlowVO.setCashAmount(residueAmount);
                }
                if (returnToWechat.compareTo(requirementsInfoDO.getSalaryAmount()) == -1) {
                    residueAmount = requirementsInfoDO.getSalaryAmount().subtract(returnToWechat);
                    publisherWalletFlowVO.setSalaryAmount(residueOrderAmount);
                }

                if (residueAmount.compareTo(BigDecimal.ZERO) == 0
                        || residueAmount.compareTo(BigDecimal.ZERO) == -1) {
                    publisherWalletFlowVO.setUserAccountId(userAccountId);
                    publisherWalletFlowVO.setOperateUserAccountId(userAccountId);
                    publisherWalletFlowVO.setModeOfPayment(300);
                    publisherWalletFlowVO.setSalaryAmount(residueAmount.negate());
                    System.out.println(residueAmount);
                    BigDecimal subtract = requirementsInfoDO.getSalaryAmount().subtract(residueAmount.negate());
                    publisherWalletFlowVO.setSalaryCashPledge(subtract.negate());
                    publisherWalletFlowVO.setYxjCashPledge(requirementsInfoDO.getCashAmount().negate());

                    //  BigDecimal subtract = requirementsInfoDO.getSalaryAmount().subtract(residueAmount.negate());
                    //  publisherWalletFlowVO.setSalaryCashPledge(subtract.negate());

                    walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
                    //flyerCancel(walletFlowVO, request.getHeader("token"));
                    //退回的佣金大于0
                } else if (residueAmount.compareTo(BigDecimal.ZERO) == 1) {
                    //  publisherWalletFlowVO.setCashAmount(residueAmount);
                    publisherWalletFlowVO.setUserAccountId(userAccountId);
                    publisherWalletFlowVO.setOperateUserAccountId(userAccountId);
                    publisherWalletFlowVO.setModeOfPayment(300);
                    walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
                    //退回任务佣金
                    //flyerCancel(walletFlowVO, request.getHeader("token"));

                }
                BigDecimal weChatAmount = requirementsInfoDO.getWeChat();
                long longWeChat = weChatAmount.multiply(new BigDecimal(100)).longValue();
                applyRefundVO.setRefund(longWeChat);
                applyRefundVO.setReason("退回方式——微信佣金云享金");
                applyRefundVO.setOutTradeNo(requirementsInfoDO.getWechatPayOrderNumber());
                applyRefund(applyRefundVO, request.getHeader("token"));
            }

            //平台抽取百分之十
            //发布者取消
            BigDecimal earnings = orderAmount.multiply(new BigDecimal(0.1)).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal orderEarnings = requirementsInfoDO.getOrderEarnings();
            BigDecimal add = orderEarnings.add(earnings);
            requirementsInfoDO.setOrderEarnings(add);
            requirementsDao.updateRequirementsAmount(requirementsInfoDO);
            // requirementsDao.insertPlatformOrderEarnings(earnings, requirementsInfoId, userAccountId);
            requirementsDao.updatePlatformOrderEarnings(earnings, requirementsInfoId, userAccountId);


            if (serviceDO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 ||
                    serviceDO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0 ||
                    serviceDO.getWeChat().compareTo(BigDecimal.ZERO) != 0) {
                System.out.println(freeze);
                //优先扣除微信
                BigDecimal weChat1 = requirementsInfoDO.getWeChat();
                //如果微信扣除的金额小于飞手获得的钱
                if (weChat1.compareTo(freeze) == -1) {
                    //还需要扣除多少
                    BigDecimal subtract = freeze.subtract(weChat1);
                    if (subtract.compareTo(requirementsInfoDO.getSalaryAmount()) == 1) {
                        publisherWalletFlowVO.setSalaryCashPledge(requirementsInfoDO.getSalaryAmount().negate());
                        //
                        BigDecimal subtract1 = subtract.subtract(requirementsInfoDO.getSalaryAmount());
                        if (subtract1.compareTo(BigDecimal.ZERO) == 0 || subtract1.compareTo(BigDecimal.ZERO) == 1) {
                            publisherWalletFlowVO.setYxjCashPledge(subtract1.negate());
                        }
                    } else if (subtract.compareTo(requirementsInfoDO.getSalaryAmount()) == -1) {
                        publisherWalletFlowVO.setSalaryCashPledge(subtract.negate());
                    }

                }
                //飞手应该获得的金额
                publisherWalletFlowVO.setUserAccountId(userAccountId);
                publisherWalletFlowVO.setOperateUserAccountId(userAccountId);
                publisherWalletFlowVO.setModeOfPayment(300);
                publisherWalletFlowVO.setPercentagePenaltyOfOrder(receiveSalaryAmount.negate());
                flyerWalletFlowVO.setCashAmount(serviceDO.getCashAmount());
                flyerWalletFlowVO.setSalaryAmount(serviceDO.getSalaryAmount());
                flyerWalletFlowVO.setUserAccountId(requirementsInfoDO.getPilotCertificationUserId());
                flyerWalletFlowVO.setOperateUserAccountId(userAccountId);
                flyerWalletFlowVO.setModeOfPayment(300);
                walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
                walletFlowVO.setFlyerWalletFlowVO(flyerWalletFlowVO);
                String s = String.valueOf(walletFlowVO);
                log.info(s);
                flyerCancel(walletFlowVO, request.getHeader("token"));
            }
            //飞手全额退款
            if (serviceDO.getWechatPayOrderNumber() != null) {
                ApplyRefundVO arv = new ApplyRefundVO();
                arv.setReason("全额退款");
                arv.setRefund(serviceDO.getWeChat().multiply(new BigDecimal(100)).longValue());
                arv.setOutTradeNo(serviceDO.getWechatPayOrderNumber());
                applyRefund(arv, request.getHeader("token"));
            }

            requirementsInfoDO.setReceiveSalaryAmount(receiveSalaryAmount);
            //给飞手发送短信
            this.sendMsgFlyerInfoAuth(requirementsInfoDO);
            requirementsDao.updateInfo(requirementsInfoId, 7);
            requirementsDao.updateFlow(requirementsInfoId, 7);
            return ResultBody.success(ResultEnum.REFUND_PERCENTAGE.getResultMsg());
        }

        return ResultBody.success();
    }

    /**
     * 全额退回
     *
     * @param requirementsInfoId
     * @param userAccountId
     * @return
     */
    @Override
    public ResultBody cancelAll(Integer requirementsInfoId, Integer userAccountId) {
        RequirementsServiceDO requirementsServiceDO = requirementsDao.droneFlyerCancel(requirementsInfoId, userAccountId);
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(requirementsInfoId, userAccountId);
        requirementsDao.updateInfo(requirementsInfoId, 7);
        requirementsDao.updateScene(requirementsInfoId, 7);
        return ResultBody.success();
    }

    /**
     * 修改任务佣金
     *
     * @param amountVO
     * @param request
     * @return
     */
    @Override
    public ResultBody updatePublisherCancel(RequirementsAmountVO amountVO, HttpServletRequest request) {
        //修改任务金额
        // RequirementsAmountUpdateDO amountUpdateDO = new RequirementsAmountUpdateDO();
        // IsNullConvertZeroUtil.checkIsNull(amountUpdateDO);
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(amountVO.getRequirementsInfoId(), amountVO.getUserAccountId());
        if (requirementsInfoDO == null) {
            return ResultBody.error("只能修改自己发布的服务需求");
        }
        String json = stringRedisTemplate.opsForValue().get(amountVO.getWechatPayOrderNumber() + amountVO.getUserAccountId());
        GetOrderNumberDTO numberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);
        //用户钱包信息接口
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        GetOrderNumberDTO orderNumberDTO = new GetOrderNumberDTO();
        IsNullConvertZeroUtil.checkIsNull(orderNumberDTO);
        orderNumberDTO.setUserAccountId(amountVO.getUserAccountId());
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();
        //用户云享金+用户佣金>总金额
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        //需要支付的总金额
        BigDecimal orderAmount = amountVO.getUpdateOrderAmount();
        String paymentType = amountVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        BigDecimal tempTotalAmount = orderAmount;
        RequirementsAmountUpdateDO amountUpdateDO = new RequirementsAmountUpdateDO(amountVO, requirementsInfoDO);
        IsNullConvertZeroUtil.checkIsNull(amountUpdateDO);
        //校验是退款还是需要继续支付
        //继续支付 需要增加冻结的任务佣金
        if (amountVO.getUpdateOrderAmount().compareTo(requirementsInfoDO.getOrderAmount()) == 1) {
            tempTotalAmount = amountVO.getUpdateOrderAmount().subtract(requirementsInfoDO.getOrderAmount());
            //
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                amountUpdateDO.setCashAmount(tempTotalAmount);
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                amountUpdateDO.setCashAmount(cashAmt);
                                //  walletFlowVO.setCashAmount(cashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                amountUpdateDO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                amountUpdateDO.setSalaryAmount(salaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            amountUpdateDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }
        }
        //修改金额小于修改前 金额，剩余资金将原路退回 ，退回顺序 微信佣金 云享金
        if (amountVO.getUpdateOrderAmount().compareTo(requirementsInfoDO.getOrderAmount()) == -1) {
            tempTotalAmount = requirementsInfoDO.getOrderAmount().subtract(amountVO.getUpdateOrderAmount());
            TreeSet<String> object = (TreeSet<String>) objects.descendingSet();
            for (String type : object) {
                switch (type) {
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (requirementsInfoDO.getWeChat().compareTo(tempTotalAmount) == 1 ||
                                    requirementsInfoDO.getWeChat().compareTo(tempTotalAmount) == 0) {
                                amountUpdateDO.setReturnWeChat(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(requirementsInfoDO.getWeChat());
                                amountUpdateDO.setReturnWeChat(requirementsInfoDO.getWeChat());
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (requirementsInfoDO.getSalaryAmount().compareTo(tempTotalAmount) == 1 ||
                                    requirementsInfoDO.getSalaryAmount().compareTo(tempTotalAmount) == 0) {
                                amountUpdateDO.setReturnSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(requirementsInfoDO.getSalaryAmount());
                                amountUpdateDO.setReturnSalaryAmount(requirementsInfoDO.getSalaryAmount());
                            }
                        }

                        break;
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (requirementsInfoDO.getCashAmount().compareTo(tempTotalAmount) == 1 ||
                                    requirementsInfoDO.getCashAmount().compareTo(tempTotalAmount) == 0) {
                                amountUpdateDO.setReturnCashAmount(tempTotalAmount);
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(requirementsInfoDO.getCashAmount());
                                amountUpdateDO.setCashAmount(requirementsInfoDO.getCashAmount());
                                //  walletFlowVO.setCashAmount(cashAmt);
                            }
                        }
                        break;
                    default:
                        break;
                }
            }
            /*//退回的钱大于微信之前支付的钱
            if (tempTotalAmount.compareTo(requirementsInfoDO.getWeChat()) == 1) {
                //退微信多少钱
                BigDecimal residueAmount = tempTotalAmount.subtract(requirementsInfoDO.getWeChat());
                //退回微信的钱
                BigDecimal returnWeChat = requirementsInfoDO.getWeChat();
                //微信不够退佣金
                if (residueAmount.compareTo(requirementsInfoDO.getCashAmount()) == 1) {
                    BigDecimal residueCash = residueAmount.subtract(requirementsInfoDO.getCashAmount());


                }
                if (residueAmount.compareTo(requirementsInfoDO.getCashAmount()) == -1
                        || residueAmount.compareTo(requirementsInfoDO.getCashAmount()) == 0) {
                    //佣金足够 退回佣金
                    BigDecimal returnCashAmount = requirementsInfoDO.getCashAmount();
                }


            }
            //微信金额大于微信退回的钱
            if (requirementsInfoDO.getWeChat().compareTo(tempTotalAmount) == 1
                    || tempTotalAmount.compareTo(requirementsInfoDO.getWeChat()) == 0) {
                BigDecimal returnWeChat = tempTotalAmount;
            }*/
        }

        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        ApplyRefundVO applyRefundVO = new ApplyRefundVO();
        //RequirementsServiceDO requirementsServiceDO = new RequirementsServiceDO();
        System.out.println(amountUpdateDO);

        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了

            if (numberDTO != null) {
                amountUpdateDO.setWechatPayOrderNumber(numberDTO.getPaymentOrderNumber());
            }
            requirementsDao.updateScene(amountVO.getRequirementsInfoId(), 8);
            requirementsDao.updateInfo(amountVO.getRequirementsInfoId(), 8);
            requirementsDao.requirementsAmountUpdate(amountUpdateDO);
            redisUtil.ins("order_" + requirementsInfoDO.getPublisherNumber(), String.valueOf(requirementsInfoDO), 1, TimeUnit.HOURS);
            return ResultBody.success();
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("修改失败");
        }

    }

    @Override
    public ResultBody<FlowDictionaryDTO> flowDictionary() {
        List<FlowDictionaryDO> flowDictionaryDOS = requirementsDao.flowDictionary();
        List<FlowDictionaryDTO> collect = flowDictionaryDOS.stream().map(FlowDictionaryDO::buildFlowDictionaryDTO).collect(Collectors.toList());
        return ResultBody.success(collect);
    }

    @Override
    public ResultBody confirmSettlement(Integer userAccountId, Integer requirementsInfoId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(requirementsInfoId, userAccountId);
        if (requirementsInfoDO == null) {
            return ResultBody.error("结算失败");
        }
        requirementsDao.updateInfo(requirementsInfoId, 5);
        requirementsDao.updateScene(requirementsInfoId, 5);
        return ResultBody.success();
    }

    @Override
    public ResultBody orderRequirements(String format) {
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.orderRequirements(format);
        IsNullConvertZeroUtil.checkIsNull(requirementsInfoDOS);
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        ApplyRefundVO applyRefundVO = new ApplyRefundVO();
        for (RequirementsInfoDO requirementsInfoDO : requirementsInfoDOS) {
            if (requirementsInfoDO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 ||
                    requirementsInfoDO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
                publisherWalletFlowVO.setModeOfPayment(200);
                publisherWalletFlowVO.setUserAccountId(requirementsInfoDO.getUserAccountId());
                publisherWalletFlowVO.setOperateUserAccountId(requirementsInfoDO.getUserAccountId());
                publisherWalletFlowVO.setSalaryAmount(requirementsInfoDO.getSalaryAmount());
                publisherWalletFlowVO.setCashAmount(requirementsInfoDO.getCashAmount());
                walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
                flyerCancel(walletFlowVO, "");
            }
            if (requirementsInfoDO.getWechatPayOrderNumber() != null
                    && requirementsInfoDO.getWeChat().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal weChat = requirementsInfoDO.getWeChat();
                BigDecimal multiply = weChat.multiply(new BigDecimal(100));
                Long longWeChat = multiply.longValue();
                applyRefundVO.setRefund(longWeChat);
                applyRefundVO.setOutTradeNo(requirementsInfoDO.getWechatPayOrderNumber());
                applyRefundVO.setReason("退发布者微信支付的任务佣金");
                feignApplyRefund(applyRefundVO, "");
            }
            requirementsDao.updateInfo(requirementsInfoDO.getId(), 7);
        }


        return ResultBody.success(requirementsInfoDOS);
    }

    @Override
    public ResultBody updateServicePublish(ServiceRequirementsEditVO requirementsEditVO, HttpServletRequest request) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.publisherCancel(requirementsEditVO.getRequirementsInfoId(), requirementsEditVO.getUserAccountId());
        RequirementsAmountDO amountDO = new RequirementsAmountDO(requirementsEditVO);
        if (requirementsEditVO.getWechatPayOrderNumber() != null) {
            UserPayInfoVO userPayInfoVO = queryUserPayInfo(requirementsEditVO.getWechatPayOrderNumber(), request);
            String tradeState = userPayInfoVO.getTradeState();
            if (!"SUCCESS".equals(tradeState)) {
                return ResultBody.error("支付失败，请重新支付");
            }
        }
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        ApplyRefundVO applyRefundVO = new ApplyRefundVO();
        IsNullConvertZeroUtil.checkIsNull(requirementsInfoDO);

        RequirementsInfoDO infoDO = new RequirementsInfoDO(requirementsEditVO);
        if (requirementsInfoDO == null) {
            return ResultBody.error("只能修改自己发布的服务需求");
        }
        Integer serviceFlowId = requirementsInfoDO.getServiceFlowId();
        if (serviceFlowId != 1) {
            return ResultBody.error("只有未抢单的信息才能被修改");
        }
        //用户钱包信息接口
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        GetOrderNumberDTO orderNumberDTO = new GetOrderNumberDTO();
        orderNumberDTO.setUserAccountId(requirementsEditVO.getUserAccountId());
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        BigDecimal orderAmount = requirementsEditVO.getOrderAmount();
        //先退款
        if (requirementsInfoDO.getCashAmount().compareTo(BigDecimal.ZERO) != 0 ||
                requirementsInfoDO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
            publisherWalletFlowVO.setModeOfPayment(200);
            publisherWalletFlowVO.setUserAccountId(requirementsInfoDO.getUserAccountId());
            publisherWalletFlowVO.setOperateUserAccountId(requirementsInfoDO.getUserAccountId());
            publisherWalletFlowVO.setSalaryAmount(requirementsInfoDO.getSalaryAmount());
            publisherWalletFlowVO.setCashAmount(requirementsInfoDO.getCashAmount());
            walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
            flyerCancel(walletFlowVO, request.getHeader("token"));
        }
        //退回微信的钱
        if (requirementsInfoDO.getWechatPayOrderNumber() != null
                && requirementsInfoDO.getWeChat().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal weChat = requirementsInfoDO.getWeChat();
            BigDecimal multiply = weChat.multiply(new BigDecimal(100));
            Long longWeChat = multiply.longValue();
            applyRefundVO.setRefund(longWeChat);
            applyRefundVO.setOutTradeNo(requirementsInfoDO.getWechatPayOrderNumber());
            applyRefundVO.setReason("退发布者微信支付的任务佣金");
            applyRefund(applyRefundVO, request.getHeader("token"));
        }

        WalletFlowVO wo = new WalletFlowVO();
        PublisherWalletFlowVO pwf = new PublisherWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(pwf);

        String paymentType = requirementsEditVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);

        //订单重新添加
        // RequirementsInfoDO infoDO = new RequirementsInfoDO(requirementsEditVO);
        BigDecimal tempTotalAmount = new BigDecimal(0);
        String json = stringRedisTemplate.opsForValue().get(requirementsEditVO.getWechatPayOrderNumber() + requirementsEditVO.getUserAccountId());
        GetOrderNumberDTO getOrderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);
        if (requirementsEditVO.getWechatPayOrderNumber() != null) {
            if (getOrderNumberDTO == null) {
                return ResultBody.error("订单支付失败");
            }
        }


        tempTotalAmount = orderAmount;
        for (String type : objects) {
            switch (type) {
                case "1":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                            amountDO.setCashAmount(tempTotalAmount);
                            // walletFlowVO.setCashAmount(tempTotalAmount);
                            pwf.setCashAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                            amountDO.setCashAmount(cashAmt);
                            pwf.setCashAmount(cashAmt);
                            //  walletFlowVO.setCashAmount(cashAmt);
                        }
                    }
                    break;
                case "2":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                            amountDO.setSalaryAmount(tempTotalAmount);
                            pwf.setSalaryAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                            amountDO.setSalaryAmount(salaryAmt);
                            pwf.setSalaryAmount(salaryAmt);
                        }
                    }

                    break;
                case "3":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        amountDO.setWeChat(tempTotalAmount);
                        tempTotalAmount = BigDecimal.ZERO;
                    }
                    break;
                default:
                    break;
            }
        }
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {

            requirementsDao.InsertRequirementsAmountLog(requirementsInfoDO);
            IndustryTypeDTO industryTypeDTO = getIndustryTypeById(requirementsEditVO.getServiceId());
            infoDO.setServiceName(industryTypeDTO.getTypeName());
            requirementsDao.updateRequirementsInfo(infoDO);
            BigDecimal add = amountDO.getOrderAmount().add(requirementsInfoDO.getOrderLevelAmount());
            amountDO.setTotalAmount(add);
            BigDecimal totalAmount = amountDO.getTotalAmount();
            requirementsDao.updateAmount(amountDO);

            if (pwf.getCashAmount().compareTo(BigDecimal.ZERO) != 0 ||
                    pwf.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
                pwf.setUserAccountId(requirementsEditVO.getUserAccountId());
                pwf.setOperateUserAccountId(requirementsEditVO.getUserAccountId());
                pwf.setModeOfPayment(100);
                pwf.setCashAmount(pwf.getCashAmount().negate());
                pwf.setSalaryAmount(pwf.getSalaryAmount().negate());
                wo.setPublisherWalletFlowVO(pwf);
                flyerCancel(wo, request.getHeader("token"));
            }

            return ResultBody.success();
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("下单失败");
        }


        /*Integer publish = requirementsDao.findPublish(requirementsInfoDO);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_MODIFY_REQUIREMENTS_PUBLISHED_BY_OTHERS);
        }*/
        //  requirementsDao.updatePublish(requirementsInfoDO);
        //return ResultBody.success();
        // return null;
    }

    @Override
    public ResultBody<FlowDictionaryAndTimeDTO> flowDictionaryAndTime(Integer requirementsInfoId) {
        FlowDictionaryAndTimeDTO flowDictionaryAndTimeDTO = new FlowDictionaryAndTimeDTO();

        ReleaseSuccessDTO releaseSuccessDTO = requirementsDao.releaseSuccessDTO(requirementsInfoId);
        flowDictionaryAndTimeDTO.setReleaseSuccess(releaseSuccessDTO);

        //抢单
        RequirementsServiceDTO requirementsServiceDTO = requirementsDao.requirementsServiceDTO(requirementsInfoId);
        flowDictionaryAndTimeDTO.setRequirementsServiceDTO(requirementsServiceDTO);
        //抵达现场
        ServiceArriveSceneDTO arriveSceneDTO = requirementsDao.serviceArriveSceneDTO(requirementsInfoId);
        flowDictionaryAndTimeDTO.setServiceArriveSceneDTO(arriveSceneDTO);
        //完成任务
        ServiceFulfilATaskDTO fulfilATaskDTO = requirementsDao.serviceFulfilATaskDTO(requirementsInfoId);
        flowDictionaryAndTimeDTO.setServiceFulfilATaskDTO(fulfilATaskDTO);
        //结算
        ServiceSettleAccountsDTO settleAccountsDTO = requirementsDao.settleAccountsDTO(requirementsInfoId);
        flowDictionaryAndTimeDTO.setServiceSettleAccountsDTO(settleAccountsDTO);
        //评价
        ServiceEvaluateDTO serviceEvaluateDTO = requirementsDao.serviceEvaluateDTO(requirementsInfoId);
        flowDictionaryAndTimeDTO.setServiceEvaluateDTO(serviceEvaluateDTO);

        RequirementsAmountUpdateDTO amountUpdateDTO = requirementsDao.amountUpdateDTO(requirementsInfoId);
        flowDictionaryAndTimeDTO.setAmountUpdate(amountUpdateDTO);

        return ResultBody.success(flowDictionaryAndTimeDTO);
    }

    @Override
    public ResultBody deletePublishService(Integer requirementsInfoId, Integer userAccountId) {
        Integer publish = requirementsDao.findPublishCount(requirementsInfoId, userAccountId);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_DELETE_REQUIREMENTS_POSTED_BY_OTHERS);
        }
        requirementsDao.deletePublishService(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody deletePreempt(Integer requirementsInfoId, Integer userAccountId) {
        Integer publish = requirementsDao.selectDeletePreempt(requirementsInfoId, userAccountId);
        if (publish == 0) {
            return ResultBody.error(ResultEnum.YOU_CANNOT_DELETE_REQUIREMENTS_POSTED_BY_OTHERS);
        }
        requirementsDao.deletePreempt(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody flyHandAgree(FlyHandAgreeVO agreeVO, HttpServletRequest request) {
        ServiceSettleAccountsVO settleAccountsVO = new ServiceSettleAccountsVO();
        settleAccountsVO.setRequirementsInfoId(agreeVO.getRequirementsInfoId());
        RequirementsInfoDO infoDO = requirementsDao.flyHandAgree(agreeVO.getRequirementsInfoId());
        RequirementsServiceDO requirementsServiceDO = requirementsDao.serviceSettleAccounts(settleAccountsVO);
        RequirementsAmountUpdateDO amountUpdateDO = requirementsDao.selectAmountUpdate(agreeVO.getRequirementsInfoId());
        IsNullConvertZeroUtil.checkIsNull(infoDO);
        IsNullConvertZeroUtil.checkIsNull(requirementsServiceDO);
        IsNullConvertZeroUtil.checkIsNull(amountUpdateDO);

        ServiceSettleAccountsDO settleAccountsDO = new ServiceSettleAccountsDO(settleAccountsVO);
        requirementsDao.settleAccounts(settleAccountsDO);
        requirementsDao.updateScene(settleAccountsVO.getRequirementsInfoId(), 5);
        requirementsDao.updateInfo(settleAccountsVO.getRequirementsInfoId(), 5);
        //正常结算
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        FlyerWalletFlowVO flyerWalletFlowVO = new FlyerWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(flyerWalletFlowVO);
        //给发布者发送
        BigDecimal orderAmount = infoDO.getUpdateOrderAmount();
        BigDecimal bigDecimal = new BigDecimal(0.9);
        BigDecimal bigDecimal1 = orderAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
        publisherWalletFlowVO.setModeOfPayment(700);
        publisherWalletFlowVO.setFlyerSalaryAmount(bigDecimal1);

        //如果修改金额小于订单金额
        if (infoDO.getOrderAmount().compareTo(infoDO.getUpdateOrderAmount()) == 1) {
            BigDecimal cashAmount = infoDO.getCashAmount().add(amountUpdateDO.getCashAmount());
            BigDecimal salaryAmount = infoDO.getSalaryAmount().add(amountUpdateDO.getSalaryAmount());
            publisherWalletFlowVO.setCashAmount(cashAmount.negate());
            publisherWalletFlowVO.setSalaryAmount(salaryAmount.negate());
            publisherWalletFlowVO.setUserAccountId(infoDO.getUserAccountId());
            publisherWalletFlowVO.setOperateUserAccountId(agreeVO.getUserAccountId());
        } else if (infoDO.getOrderAmount().compareTo(infoDO.getUpdateOrderAmount()) == -1) {
            BigDecimal cashAmount = infoDO.getCashAmount().subtract(amountUpdateDO.getReturnCashAmount());
            BigDecimal salaryAmount = infoDO.getSalaryAmount().subtract(amountUpdateDO.getReturnSalaryAmount());
            publisherWalletFlowVO.setCashAmount(cashAmount.negate());
            publisherWalletFlowVO.setSalaryAmount(salaryAmount.negate());
            publisherWalletFlowVO.setUserAccountId(settleAccountsVO.getUserAccountId());
            publisherWalletFlowVO.setOperateUserAccountId(agreeVO.getUserAccountId());
        }

        if ("TOP_ORDER".equals(infoDO.getOrderLevel())) {
            publisherWalletFlowVO.setTopYxjAmount(infoDO.getLevelCashAmount().negate());
            publisherWalletFlowVO.setTopSalaryAmount(infoDO.getLevelSalaryAmount().negate());
        } else if ("RUSH_ORDER".equals(infoDO.getOrderLevel())) {
            publisherWalletFlowVO.setUrgentYxjAmount(infoDO.getLevelCashAmount().negate());
            publisherWalletFlowVO.setUrgentSalaryAmount(infoDO.getLevelSalaryAmount().negate());
        }
        ApplyRefundVO applyRefundVO = new ApplyRefundVO();
        //推发布者微信钱
        if (amountUpdateDO.getReturnWeChat().compareTo(BigDecimal.ZERO) != 0) {
            applyRefundVO.setReason("推发布者微信金额");
            applyRefundVO.setOutTradeNo(infoDO.getWechatPayOrderNumber());
            BigDecimal weChat = amountUpdateDO.getWeChat();
            long longValueWeChat = weChat.multiply(new BigDecimal(100)).longValue();
            applyRefundVO.setRefund(longValueWeChat);
            applyRefund(applyRefundVO, request.getHeader("token"));
        }

        //退飞手钱
        flyerWalletFlowVO.setModeOfPayment(700);
        flyerWalletFlowVO.setCashAmount(requirementsServiceDO.getCashAmount());
        flyerWalletFlowVO.setSalaryAmount(requirementsServiceDO.getSalaryAmount());
        flyerWalletFlowVO.setUserAccountId(requirementsServiceDO.getPilotCertificationUserId());
        flyerWalletFlowVO.setOperateUserAccountId(settleAccountsVO.getUserAccountId());


        if (requirementsServiceDO.getWeChat().compareTo(BigDecimal.ZERO) != 0) {
            applyRefundVO.setReason("原路退回");
            applyRefundVO.setOutTradeNo(requirementsServiceDO.getWechatPayOrderNumber());
            BigDecimal weChat = requirementsServiceDO.getWeChat();
            BigDecimal decimal = new BigDecimal(100);
            long longValueWeChat = weChat.multiply(new BigDecimal(100)).longValue();
            applyRefundVO.setRefund(longValueWeChat);
            applyRefund(applyRefundVO, request.getHeader("token"));
        }
        walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
        walletFlowVO.setFlyerWalletFlowVO(flyerWalletFlowVO);
        flyerCancel(walletFlowVO, request.getHeader("token"));
        return ResultBody.success();
    }


    @Override
    public ResultBody publishService(ServiceRequirementsVO serviceRequirementsVO, HttpServletRequest request) {

        //获取用户基本信息
        UserAccountSimpleDTO userAccountSimpleDTO = feignGetUserSimpleInfo(serviceRequirementsVO.getUserAccountId(), request);
        String openid = userAccountSimpleDTO.getOpenid();
        //需要冻结的金额
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        // PublisherWalletFlowVO publisherWalletFlowVO = walletFlowVO.getPublisherWalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        publisherWalletFlowVO.setUserAccountId(serviceRequirementsVO.getUserAccountId());
        publisherWalletFlowVO.setOperateUserAccountId(serviceRequirementsVO.getUserAccountId());
        ServiceRequirementsDO requirementsInfoDO = new ServiceRequirementsDO(serviceRequirementsVO);
        requirementsInfoDO.setPublisherNumber(randomOrderCode());
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(requirementsInfoDO);

        //获取用户钱包
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();

        //需要支付的总金额
        BigDecimal orderAmount = requirementsInfoDO.getOrderAmount();
        //需要支付加急或者置顶金额
        BigDecimal rushAndTop = OrderLevelEnum.match(serviceRequirementsVO.getOrderLevelEnum().getKey()).getValue();
        String orderLevelEnum = OrderLevelEnum.match(serviceRequirementsVO.getOrderLevelEnum().getKey()).getKey();


        //云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();

        String json = stringRedisTemplate.opsForValue().get(requirementsInfoDO.getWechatPayOrderNumber() + requirementsInfoDO.getUserAccountId());
        GetOrderNumberDTO orderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);

        String paymentType = requirementsInfoDO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);

        //用户剩余的佣金
        BigDecimal userSalaryAmt = new BigDecimal(0);
        //云享金余额还剩余多少
        BigDecimal userCashAmt = new BigDecimal(0);
        BigDecimal tempTotalAmount = new BigDecimal(0);
        //存在置顶或加急
        if (rushAndTop.compareTo(BigDecimal.ZERO) != 0) {
            tempTotalAmount = rushAndTop;
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                //加急云享金支付
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentYxjAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelCashAmount(tempTotalAmount);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    if (rushAndTop.compareTo(cashAmt) == 1) {
                                        publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                        requirementsInfoDO.setLevelCashAmount(tempTotalAmount);
                                    } else if (rushAndTop.compareTo(cashAmt) == -1) {
                                        // userCashAmt = cashAmt.subtract(rushAndTop);
                                        publisherWalletFlowVO.setTopYxjAmount(rushAndTop);
                                        requirementsInfoDO.setLevelCashAmount(rushAndTop);
                                    }
                                    // publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                    // requirementsInfoDO.setLevelCashAmount(tempTotalAmount);
                                }
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                // walletFlowVO.setCashAmount(cashAmt);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentYxjAmount(cashAmt);
                                    requirementsInfoDO.setLevelCashAmount(cashAmt);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    System.out.println(cashAmt);

                                    //publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                    //requirementsInfoDO.setLevelCashAmount(cashAmt);
                                    if (rushAndTop.compareTo(cashAmt) == 1) {
                                        publisherWalletFlowVO.setTopYxjAmount(cashAmt);
                                        requirementsInfoDO.setLevelCashAmount(cashAmt);
                                    } else if (rushAndTop.compareTo(cashAmt) == -1) {
                                        // userCashAmt = cashAmt.subtract(rushAndTop);
                                        publisherWalletFlowVO.setTopYxjAmount(rushAndTop);
                                        requirementsInfoDO.setLevelCashAmount(rushAndTop);
                                    }
                                }
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                //  walletFlowVO.setSalaryAmount(tempTotalAmount);
                                publisherWalletFlowVO.setTopSalaryAmount(tempTotalAmount);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentSalaryAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelSalaryAmount(tempTotalAmount);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopSalaryAmount(tempTotalAmount);
                                    requirementsInfoDO.setLevelSalaryAmount(tempTotalAmount);
                                }
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                // walletFlowVO.setSalaryAmount(salaryAmt);
                                publisherWalletFlowVO.setTopSalaryAmount(salaryAmt);
                                requirementsInfoDO.setLevelSalaryAmount(salaryAmt);
                                if (orderLevelEnum.equals("RUSH_ORDER")) {
                                    publisherWalletFlowVO.setUrgentSalaryAmount(salaryAmt);
                                } else if (orderLevelEnum.equals("TOP_ORDER")) {
                                    publisherWalletFlowVO.setTopSalaryAmount(salaryAmt);
                                    requirementsInfoDO.setLevelSalaryAmount(salaryAmt);
                                }
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            //需要支付微信
                            requirementsInfoDO.setLevelWeChatAmount(tempTotalAmount);
                            // walletFlowVO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }

            System.out.println(requirementsInfoDO);
            System.out.println(publisherWalletFlowVO);

            if (orderLevelEnum.equals("RUSH_ORDER")) {
                //加急的云享金
                BigDecimal urgentYxjAmount = publisherWalletFlowVO.getUrgentYxjAmount();
                userCashAmt = cashAmt.subtract(urgentYxjAmount);
                BigDecimal urgentSalaryAmount = publisherWalletFlowVO.getUrgentSalaryAmount();
                userSalaryAmt = salaryAmt.subtract(urgentSalaryAmount);

            } else if (orderLevelEnum.equals("TOP_ORDER")) {
                //置顶的云享金
                BigDecimal topYxjAmount = publisherWalletFlowVO.getTopYxjAmount();
                userCashAmt = cashAmt.subtract(topYxjAmount);
                BigDecimal topSalaryAmount = publisherWalletFlowVO.getTopSalaryAmount();
                userSalaryAmt = salaryAmt.subtract(topSalaryAmount);
            }


            tempTotalAmount = orderAmount;
            //剩下的用于支付任务佣金
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (userCashAmt.compareTo(tempTotalAmount) == 1 || userCashAmt.compareTo(tempTotalAmount) == 0) {
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                publisherWalletFlowVO.setCashAmount(tempTotalAmount);
                                requirementsInfoDO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(userCashAmt);
                                publisherWalletFlowVO.setCashAmount(userCashAmt);
                                requirementsInfoDO.setCashAmount(userCashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (userSalaryAmt.compareTo(tempTotalAmount) == 1 || userSalaryAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setSalaryAmount(tempTotalAmount);
                                requirementsInfoDO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(userSalaryAmt);
                                publisherWalletFlowVO.setSalaryAmount(userSalaryAmt);
                                requirementsInfoDO.setSalaryAmount(userSalaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            // publisherWalletFlowVO.setWeChat(tempTotalAmount);
                            requirementsInfoDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }


        }

        System.out.println(requirementsInfoDO);
        System.out.println(publisherWalletFlowVO);


        //不存在加急或者置顶
        if (rushAndTop.compareTo(BigDecimal.ZERO) == 0) {
            tempTotalAmount = orderAmount;
            for (String type : objects) {
                switch (type) {
                    case "1":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setCashAmount(tempTotalAmount);
                                requirementsInfoDO.setCashAmount(tempTotalAmount);
                                // walletFlowVO.setCashAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                                publisherWalletFlowVO.setCashAmount(cashAmt);
                                requirementsInfoDO.setCashAmount(cashAmt);
                                //  walletFlowVO.setCashAmount(cashAmt);
                            }
                        }
                        break;
                    case "2":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                                publisherWalletFlowVO.setSalaryAmount(tempTotalAmount);
                                requirementsInfoDO.setSalaryAmount(tempTotalAmount);
                                tempTotalAmount = BigDecimal.ZERO;
                            } else {
                                tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                                publisherWalletFlowVO.setSalaryAmount(salaryAmt);
                                requirementsInfoDO.setSalaryAmount(salaryAmt);
                            }
                        }

                        break;
                    case "3":
                        if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                            requirementsInfoDO.setWeChat(tempTotalAmount);
                            //  requirementsInfoDO.setWeChat(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        }
                        break;
                    default:
                        break;
                }
            }
        }

        System.out.println(requirementsInfoDO);
        System.out.println(publisherWalletFlowVO);
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            System.out.println(requirementsInfoDO);
            System.out.println(publisherWalletFlowVO);
            System.out.println(requirementsInfoDO);
            if (orderNumberDTO != null) {
                requirementsInfoDO.setWechatPayOrderNumber(orderNumberDTO.getPaymentOrderNumber());
            } else if (orderNumberDTO == null) {
                requirementsInfoDO.setWechatPayOrderNumber(null);
            }
            if (orderNumberDTO != null) {
                BigDecimal weChatPay = orderNumberDTO.getWeChatPay();
                if (requirementsInfoDO.getWechatPayOrderNumber().equals(orderNumberDTO.getPaymentOrderNumber())) {
                    BigDecimal weChat = requirementsInfoDO.getWeChat();
                    BigDecimal levelWeChatAmount = requirementsInfoDO.getLevelWeChatAmount();
                    BigDecimal add = weChat.add(levelWeChatAmount);
                    if (weChatPay.compareTo(add) != 0) {
                        return ResultBody.error("订单号错误下单失败");
                    }
                }
            }
            IndustryTypeDTO industryTypeDTO = getIndustryTypeById(requirementsInfoDO.getServiceId());
            requirementsInfoDO.setServiceName(industryTypeDTO.getTypeName());
            requirementsInfoDO.setOpenid(openid);
            requirementsDao.addPublishService(requirementsInfoDO);
            RequirementsAmountDO requirementsAmountDO = new RequirementsAmountDO(requirementsInfoDO);
            requirementsDao.addAmount(requirementsAmountDO);
            requirementsDao.insertPlatformOrderEarnings(new BigDecimal(0), requirementsInfoDO.getId(), 0);
            if (requirementsAmountDO.getCashAmount().compareTo(BigDecimal.ZERO) != 0
                    || requirementsAmountDO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0
                    || requirementsAmountDO.getLevelCashAmount().compareTo(BigDecimal.ZERO) != 0
                    || requirementsAmountDO.getLevelSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
                feignWalletFlow(publisherWalletFlowVO, request.getHeader("token"));
            }
            return ResultBody.success();
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("下单失败");
        }
    }


    /**
     * 获取用户钱包信息
     *
     * @param
     * @param request
     * @return
     */
    public ResultBody getCurrentUserPayWalletInfo(HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<MultiValueMap<String, Object>> formEntity = new HttpEntity<MultiValueMap<String, Object>>(headers);
        ResponseEntity<String> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/getCurrentUserPayWalletInfo", HttpMethod.GET, formEntity, String.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        Object body = exchange.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String) body);
        JSONObject result1 = (JSONObject) jsonObject.get("result");
        PayWalletDTO payWalletDTO = JSON.parseObject(result1.toJSONString(), PayWalletDTO.class);
        return ResultBody.success(payWalletDTO);
    }


    @Override
    public PageResult myPublish(Integer userAccountId, MyPublishQO param) {
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        param.setUserAccountId(userAccountId);
        int count = requirementsDao.myPublishcount(param);
        List<RequirementsInfoDO> requirementsInfoDOS = requirementsDao.myPublish(param);
        List<RequirementsInfoVO> collect = requirementsInfoDOS.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        List<IndustryTypeDTO> industryTypeDTOS = listIndustry();
        for (RequirementsInfoVO requirementsInfoVO : collect) {
            for (IndustryTypeDTO industryTypeDTO : industryTypeDTOS) {
                if (requirementsInfoVO.getServiceId() != null && requirementsInfoVO.getServiceId().equals(industryTypeDTO.getId())) {
                    requirementsInfoVO.setServiceName(industryTypeDTO.getTypeName());
                }
            }
        }
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);

    }


    @Override
    public ResultBody grabTheOrder(GrabTheOrderVO grabTheOrderVO, HttpServletRequest request) {


        UserAccountSimpleDTO userAccountSimpleDTO = feignGetUserSimpleInfo(grabTheOrderVO.getUserAccountId(), request);
        String openid = userAccountSimpleDTO.getOpenid();

        ServiceRequirementsDO requirementsInfoDO = requirementsDao.grabTheOrder(grabTheOrderVO.getRequirementsInfoId());
        if (grabTheOrderVO.getRequirementsInfoId().equals(requirementsInfoDO.getId()) && grabTheOrderVO.getUserAccountId().equals(requirementsInfoDO.getUserAccountId())) {
            return ResultBody.error("自己不能抢自己发布的需求");
        }
        //飞手
        PilotCertificationInteriorDTO pilot = feignInteriorDetailPilot(grabTheOrderVO.getUserAccountId(), request);
        if (pilot == null) {
            return ResultBody.error("只能飞手或者飞手团队抢单");
        }

        Integer repertory = requirementsInfoDO.getRepertory();
        if (repertory <= 0) {
            return ResultBody.error("需求已被其他人抢走");
        }

        //  requirementsInfoDO.setPublisherNumber(randomOrderCode());
        ResultBody resultBody = getCurrentUserPayWalletInfo(request);
        PayWalletDTO payWalletDTO = (PayWalletDTO) resultBody.getResult();
        RequirementsServiceDO requirementsServiceDO = new RequirementsServiceDO(pilot, requirementsInfoDO);
        IsNullConvertZeroUtil.checkIsNull(requirementsServiceDO);

        //用户云享金+用户佣金>总金额
        //剩余后台云享金
        BigDecimal cashAmt = payWalletDTO.getCashAmt();
        //剩余佣金
        BigDecimal salaryAmt = payWalletDTO.getSalaryAmt();
        //用户云享金加上佣金的总金额
        BigDecimal cashAndSalary = cashAmt.add(salaryAmt);
        //需要支付的总金额(任务佣金)
        BigDecimal totalAmount = requirementsInfoDO.getOrderAmount();
        BigDecimal bigDecimal = new BigDecimal(0.3);
        totalAmount = totalAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
        String json = stringRedisTemplate.opsForValue().get(grabTheOrderVO.getWechatPayOrderNumber() + grabTheOrderVO.getUserAccountId());
        GetOrderNumberDTO orderNumberDTO = JSONObject.parseObject(json, GetOrderNumberDTO.class);
        IsNullConvertZeroUtil.checkIsNull(orderNumberDTO);
        //需要冻结的金额
        FlyerWalletFlowVO flyerWalletFlowVO = new FlyerWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(flyerWalletFlowVO);
        //PublisherWalletFlowVO publisherWalletFlowVO = walletFlowVO.getPublisherWalletFlowVO();
        BigDecimal tempTotalAmount = totalAmount;
        String paymentType = grabTheOrderVO.getPaymentType();
        String[] split = paymentType.split(",");
        Set<String> collect = Arrays.asList(split).stream().collect(Collectors.toSet());
        TreeSet<String> objects = new TreeSet<>(collect);
        for (String type : objects) {
            switch (type) {
                case "1":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (cashAmt.compareTo(tempTotalAmount) == 1 || cashAmt.compareTo(tempTotalAmount) == 0) {
                            flyerWalletFlowVO.setCashAmount(tempTotalAmount);
                            requirementsServiceDO.setCashAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(cashAmt);
                            flyerWalletFlowVO.setCashAmount(cashAmt);
                            requirementsServiceDO.setCashAmount(cashAmt);
                        }
                    }
                    break;
                case "2":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        if (salaryAmt.compareTo(tempTotalAmount) == 1 || salaryAmt.compareTo(tempTotalAmount) == 0) {
                            flyerWalletFlowVO.setSalaryAmount(tempTotalAmount);
                            requirementsServiceDO.setSalaryAmount(tempTotalAmount);
                            tempTotalAmount = BigDecimal.ZERO;
                        } else {
                            tempTotalAmount = tempTotalAmount.subtract(salaryAmt);
                            flyerWalletFlowVO.setSalaryAmount(salaryAmt);
                            requirementsServiceDO.setSalaryAmount(salaryAmt);
                        }
                    }
                    break;
                case "3":
                    if (!(tempTotalAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        //  publisherWalletFlowVO.setWeChat(tempTotalAmount);
                        requirementsServiceDO.setWeChat(tempTotalAmount);
                        tempTotalAmount = BigDecimal.ZERO;
                    }
                    break;
                default:
                    break;
            }
        }
        if (tempTotalAmount.compareTo(BigDecimal.ZERO) == 0) {
            //表示订单计算完成，需要支付的钱都算出来了
            // System.out.println(flyerWalletFlowVO);
            // System.out.println(requirementsServiceDO);

            flyerWalletFlowVO.setUserAccountId(grabTheOrderVO.getUserAccountId());
            flyerWalletFlowVO.setOperateUserAccountId(grabTheOrderVO.getUserAccountId());
            // requirementsServiceDO.setCashAmount(walletFlowVO.getCashAmount());
            // requirementsServiceDO.setSalaryAmount(walletFlowVO.getSalaryAmount());
            if (orderNumberDTO != null) {
                requirementsServiceDO.setWeChat(orderNumberDTO.getWeChatPay());
                requirementsServiceDO.setWechatPayOrderNumber(orderNumberDTO.getPaymentOrderNumber());
            }
            // BigDecimal cashAndSalaryAmount = walletFlowVO.getCashAmount().add(walletFlowVO.getSalaryAmount());
            // BigDecimal preemptTotalAmount = cashAndSalaryAmount.add(orderNumberDTO.getWeChatPay());
            //  requirementsServiceDO.setPreemptTotalAmount(preemptTotalAmount);
            BigDecimal cashAmount = requirementsServiceDO.getCashAmount();
            BigDecimal salaryAmount = requirementsServiceDO.getSalaryAmount();
            BigDecimal weChat = requirementsServiceDO.getWeChat();
            BigDecimal add = cashAmount.add(salaryAmount);
            BigDecimal add1 = add.add(weChat);
            requirementsServiceDO.setPreemptTotalAmount(add1);
            requirementsServiceDO.setOpenid(openid);
            requirementsServiceDO.setPhoneNum(grabTheOrderVO.getPhoneNum());
            //微信是否支付成功

            requirementsDao.insertService(requirementsServiceDO);
            requirementsInfoDO.setRepertory(repertory - 1);
            requirementsDao.updateGrabTheOrder(grabTheOrderVO.getRequirementsInfoId(), requirementsInfoDO.getRepertory());
            if (requirementsServiceDO.getCashAmount().compareTo(BigDecimal.ZERO) != 0
                    || requirementsServiceDO.getSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
                walletFlow(flyerWalletFlowVO, request.getHeader("token"));
            }

            return ResultBody.success();
        } else {
            //云享金和佣金扣除完成，但是还不足支付订单金额，并且没有选择微信支付，所以支付不合法
            return ResultBody.success("抢单失败");
        }
    }


    @Override
    public ResultBody arriveAtTheScene(ServiceArriveSceneVO serviceArriveSceneVO) {
        ServiceArriveSceneDO serviceArriveSceneDO = new ServiceArriveSceneDO(serviceArriveSceneVO);
        RequirementsInfoDO requirementsInfoDO = requirementsDao.detailPublish(serviceArriveSceneDO.getRequirementsInfoId());
        GlobalCoordinates source = new GlobalCoordinates(Double.parseDouble(String.valueOf(requirementsInfoDO.getLatitude())), Double.parseDouble(String.valueOf(requirementsInfoDO.getLongitude())));
        GlobalCoordinates target = new GlobalCoordinates(Double.parseDouble(String.valueOf(serviceArriveSceneDO.getLatitude())), Double.parseDouble(String.valueOf(serviceArriveSceneDO.getLongitude())));
        double geoCurve = getDistanceMeter(source, target, Ellipsoid.Sphere);
        //100米
        if (geoCurve > 100) {
            return ResultBody.error(ResultEnum.FALL_OUTSIDE_OF);
        } else {
            requirementsDao.arriveAtTheScene(serviceArriveSceneDO);
            requirementsDao.updateScene(serviceArriveSceneDO.getRequirementsInfoId(), 3);
            requirementsDao.updateInfo(serviceArriveSceneDO.getRequirementsInfoId(), 3);
        }
        return ResultBody.success();
    }

    /* 经纬度计算工具类*/
    public static double getDistanceMeter(GlobalCoordinates gpsFrom, GlobalCoordinates gpsTo, Ellipsoid ellipsoid) {
        //创建GeodeticCalculator，调用计算方法，传入坐标系、经纬度用于计算距离
        GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(ellipsoid, gpsFrom, gpsTo);
        return geoCurve.getEllipsoidalDistance();
    }

    @Override
    public ResultBody<ServiceArriveSceneDTO> arriveAtTheSceneDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceArriveSceneDO serviceArriveSceneDO = requirementsDao.arriveAtTheSceneDetails(requirementsInfoId, userAccountId);
        ServiceArriveSceneDTO serviceArriveSceneDTO = serviceArriveSceneDO.buildServiceArriveSceneDTO();
        return ResultBody.success(serviceArriveSceneDTO);
    }


    @Override
    public ResultBody fulfilATask(ServiceFulfilATaskVO fulfilATaskVO) {
        ServiceFulfilATaskDO serviceFulfilATaskDO = new ServiceFulfilATaskDO(fulfilATaskVO);
        requirementsDao.fulfilATask(serviceFulfilATaskDO);
        requirementsDao.updateInfo(fulfilATaskVO.getRequirementsInfoId(), 4);
        requirementsDao.updateScene(fulfilATaskVO.getRequirementsInfoId(), 4);
        return ResultBody.success();
    }

    @Override
    public ResultBody<ServiceFulfilATaskDTO> fulfilATaskDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceFulfilATaskDO serviceFulfilATaskDO = requirementsDao.fulfilATaskDetails(requirementsInfoId, userAccountId);
        ServiceFulfilATaskDTO serviceFulfilATaskDTO = serviceFulfilATaskDO.buildServiceFulfilATaskDTO();
        return ResultBody.success(serviceFulfilATaskDTO);
    }


    @Override
    public ResultBody settleAccounts(ServiceSettleAccountsVO settleAccountsVO, HttpServletRequest request) {

        RequirementsInfoDO infoDO = requirementsDao.selectSettleAccounts(settleAccountsVO);
        RequirementsServiceDO requirementsServiceDO = requirementsDao.serviceSettleAccounts(settleAccountsVO);
        IsNullConvertZeroUtil.checkIsNull(infoDO);
        IsNullConvertZeroUtil.checkIsNull(requirementsServiceDO);

        ServiceSettleAccountsDO settleAccountsDO = new ServiceSettleAccountsDO(settleAccountsVO);
        requirementsDao.settleAccounts(settleAccountsDO);
        requirementsDao.updateScene(settleAccountsVO.getRequirementsInfoId(), 5);
        requirementsDao.updateInfo(settleAccountsVO.getRequirementsInfoId(), 5);
        //正常结算
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        PublisherWalletFlowVO publisherWalletFlowVO = new PublisherWalletFlowVO();
        FlyerWalletFlowVO flyerWalletFlowVO = new FlyerWalletFlowVO();
        IsNullConvertZeroUtil.checkIsNull(publisherWalletFlowVO);
        IsNullConvertZeroUtil.checkIsNull(flyerWalletFlowVO);

        //给发布者发送
        BigDecimal orderAmount = infoDO.getOrderAmount();
        BigDecimal bigDecimal = new BigDecimal(0.9);
        BigDecimal bigDecimal1 = orderAmount.multiply(bigDecimal).setScale(2, BigDecimal.ROUND_HALF_UP);
        publisherWalletFlowVO.setModeOfPayment(700);
        publisherWalletFlowVO.setFlyerSalaryAmount(bigDecimal1);
        BigDecimal bigDecimal2 = orderAmount.multiply(new BigDecimal(0.1)).setScale(2, BigDecimal.ROUND_HALF_UP);

        publisherWalletFlowVO.setCashAmount(infoDO.getCashAmount().negate());
        publisherWalletFlowVO.setSalaryAmount(infoDO.getSalaryAmount().negate());
        publisherWalletFlowVO.setUserAccountId(settleAccountsVO.getUserAccountId());
        publisherWalletFlowVO.setOperateUserAccountId(settleAccountsVO.getUserAccountId());

        if ("TOP_ORDER".equals(infoDO.getOrderLevel())) {
            publisherWalletFlowVO.setTopYxjAmount(infoDO.getLevelCashAmount().negate());
            publisherWalletFlowVO.setTopSalaryAmount(infoDO.getLevelSalaryAmount().negate());
        } else if ("RUSH_ORDER".equals(infoDO.getOrderLevel())) {
            publisherWalletFlowVO.setUrgentYxjAmount(infoDO.getLevelCashAmount().negate());
            publisherWalletFlowVO.setUrgentSalaryAmount(infoDO.getLevelSalaryAmount().negate());
        }

        //退飞手钱
        flyerWalletFlowVO.setModeOfPayment(700);
        flyerWalletFlowVO.setCashAmount(requirementsServiceDO.getCashAmount());
        flyerWalletFlowVO.setSalaryAmount(requirementsServiceDO.getSalaryAmount());
        flyerWalletFlowVO.setUserAccountId(requirementsServiceDO.getPilotCertificationUserId());
        flyerWalletFlowVO.setOperateUserAccountId(settleAccountsVO.getUserAccountId());


        ApplyRefundVO applyRefundVO = new ApplyRefundVO();
        if (requirementsServiceDO.getWeChat().compareTo(BigDecimal.ZERO) != 0) {
            applyRefundVO.setReason("原路退回");
            applyRefundVO.setOutTradeNo(requirementsServiceDO.getWechatPayOrderNumber());
            BigDecimal weChat = requirementsServiceDO.getWeChat();
            BigDecimal decimal = new BigDecimal(100);
            long longValueWeChat = weChat.multiply(new BigDecimal(100)).longValue();
            applyRefundVO.setRefund(longValueWeChat);
            applyRefund(applyRefundVO, request.getHeader("token"));
        }
        requirementsDao.updatePlatformorderAmount(bigDecimal2, infoDO.getId());
        BigDecimal orderEarnings = infoDO.getOrderEarnings();
        BigDecimal orderAmounts = bigDecimal2.add(orderEarnings);
        requirementsDao.updateOrderEarnings(orderAmounts, infoDO.getId());
        walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
        walletFlowVO.setFlyerWalletFlowVO(flyerWalletFlowVO);
        flyerCancel(walletFlowVO, request.getHeader("token"));
        return ResultBody.success();
    }

    @Override
    public ResultBody<ServiceSettleAccountsDTO> settleAccountsDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceSettleAccountsDO settleAccountsDO = requirementsDao.settleAccountsDetails(requirementsInfoId, userAccountId);
        ServiceSettleAccountsDTO settleAccountsDTO = settleAccountsDO.buildServiceSettleAccountsDTO();
        return ResultBody.success(settleAccountsDTO);
    }

    @Override
    public ResultBody evaluate(ServiceEvaluateVO evaluateVO) {
        ServiceEvaluateDO serviceEvaluateDO = new ServiceEvaluateDO(evaluateVO);
        requirementsDao.evaluate(serviceEvaluateDO);
        requirementsDao.updateInfo(evaluateVO.getRequirementsInfoId(), 6);
        requirementsDao.updateScene(evaluateVO.getRequirementsInfoId(), 6);
        return ResultBody.success();
    }

    @Override
    public ResultBody evaluateDetails(Integer requirementsInfoId, Integer userAccountId) {
        ServiceEvaluateDO serviceEvaluateDO = requirementsDao.evaluateDetails(requirementsInfoId, userAccountId);
        ServiceEvaluateDTO serviceEvaluateDTO = serviceEvaluateDO.buildServiceEvaluateDTO();
        return ResultBody.success(serviceEvaluateDTO);
    }


    public UserAccountSimpleDTO feignGetUserSimpleInfo(Integer userAccountId, HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(userAccountId), headers);
        ResponseEntity<UserAccountSimpleDTO> exchange1 = restTemplate.exchange(userApp + "/userapp/user-account/feignGetUserSimpleInfo?userAccountId=" + userAccountId, HttpMethod.GET, entity, UserAccountSimpleDTO.class);
        UserAccountSimpleDTO body = exchange1.getBody();
        return body;
    }


    public PilotCertificationInteriorDTO feignInteriorDetailPilot(Integer userAccountId, HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(userAccountId), headers);
        ResponseEntity<PilotCertificationInteriorDTO> exchange1 = restTemplate.exchange(userApp + "/userapp/pilot/interiorDetailPilot?userAccountId=" + userAccountId, HttpMethod.GET, entity, PilotCertificationInteriorDTO.class);
        PilotCertificationInteriorDTO body = exchange1.getBody();
        return body;
    }


    /**
     * 不带token 退款
     */
    public ResultBody feignApplyRefund(ApplyRefundVO applyRefundVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(applyRefundVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(paymentApp + "/payment/wechat/applyRefund", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }


    /**
     * 退款
     */
    public ResultBody applyRefund(ApplyRefundVO applyRefundVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(applyRefundVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(paymentApp + "/payment/wechat/applyRefund", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }


    /**
     * 公共调用
     *
     * @param walletFlowVO
     * @param token
     * @return
     */
    public ResultBody flyerCancel(WalletFlowVO walletFlowVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(walletFlowVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/feignWalletFlow", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }

    public ResultBody walletFlow(FlyerWalletFlowVO flyerWalletFlowVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        flyerWalletFlowVO.setModeOfPayment(400);
        flyerWalletFlowVO.setCashAmount(flyerWalletFlowVO.getCashAmount().negate());
        flyerWalletFlowVO.setSalaryAmount(flyerWalletFlowVO.getSalaryAmount().negate());
        walletFlowVO.setFlyerWalletFlowVO(flyerWalletFlowVO);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(walletFlowVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/feignWalletFlow", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }

    public ResultBody feignWalletFlow(PublisherWalletFlowVO publisherWalletFlowVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        WalletFlowVO walletFlowVO = new WalletFlowVO();
        publisherWalletFlowVO.setModeOfPayment(100);
        publisherWalletFlowVO.setCashAmount(publisherWalletFlowVO.getCashAmount().negate());
        publisherWalletFlowVO.setSalaryAmount(publisherWalletFlowVO.getSalaryAmount().negate());
        publisherWalletFlowVO.setUrgentYxjAmount(publisherWalletFlowVO.getUrgentYxjAmount().negate());
        publisherWalletFlowVO.setUrgentSalaryAmount(publisherWalletFlowVO.getUrgentSalaryAmount().negate());
        publisherWalletFlowVO.setTopYxjAmount(publisherWalletFlowVO.getTopYxjAmount().negate());
        publisherWalletFlowVO.setTopSalaryAmount(publisherWalletFlowVO.getTopSalaryAmount().negate());
        walletFlowVO.setPublisherWalletFlowVO(publisherWalletFlowVO);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(walletFlowVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(userApp + "/userapp/pay/feignWalletFlow", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }

    public ResultBody releaseOrder(RequirementsInfoVO requirementsInfoVO, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(requirementsInfoVO), headers);
        ResponseEntity<Object> exchange = null;
        try {
            exchange = restTemplate.exchange(omsApp + "releaseOrder/publish", HttpMethod.POST, entity, Object.class);
        } catch (RestClientException e) {
            return ResultBody.error(ResultEnum.THE_THIRD_PARTY_INTERFACE_IS_BEING_UPDATED);
        }
        return ResultBody.success();
    }


    public List<IndustryTypeDTO> listIndustry() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<List> exchange = restTemplate.exchange(pmsApp + "/pms/industry/listIndustry", HttpMethod.GET, entity, List.class);
        List<IndustryTypeDTO> body = (List<IndustryTypeDTO>) exchange.getBody();
        String s = JSON.toJSONString(body);
        List<IndustryTypeDTO> industryTypeDTOS = JSONObject.parseArray(s, IndustryTypeDTO.class);
        ArrayList<IndustryTypeDTO> list = new ArrayList<>();
        for (IndustryTypeDTO industryTypeDTO : industryTypeDTOS) {
            list.add(industryTypeDTO);
        }
        return list;
    }

    /*    String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(userAccountId), headers);
        ResponseEntity<PilotCertificationInteriorDTO> exchange1 = restTemplate.exchange(userApp + "/userapp/pilot/interiorDetailPilot?userAccountId=" + userAccountId, HttpMethod.GET, entity, PilotCertificationInteriorDTO.class);
        PilotCertificationInteriorDTO body = exchange1.getBody();*/

    /**
     * 通过订单编号查看是否支付成功
     *
     * @param orderNo
     * @return
     */
    public UserPayInfoVO queryUserPayInfo(String orderNo, HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(orderNo), headers);
        ResponseEntity<Object> exchange = restTemplate.exchange(paymentApp + "/payment/wechat/queryUserPayInfo?orderNo=" + orderNo, HttpMethod.GET, entity, Object.class);
        Object body = exchange.getBody();
        String s = JSONObject.toJSONString(body);
        UserPayInfoVO userPayInfoVO = JSONObject.parseObject(s, UserPayInfoVO.class);
        System.out.println(userPayInfoVO);
        //   UserPayInfoVO body = exchange.getBody();
        return userPayInfoVO;
    }

    /**
     * 删除抢单未支付的金额
     *
     * @param requirementsInfoId
     * @param request
     * @return
     */
    public ResultBody getDelete(Integer requirementsInfoId, HttpServletRequest request) {
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(JSONObject.toJSONString(requirementsInfoId), headers);
        ResponseEntity<ResultBody> exchange = restTemplate.exchange(omsApp + "releaseOrder/getDelete?requirementsInfoId=" + requirementsInfoId, HttpMethod.GET, entity, ResultBody.class);
        //UserPayInfoVO body = exchange.getBody();
        ResultBody body = exchange.getBody();
        return body;
    }


    public IndustryTypeDTO getIndustryTypeById(Integer serviceId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<String> exchange = restTemplate.exchange(pmsApp + "/pms/industry/getIndustryTypeById?id=+" + serviceId, HttpMethod.GET, entity, String.class);
        String body = exchange.getBody();
        IndustryTypeDTO industryTypeDTO = JSONObject.parseObject(body, IndustryTypeDTO.class);
        return industryTypeDTO;
    }


    public String randomOrderCode() {
        SimpleDateFormat dmDate = new SimpleDateFormat("yyyyMMddHHmmss");
        String ranData = getRandom(6);
        Date date = new Date();
        String dateRan = dmDate.format(date);
        String xsCode = "R" + dateRan + ranData;
        if (xsCode.length() < 24) {
            xsCode = xsCode + 0;
        }
        return xsCode;
    }

    public String getRandom(int len) {
        Random r = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < len; i++) {
            rs.append(r.nextInt(10));
        }
        return rs.toString();
    }


}
