package com.mmc.csf.release.service;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.flyer.qo.CurriculumQo;
import com.mmc.csf.release.flyer.vo.RegistrationVO;

/**
 * @Author LW
 * @date 2023/5/15 10:12
 * 概要：
 */
public interface FlyerTrainingService {
    /**
     * 飞手报名
     *
     * @param registrationVO 注册信息
     * @return {@link ResultBody}
     */
    ResultBody pilotRegistration(RegistrationVO registrationVO);

    /**
     * 获取无人机飞行员执照
     *
     * @return {@link ResultBody}
     */
    ResultBody getDronePilotLicense();

    /**
     * 获取行业飞行技能
     *
     * @return {@link ResultBody}
     */
    ResultBody getIndustryFlightSkills();

    /**
     * 查询任务服务列表
     *
     * @param taskServiceQo 任务服务问:
     * @return {@link Object}
     */
    PageResult queryCurriculumInfoList(CurriculumQo taskServiceQo);

    /**
     * 许可证或技能查询课程
     *
     * @param type 类型
     * @return {@link ResultBody}
     */
    ResultBody licenseOrSkillQueryCurriculum(Integer type);

    ResultBody curriculumDetails(Integer id);
}
