package com.mmc.csf.infomation.qo;

import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/19 13:44
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IndustryCaseQO implements Serializable {

    private static final long serialVersionUID = -4615177472593013257L;
    @ApiModelProperty(value = "关键字", required = false, hidden = true)
    private String keyword;

    @ApiModelProperty(value = "省份编码", required = false)
    private Integer provinceCode;

    @ApiModelProperty(value = "市编码", required = false)
    private Integer cityCode;

    @ApiModelProperty(value = "区编码", required = false)
    private Integer districtCode;

    @ApiModelProperty(value = "时间：2023-05-19", required = false)
    private String date;

    @ApiModelProperty(value = "用户id集合", hidden = true)
    private List<Integer> userIds;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
