package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.RequirementsInfoVO;
import com.mmc.csf.infomation.vo.RequirementsTypeVO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.entity.requirements.RequirementsInfoDO;
import com.mmc.csf.release.entity.requirements.RequirementsTypeDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.service.RequirementsService;
import com.mmc.csf.release.util.RestTemplateUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/5/18 14:29
 */
@Slf4j
@Service
public class RequirementsServiceImpl implements RequirementsService {
    @Autowired
    private RequirementsDao requirementsDao;

    @Autowired
    private UserAppApi userAppApi;

    @Autowired
    private RestTemplateUtil restTemplateUtil;

    @Override
    public ResultBody listType() {
        List<RequirementsTypeDO> requirementsTypeDOList = requirementsDao.listType();
        List<RequirementsTypeVO> requirementsTypeVOList = requirementsTypeDOList.stream().map(RequirementsTypeDO::buildRequirementsTypeVO).collect(Collectors.toList());
        return ResultBody.success(requirementsTypeVOList);
    }

    @Override
    public ResultBody publish(RequirementsInfoVO requirementsInfoVO, HttpServletRequest request) {
        //是否完成认证
//        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(requirementsInfoVO.getUserAccountId());
//        if (userAccountSimpleDTO == null || !userAccountSimpleDTO.getCompanyAuthStatus().toString().equals("1")){
//            return ResultBody.error(ResultEnum.COMPANY_NOT_VERIFY_ERROR);
//        }
        RequirementsInfoDO requirementsInfoDO = new RequirementsInfoDO(requirementsInfoVO);
        requirementsDao.addRequirementsInfo(requirementsInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody solveRequire(Integer requirementsInfoId, Integer userAccountId) {
        RequirementsInfoDO requirementsInfoDO = requirementsDao.getRequirementsInfoById(requirementsInfoId);
        if (!requirementsInfoDO.getUserAccountId().toString().equals(userAccountId.toString())){
            return ResultBody.error("无权限");
        }
        requirementsDao.solveRequire(requirementsInfoId);
        return ResultBody.success();
    }

    @Override
    public ResultBody listPublishPage(IndustryCaseQO industryCaseQO, HttpServletRequest request) {
        //查询对应地区的用户
        int count = requirementsDao.countListPublishPage(industryCaseQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), count));
        }
        Integer pageNo = industryCaseQO.getPageNo();
        industryCaseQO.buildCurrentPage();
        List<RequirementsInfoDO> requirementsInfoDOList = requirementsDao.listPublishPage(industryCaseQO);
        List<RequirementsInfoVO> requirementsInfoVOS = requirementsInfoDOList.stream().map(RequirementsInfoDO::buildRequirementsInfoVO).collect(Collectors.toList());
        Map<Integer, String> collect = requirementsDao.listType().stream().collect(Collectors.toMap(RequirementsTypeDO::getId, d -> d.getTypeName()));
        for (RequirementsInfoVO requirementsInfoVO : requirementsInfoVOS) {
            requirementsInfoVO.setRequirementTypeName(collect.get(requirementsInfoVO.getRequirementTypeId()));
        }
        return ResultBody.success(PageResult.buildPage(pageNo, industryCaseQO.getPageSize(), count, requirementsInfoVOS));
    }

    @Override
    public ResultBody deleteRequire(Integer requirementsInfoId, Integer userAccountId) {
        requirementsDao.removeRequire(requirementsInfoId);
        return ResultBody.success();
    }
}
