package com.mmc.csf.release.entity.tender;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * author:zhenjie
 * Date:2022/5/23
 * time:10:47
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ExcelTarget("ExcelTenderInfo")
public class ExcelTenderInfo implements Serializable {
    private static final long serialVersionUID = -3213483141870899916L;
    @Excel(name = "*序号", width = 25)
    @NotNull
    private String tenderInfoNo;
    @Excel(name = "*内容", width = 25)
    @NotNull
    @Size(max = 64, message = "标题长度过长")
    private String tenderTitle;
    @Excel(name = "*价格（万元）", width = 25)
    private BigDecimal tenderPrice;

}
