package com.mmc.csf.release.entity;

import com.mmc.csf.infomation.vo.IndustryCaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/19 11:27
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IndustryCaseDO implements Serializable {
    private static final long serialVersionUID = 664297500411067297L;
    private Integer id;
    private String caseTitle;
    private String caseAuthor;
    private Integer userAccountId;
    private String surfaceImg;
    private String caseContents;
    private Integer deleted;
    private String origin;
    private Date createTime;
    private Date updateTime;

    public IndustryCaseVO buildIndustryCaseVO(){
        return IndustryCaseVO.builder().id(id).caseTitle(caseTitle).caseAuthor(caseAuthor).origin(this.origin).userAccountId(userAccountId).surfaceImg(surfaceImg).
                caseContents(caseContents).createTime(createTime).updateTime(updateTime).build();
    }

    public IndustryCaseDO(IndustryCaseVO industryCaseVO){
        this.id = industryCaseVO.getId();
        this.caseTitle = industryCaseVO.getCaseTitle();
        this.caseAuthor = industryCaseVO.getCaseAuthor();
        this.userAccountId = industryCaseVO.getUserAccountId();
        this.surfaceImg = industryCaseVO.getSurfaceImg();
        this.caseContents = industryCaseVO.getCaseContents();
        this.origin = industryCaseVO.getOrigin();
    }

}
