package com.mmc.csf.release.feign.hystrix;

import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.infomation.dto.PilotCertificationInteriorDTO;
import com.mmc.csf.infomation.dto.TeamMessageDO;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.infomation.dto.UserBaseInfoDTO;
import com.mmc.csf.release.auth.qo.BUserAccountQO;
import com.mmc.csf.release.auth.qo.UserAccountQO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.flyer.vo.CurriculumOrderLogVO;
import com.mmc.csf.user.vo.ChangeUserPointVO;
import com.mmc.csf.user.vo.WxMsgVO;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:08
 */
@Slf4j
public class UserAppApiHystrix implements UserAppApi {
    @Override
    public UserAccountSimpleDTO feignGetUserSimpleInfo(Integer userAccountId, String token) {
        log.error("熔断：feignGetUserSimpleInfo：{}", userAccountId);
        return null;
    }

    @Override
    public List<Integer> feignListUserAccountIds(Integer provinceCode, Integer cityCode, Integer districtCode, String token) {
        log.error("熔断：feignListUserAccountIds：{}， {}， {}", provinceCode, cityCode, districtCode);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListBAccountPage(BUserAccountQO bUserAccountQO, String token) {
        log.error("熔断：feignListBAccountPage：{}", bUserAccountQO);
        return null;
    }

    @Override
    public List<UserAccountSimpleDTO> feignListAppUserAccount(UserAccountQO userAccountQO, String token) {
        log.error("熔断：feignListAppUserAccount：{}", userAccountQO);
        return null;
    }

    @Override
    public PilotCertificationInteriorDTO feignInteriorDetailPilot(Integer userAccountId) {
        log.error("熔断：feignInteriorDetailPilot：{}", userAccountId);
        return null;
    }

    @Override
    public ResultBody changeUserPoint(ChangeUserPointVO changePoint, String token) {
        log.error("发放积分 熔断：changeUserPoint：{}", JSONObject.toJSON(changePoint));
        return ResultBody.error(ResultEnum.OPERATION_SYS_ERROR);
    }

    @Override
    public List<Integer> feignGetPilotIdList(String token) {
        log.error("熔断：feignGetUserSimpleInfo");
        return null;
    }

    @Override
    public UserBaseInfoDTO feignGetUserBaseInfo(Integer userAccountId) {
        log.error("获取用户基本信息 熔断：feignGetUserBaseInfo：{}", userAccountId);
        return null;
    }

    @Override
    public ResultBody feignChangeUserPoints(String token,HttpServletRequest request, int changePoint, String reason) {
        log.error("获取积分日志 熔断：feignChangeUserPoints：{}", changePoint, reason);
        return null;
    }

    @Override
    public ResultBody feignCurriculumOrderLog(String token,HttpServletRequest request,CurriculumOrderLogVO curriculumOrderLogVO) {
        return null;
    }


    @Override
    public ResultBody feignSendWxMsg(String token, WxMsgVO ws) {
        log.error("发送消息 熔断：feignCurriculumOrderLog：{}", ws);
        return null;
    }

    @Override
    public Integer selectPilotTeamManagerId(String token, Integer pilotUserId) {
        return null;
    }

    @Override
    public String getPilotApplyPhone(String token, Integer pilotId) {
        return null;
    }


}
