package com.mmc.csf.release.dao;

import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.release.entity.requirements.RequirementsInfoDO;
import com.mmc.csf.release.entity.requirements.RequirementsTypeDO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 14:27
 */
@Mapper
public interface RequirementsDao {
    /**
     * 需求类型列表
     *
     * @return
     */
    List<RequirementsTypeDO> listType();

    /**
     * 添加需求
     *
     * @param requirementsInfoDO
     */
    void addRequirementsInfo(RequirementsInfoDO requirementsInfoDO);

    /**
     * 获取需求
     *
     * @param requirementsInfoId
     */
    RequirementsInfoDO getRequirementsInfoById(Integer requirementsInfoId);

    /**
     * 解决需求
     *
     * @param requirementsInfoId
     */
    void solveRequire(Integer requirementsInfoId);

    /**
     * 需求发布的数量
     *
     * @param industryCaseQO
     * @return
     */
    int countListPublishPage(IndustryCaseQO industryCaseQO);

    /**
     * 需求发布列表
     *
     * @param industryCaseQO
     * @return
     */
    List<RequirementsInfoDO> listPublishPage(IndustryCaseQO industryCaseQO);

    /**
     * 删除需求
     *
     * @param requirementsInfoId
     */
    void removeRequire(Integer requirementsInfoId);

    List<RequirementsTypeDO> listTypeReq(Integer id);

    Integer findPublish(RequirementsInfoDO requirementsInfoDO);

    void updatePublish(RequirementsInfoDO requirementsInfoDO);

    Integer findPublishCount(Integer id, Integer userAccountId);

    void requirementsDao(Integer id);

    List<RequirementsInfoDO> appPublishList();

    RequirementsInfoDO detailPublish(Integer id);
}
