package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.infomation.dto.*;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.TenderApplyVO;
import com.mmc.csf.infomation.vo.TenderNewsVO;
import com.mmc.csf.release.auth.dto.LoginSuccessDTO;
import com.mmc.csf.release.dao.TenderDao;
import com.mmc.csf.release.entity.TenderApplyDO;
import com.mmc.csf.release.entity.TenderInfoDO;
import com.mmc.csf.release.entity.TenderNewsDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.service.TenderService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * author:zhenjie
 * Date:2022/5/21
 * time:17:11
 */
@Service
public class TenderServiceImpl implements TenderService {

    @Autowired
    private TenderDao tenderDao;

    @Autowired
    private UserAppApi userAppApi;

    @Override
    @Transactional
    public ResultBody addTenderNews(MultipartFile file, TenderNewsVO tenderNewsVO) throws IOException {
        TenderNewsDO tenderNewsDO = new TenderNewsDO(tenderNewsVO);
        //检查快讯标题名称是否重复
        int count = tenderDao.countExistSameName(tenderNewsVO.getId(), tenderNewsDO.getTenderName());
        if(count > 0){
            return ResultBody.error(ResultEnum.EXIST_SAME_NAME_ERROR);
        }
        tenderDao.addTenderNewsDO(tenderNewsDO);
        List<TenderInfoDO> tenderInfoDOList = new ArrayList<>();
        ResultBody resultBody = listTenderInfo(file, tenderNewsDO);
        if(resultBody.getCode().toString().equals("200")){
            tenderInfoDOList = (List<TenderInfoDO>)resultBody.getResult();
        }else {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return resultBody;
        }
        tenderDao.batchAddTenderInfo(tenderInfoDOList);

        return ResultBody.success();
    }

    @Override
    public ResultBody listTenderNews(Integer pageNo, Integer pageSize, String tenderName, Date startTime, Date endTime, Integer using) {
        int count = tenderDao.countListTenderNews(tenderName, startTime, endTime, using);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count));
        }
        int itemIndex = (pageNo - 1) * pageSize;
        List<TenderNewsDO> list = tenderDao.listTenderNews(itemIndex, pageSize, tenderName, startTime, endTime, using);
        List<TenderNewsDTO> pageList = list.stream().map(d -> {
            return d.buildTenderNewsDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count, pageList));
    }

    @Override
    @Transactional
    public ResultBody updateTenderNews(MultipartFile file, TenderNewsVO tenderNewsVO) throws IOException {
        TenderNewsDO tenderNewsDO = new TenderNewsDO(tenderNewsVO);
        //检查快讯标题名称是否重复
        int count = tenderDao.countExistSameName(tenderNewsVO.getId(), tenderNewsDO.getTenderName());
        if(count > 0){
            return ResultBody.error(ResultEnum.EXIST_SAME_NAME_ERROR);
        }
        if(file != null && !file.isEmpty()){
            //把之前的覆盖
            //删除之前的
            tenderDao.batchRemoveTenderInfo(tenderNewsVO.getId());
            List<TenderInfoDO> tenderInfoDOList = new ArrayList<>();
            ResultBody resultBody = listTenderInfo(file, tenderNewsDO);
            if(resultBody.getCode().toString().equals("200")){
                tenderInfoDOList = (List<TenderInfoDO>)resultBody.getResult();
            }else {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return resultBody;
            }
            tenderDao.batchAddTenderInfo(tenderInfoDOList);
        }
        tenderDao.updateTenderNews(tenderNewsDO);
        return ResultBody.success();
    }

    private ResultBody listTenderInfo(MultipartFile file, TenderNewsDO tenderNewsDO) throws IOException {
        //TenderNewsDO tenderNewsDO = new TenderNewsDO(tenderNewsVO);
//        ImportParams params = new ImportParams();
//        params.setTitleRows(0);
//        params.setHeadRows(1);
//        File importFile = MultipartFileUtil.multipartFileToFile(file);
//        List<ExcelTenderInfo> list = ExcelImportUtil.importExcel(importFile, ExcelTenderInfo.class, params);
//        //删除必填项都为空的记录,有一个空的情况不去除，可以提醒用户重新上传
//        list.removeIf(d-> d.getTenderContent() == null && d.getTenderInfoNo() == null);
//        // 删除临时文件
//        MultipartFileUtil.delteTempFile(importFile);
//        //判断是否为空，空的话，要提醒
//        if(list.isEmpty()){
//            return ResultBody.error(ResultEnum.FILE_PARSE_ERROR);
//        }
//        //把之前的覆盖
//        //删除之前的
//        //tenderDao.batchRemoveTenderInfo(tenderNewsVO.getId());
//        //添加
//        List<TenderInfoDO> tenderInfoDOList = new ArrayList<>();
//        for(ExcelTenderInfo tenderInfo : list){
//            TenderInfoDO tenderInfoDO = new TenderInfoDO();
//            tenderInfoDO.setTenderNewsId(tenderNewsDO.getId());
//            //不能为空，
//            if(tenderInfo.getTenderInfoNo() == null || tenderInfo.getTenderInfoNo().trim().isEmpty()){
//                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//                return ResultBody.error(ResultEnum.TENDER_FORMAT_ERROR);
//            }else {
//                tenderInfoDO.setTenderInfoNo(tenderInfo.getTenderInfoNo().trim());
//            }
//            //判断长度，不能为空，且长度在64之内
//            if(tenderInfo.getTenderContent() == null || tenderInfo.getTenderContent().trim().isEmpty()){
//                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//                return ResultBody.error(ResultEnum.TENDER_FORMAT_ERROR);
//            }else {
//                if(tenderInfo.getTenderContent().trim().length() > 120){
//                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//                    return ResultBody.error(ResultEnum.TENDER_CONTENT_TOO_LONG_ERROR);
//                }
//                tenderInfoDO.setTenderContent(tenderInfo.getTenderContent().trim());
//            }
//            //做判断
//            BigDecimal beforeTenderPrice = BigDecimal.valueOf(10000000);
//            BigDecimal afterTenderPrice = tenderInfo.getTenderPrice() == null ? BigDecimal.ZERO : tenderInfo.getTenderPrice();
//            if( afterTenderPrice.compareTo(BigDecimal.ZERO) >= 0 && afterTenderPrice.compareTo(beforeTenderPrice)  <= 0 ){
//                tenderInfoDO.setTenderPrice(afterTenderPrice);
//            }else {
//                //抛出异常
//                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//                return ResultBody.error(ResultEnum.PRICE_TO_HIGH_ERROR);
//            }
//            tenderInfoDOList.add(tenderInfoDO);
//        }
//        return ResultBody.success(tenderInfoDOList);
        return ResultBody.success();
    }

    @Override
    public ResultBody removeTenderNews(Integer id) {
        tenderDao.removeTenderNews(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody listTenderInfo(Integer pageNo, Integer pageSize, Integer tenderNewsId) {
        int count = tenderDao.countListTenderInfo(tenderNewsId);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count));
        }
        int itemIndex = (pageNo - 1) * pageSize;
        List<TenderInfoDO> list = tenderDao.listTenderInfo(itemIndex, pageSize, tenderNewsId);
        List<TenderInfoDTO> pageList = list.stream().map(d -> {
            return d.buildTenderInfoDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count, pageList));
    }

    @Override
    public ResultBody updateTenderInfo(Integer id, String tenderContent, BigDecimal tenderPrice) {
        tenderDao.updateTenderInfo(id, tenderContent, tenderPrice);
        return ResultBody.success();
    }

    @Override
    public ResultBody addTenderApply(TenderApplyVO tenderApplyVO) {
        //判断之前有没有申请
        TenderApplyDO beforeTenderApplyDO = tenderDao.getTenderApplyByUId(tenderApplyVO.getUserAccountId(), tenderApplyVO.getTenderInfoId());
        if(beforeTenderApplyDO != null){
            return ResultBody.error(ResultEnum.HAS_BEEN_APPLY_ERROR);
        }
        UserAccountSimpleDTO userAccountSimpleDTO = userAppApi.feignGetUserSimpleInfo(tenderApplyVO.getUserAccountId());
        TenderApplyDO tenderApplyDO = new TenderApplyDO(tenderApplyVO);
        tenderApplyDO.setNickName(userAccountSimpleDTO.getNickName());
        tenderApplyDO.setUserName(userAccountSimpleDTO.getUserName());
        tenderApplyDO.setPhoneNum(userAccountSimpleDTO.getPhoneNum());
        tenderDao.addTenderApply(tenderApplyDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody listTenderApply(Integer pageNo, Integer pageSize, Integer tenderNewsId, Integer tenderInfoId, String keyword) {
        int count = tenderDao.countListTenderApply(tenderNewsId, tenderInfoId, keyword);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count));
        }
        int itemIndex = (pageNo - 1) * pageSize;
        List<TenderApplyDO> list = tenderDao.listTenderApply(itemIndex, pageSize, tenderNewsId, tenderInfoId, keyword);
        List<TenderApplyDTO> pageList = list.stream().map(d -> {
            return d.buildTenderApplyDTO();
        }).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count, pageList));
    }

    @Override
    public ResultBody listTenderInfoApp(Integer pageNo, Integer pageSize, Integer tenderNewsId, Integer userAccountId) {
        int count = tenderDao.countListTenderInfoApp(tenderNewsId);
        int itemIndex = (pageNo - 1) * pageSize;
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count));
        }
        List<TenderInfoDO> list = tenderDao.listTenderInfoApp(itemIndex, pageSize, tenderNewsId);
        List<AppTenderInfoDTO> pageList = list.stream().map(d -> {
            return d.buildAppTenderInfoDTO();
        }).collect(Collectors.toList());
        List<TenderApplyDO> applyDOList = tenderDao.listAppTenderApply(tenderNewsId, userAccountId);
        if(userAccountId == null){
            return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count, pageList));
        }
        for(AppTenderInfoDTO appTenderInfoDTO : pageList){
            for(TenderApplyDO tenderApplyDO : applyDOList){
                if(tenderApplyDO.getTenderInfoId().toString().equals(appTenderInfoDTO.getId().toString())){
                    appTenderInfoDTO.setApply(1);
                    break;
                }
            }
        }
        return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count, pageList));
    }

    @Override
    public ResultBody listTenderInfoAppLatest(Integer pageNo, Integer pageSize, Integer userAccountId) {
        TenderNewsDO tenderNewsDO = tenderDao.latestTenderNewsDO();
        if( tenderNewsDO == null ){
            return ResultBody.success(PageResult.buildPage(pageNo, pageSize, 0));
        }
        int count = tenderDao.countListTenderInfoApp(tenderNewsDO.getId());
        int itemIndex = (pageNo - 1) * pageSize;
        List<TenderInfoDO> list = tenderDao.listTenderInfoApp(itemIndex, pageSize, tenderNewsDO.getId());
        List<AppTenderInfoDTO> pageList = list.stream().map(d -> {
            return d.buildAppTenderInfoDTO();
        }).collect(Collectors.toList());
        if(userAccountId == null){
            return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count, pageList));
        }
        List<TenderApplyDO> applyDOList = tenderDao.listAppTenderApply(tenderNewsDO.getId(), userAccountId);
        for(AppTenderInfoDTO appTenderInfoDTO : pageList){
            for(TenderApplyDO tenderApplyDO : applyDOList){
                if(tenderApplyDO.getTenderInfoId().toString().equals(appTenderInfoDTO.getId().toString())){
                    appTenderInfoDTO.setApply(1);
                    break;
                }
            }
        }
        return ResultBody.success(PageResult.buildPage(pageNo, pageSize, count, pageList));
    }

    @Override
    public ResultBody listNewTenderInfo(IndustryCaseQO industryCaseQO,
                                        LoginSuccessDTO loginSuccessDTO) {
        //查询对应地区的用户， 默认查广东
        industryCaseQO.setProvinceCode(industryCaseQO.getProvinceCode() == null  ? 440000 : industryCaseQO.getProvinceCode());
        List<Integer> userIds = userAppApi.feignListUserAccountIds(industryCaseQO.getProvinceCode() , industryCaseQO.getCityCode(), industryCaseQO.getDistrictCode());
        industryCaseQO.setUserIds(userIds);
        int count = tenderDao.countNewListTenderInfo(industryCaseQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(0, 0, count));
        }
        Integer pageNo = industryCaseQO.getPageNo();
        industryCaseQO.buildCurrentPage();
        List<TenderInfoDO> list = tenderDao.listNewListTenderInfo(industryCaseQO);
        List<Integer> tenderInfoIds = list.stream().map(TenderInfoDO::getId).collect(Collectors.toList());
        List<AppTenderInfoDTO> pageList = list.stream().map(d -> {
            return d.buildAppTenderInfoDTO();
        }).collect(Collectors.toList());
        if (loginSuccessDTO != null) {
            //查出已申请过的并做标记
            List<Integer> applyTenderInfoIds = tenderDao.listApplyTenderInfoIds(tenderInfoIds, loginSuccessDTO.getUserAccountId());
            if (CollectionUtils.isNotEmpty(applyTenderInfoIds)) {
                pageList.forEach(d->{
                    if(applyTenderInfoIds.contains(d.getId())){
                        d.setApply(1);
                    }else {
                        d.setApply(0);
                    }
                });
            }
        }
        return ResultBody.success(PageResult.buildPage(pageNo, industryCaseQO.getPageSize(), count, pageList));
    }
}
