package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.release.auth.qo.UserAccountQO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.BackstageForumDao;
import com.mmc.csf.release.dao.DynamicDAO;
import com.mmc.csf.release.entity.forum.ForumDynamicDO;
import com.mmc.csf.release.entity.forum.ForumResourceDO;
import com.mmc.csf.release.entity.forum.ForumVideoDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.forum.dto.DynamicInfoDTO;
import com.mmc.csf.release.forum.qo.DynamicQO;
import com.mmc.csf.release.forum.vo.UserBaseInfoVO;
import com.mmc.csf.release.service.BackstageForumService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author LW
 *
 * @date 2023/6/19 10:47 概要：
 */
@Service
public class BackstageForumServiceImpl implements BackstageForumService {
  @Autowired BackstageForumDao backstageForumDao;
  @Autowired DynamicDAO dynamicDAO;
  @Autowired UserAppApi userAppApi;

  @Override
  public PageResult listDynamic(DynamicQO dynamic, HttpServletRequest request) {
    List<Integer> userIds = null;
    if (dynamic.getKeyword() != null) {
      UserAccountQO userAccountQO = new UserAccountQO();
      userAccountQO.setKeyword(dynamic.getKeyword());
      // 获取筛选的用户id
      List<UserAccountSimpleDTO> userAccountSimpleDTOS =
          userAppApi.feignListAppUserAccount(userAccountQO, request.getHeader(TokenConstant.TOKEN));
      if (CollectionUtils.isNotEmpty(userAccountSimpleDTOS)) {
        // 获取用户id
        userIds =
            userAccountSimpleDTOS.stream()
                .map(UserAccountSimpleDTO::getId)
                .collect(Collectors.toList());
      }
      if (userIds == null) {
        return PageResult.buildPage(dynamic.getPageNo(), dynamic.getPageSize(), 0);
      }
    }
    int count = backstageForumDao.countDynamic(userIds);
    if (count == 0) {
      return PageResult.buildPage(dynamic.getPageNo(), dynamic.getPageSize(), count);
    }
    int itemIndex = (dynamic.getPageNo() - 1) * dynamic.getPageSize();
    // 获取动态信息
    List<ForumDynamicDO> dynamicList =
        backstageForumDao.listDynamicInfo(userIds, itemIndex, dynamic.getPageSize());
    // 动态id集合
    List<Integer> ids =
        dynamicList.stream().map(ForumDynamicDO::getId).collect(Collectors.toList());
    // 根据id集合查询图片
    List<ForumResourceDO> forumImageList = dynamicDAO.listDynamicPicture(ids);
    Map<Integer, List<ForumResourceDO>> ImageMap =
        forumImageList.stream().collect(Collectors.groupingBy(ForumResourceDO::getDynamicId));
    // 获取视频信息
    List<ForumVideoDO> forumVideoList = dynamicDAO.listDynamicVideo(ids);
    // 获取查询到的列表用户信息
    // 获取用户信息
    Set<Integer> ListUserIds =
        dynamicList.stream().map(ForumDynamicDO::getUserAccountId).collect(Collectors.toSet());
    List<Integer> userIdList = new ArrayList<>(ListUserIds);
    UserAccountQO accountQO = new UserAccountQO();
    accountQO.setUserIds(userIdList);
    List<UserAccountSimpleDTO> userAccountSimpleList =
        userAppApi.feignListAppUserAccount(accountQO, request.getHeader(TokenConstant.TOKEN));
    Map<Integer, UserAccountSimpleDTO> userAccountInfoMap =
        userAccountSimpleList.stream()
            .collect(Collectors.toMap(UserAccountSimpleDTO::getId, Function.identity()));
    List<DynamicInfoDTO> list =
        dynamicList.stream()
            .map(
                d -> {
                  DynamicInfoDTO dynamicInfoDTO = d.buildDynamicInfoDTO();
                  UserAccountSimpleDTO userAccountSimpleDTO =
                      userAccountInfoMap.get(d.getUserAccountId());
                  if (userAccountSimpleDTO != null) {
                    UserBaseInfoVO userBaseInfoVO = new UserBaseInfoVO();
                    userBaseInfoVO.setNickName(userAccountSimpleDTO.getNickName());
                    userBaseInfoVO.setUserImg(userAccountSimpleDTO.getUserImg());
                    userBaseInfoVO.setUserName(userAccountSimpleDTO.getUserName());
                    userBaseInfoVO.setPhone(userAccountSimpleDTO.getPhoneNum());
                    userBaseInfoVO.setUid(userAccountSimpleDTO.getUid());
                    dynamicInfoDTO.setUserBaseInfo(userBaseInfoVO);
                  }
                  return dynamicInfoDTO;
                })
            .collect(Collectors.toList());
    return PageResult.buildPage(dynamic.getPageNo(), dynamic.getPageSize(), count, list);
  }
}
